package org.ourfilesystem.db;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.util.Iterator;
import java.util.LinkedList;

import org.ourfilesystem.utilities.FileLongIndex;

public class PeerPostHoleList {
	
	private LinkedList<PostHoles> HoleList;
	
	public PeerPostHoleList(FileLongIndex idx) {
		HoleList = new LinkedList<PostHoles>();
		addHole(1, idx.getMaxValue());
		Iterator<Object> i = idx.list().iterator();
		while (i.hasNext()) {
			Long v = (Long)i.next();
			newPostNumber(v);
		}
	}
	
	public synchronized void addHole(long last, long newnum) {
		HoleList.add(new PostHoles(last, newnum));
	}

	public synchronized void newPostNumber(long num) {
		LinkedList<PostHoles> newholes = new LinkedList<PostHoles>();
		Iterator<PostHoles> i = HoleList.iterator();
		while (i.hasNext()) {
			PostHoles ph = i.next();
			PostHoles nph = ph.newPostReceived(num);
			if (ph.isDone()) {
				i.remove();
			}
			if (nph != null) {
				newholes.add(nph);
			}
		}
		HoleList.addAll(newholes);
	}
	
	public LinkedList<PostHoles> getHoles() {
		return HoleList;
	}
	
}
