package org.ourfilesystem.db;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import org.ourfilesystem.security.PublicKeySetSigned;
import org.ourfilesystem.security.SignedDigest;

public class Peer {
	
	/**
	 * The signed public keys for this peer.
	 */
	private PublicKeySetSigned PeerKeysAndIdentity;
	
	/**
	 * Signature for the location information for this peer.
	 */
	private SignedDigest LocationSignature;

	/**
	 * How does a peer know how to communicate with this peer.
	 */
	private Object Location;
	
	/**
	 * The update number.  We use this know if we need to get
	 * the updated location information if this number
	 * is greater than what we currently have. 
	 */
	private long UpdateCount;
	
	/**
	 * The nickname the user gives to himself.
	 */
	private String Nickname;
	
	/**
	 * An introduction in case we're a new peer requesting
	 * a signature.
	 */
	private String Introduction;
	
	public Object getLocation() {
		return Location;
	}

	public void setLocation(Object location) {
		Location = location;
	}

	public PublicKeySetSigned getPeerKeysAndIdentity() {
		return PeerKeysAndIdentity;
	}

	public void setPeerKeysAndIdentity(PublicKeySetSigned peerKeysAndIdentity) {
		PeerKeysAndIdentity = peerKeysAndIdentity;
	}
	
	public boolean equals(Object o) {
		if (o == null) { return false; }
		if (!(o instanceof Peer)) { return false; }
		Peer p = (Peer)o;
		return p.getPeerKeysAndIdentity().getSignature().getDigest().equals(
					getPeerKeysAndIdentity().getSignature().getDigest()
				);
	}
	
	public int hashCode() {
		return getPeerKeysAndIdentity().getSignature().getDigest().hashCode();
	}

	public long getUpdateCount() {
		return UpdateCount;
	}

	public void setUpdateCount(long updateCount) {
		UpdateCount = updateCount;
	}

	public String getIntroduction() {
		return Introduction;
	}

	public void setIntroduction(String introduction) {
		Introduction = introduction;
	}

	public SignedDigest getLocationSignature() {
		return LocationSignature;
	}

	public void setLocationSignature(SignedDigest locationSignature) {
		LocationSignature = locationSignature;
	}

	public String getNickSig() {
		PublicKeySetSigned pub = this.getPeerKeysAndIdentity();
		String nic = "";
		if (pub != null) {
			SignedDigest sg = pub.getSignature();
			if (sg != null) {
				Object dig = sg.getDigest();
				if (dig != null) {
					nic = dig.toString().substring(0, 10);
				}
			}
		}
		return getNickname() + " (" + nic + ")";
	}
	
	public String getNickname() {
		return Nickname;
	}

	public void setNickname(String nickname) {
		Nickname = nickname;
	}

}
