/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.io.block;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.metanotion.io.RAIFile;
import net.metanotion.io.RandomAccessInterface;
import net.metanotion.io.Serializer;
import net.metanotion.io.block.FreeListBlock;
import net.metanotion.io.block.index.BSkipList;
import net.metanotion.io.data.IdentityBytes;
import net.metanotion.io.data.IntBytes;
import net.metanotion.io.data.StringBytes;
import net.metanotion.io.data.UTF8StringBytes;
import net.metanotion.util.skiplist.SkipIterator;

public class BlockFile {
    public static final int PAGESIZE = 1024;
    public static final long OFFSET_MOUNTED = 20L;
    public final Log log = I2PAppContext.getGlobalContext().logManager().getLog(BlockFile.class);
    public final RandomAccessInterface file;
    private static final int MAJOR = 1;
    private static final int MINOR = 1;
    private static final long MAGIC_BASE = 3549362387302744064L;
    private static final long MAGIC = 3549362387302744321L;
    private long magicBytes = 3549362387302744321L;
    public static final int MAGIC_CONT = 1129270868;
    public static final int METAINDEX_PAGE = 2;
    private static final long MAX_LEN = 0x7FFFFFFFFFFL;
    private long fileLen = 2048L;
    private int freeListStart = 0;
    private int mounted = 0;
    public int spanSize = 16;
    private final boolean _wasMounted;
    private BSkipList metaIndex;
    private FreeListBlock flb;
    private final HashMap openIndices = new HashMap();

    private void mount() throws IOException {
        this.file.seek(20L);
        this.mounted = 1;
        this.file.writeShort(this.mounted);
    }

    private void writeSuperBlock() throws IOException {
        this.file.seek(0L);
        this.file.writeLong(this.magicBytes);
        this.file.writeLong(this.fileLen);
        this.file.writeInt(this.freeListStart);
        this.file.writeShort(this.mounted);
        this.file.writeShort(this.spanSize);
    }

    private void readSuperBlock() throws IOException {
        this.file.seek(0L);
        this.magicBytes = this.file.readLong();
        this.fileLen = this.file.readLong();
        this.freeListStart = this.file.readUnsignedInt();
        this.mounted = this.file.readUnsignedShort();
        this.spanSize = this.file.readUnsignedShort();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: BlockFile file");
            return;
        }
        boolean init = !new File(args[0]).exists();
        try {
            RAIFile raif = new RAIFile(new File(args[0]), true, true);
            BlockFile bf = new BlockFile(raif, init);
            bf.bfck(true);
            bf.close();
            raif.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int writeMultiPageData(byte[] data, int page, int[] curPageOff, int[] nextPage) throws IOException {
        int len;
        int pageCounter = curPageOff[0];
        int curNextPage = nextPage[0];
        int curPage = page;
        for (int dct = 0; dct < data.length; dct += Math.min(len, data.length - dct)) {
            len = 1024 - pageCounter;
            if (len <= 0) {
                if (curNextPage == 0) {
                    curNextPage = this.allocPage();
                    BlockFile.pageSeek(this.file, curNextPage);
                    this.file.writeInt(1129270868);
                    this.file.writeInt(0);
                    BlockFile.pageSeek(this.file, curPage);
                    this.file.skipBytes(4);
                    this.file.writeInt(curNextPage);
                }
                BlockFile.pageSeek(this.file, curNextPage);
                curPage = curNextPage;
                int magic = this.file.readInt();
                if (magic != 1129270868) {
                    throw new IOException("Bad SkipSpan continuation magic number 0x" + Integer.toHexString(magic) + " on page " + curNextPage);
                }
                curNextPage = this.file.readUnsignedInt();
                pageCounter = 8;
                len = 1024 - pageCounter;
            }
            this.file.write(data, dct, Math.min(len, data.length - dct));
            pageCounter += Math.min(len, data.length - dct);
        }
        nextPage[0] = curNextPage;
        curPageOff[0] = pageCounter;
        return curPage;
    }

    public int readMultiPageData(byte[] arr, int page, int[] curPageOff, int[] nextPage) throws IOException {
        int res;
        int pageCounter = curPageOff[0];
        int curNextPage = nextPage[0];
        int curPage = page;
        for (int dct = 0; dct < arr.length; dct += res) {
            int len = 1024 - pageCounter;
            if (len <= 0) {
                if (curNextPage <= 0) {
                    throw new IOException("not enough pages to read data still need " + (arr.length - dct));
                }
                BlockFile.pageSeek(this.file, curNextPage);
                int magic = this.file.readInt();
                if (magic != 1129270868) {
                    throw new IOException("Bad SkipSpan continuation magic number 0x" + Integer.toHexString(magic) + " on page " + curNextPage);
                }
                curPage = curNextPage;
                curNextPage = this.file.readUnsignedInt();
                pageCounter = 8;
                len = 1024 - pageCounter;
            }
            if ((res = this.file.read(arr, dct, Math.min(len, arr.length - dct))) == -1) {
                throw new IOException();
            }
            pageCounter += Math.min(len, arr.length - dct);
        }
        nextPage[0] = curNextPage;
        curPageOff[0] = pageCounter;
        return curPage;
    }

    public int skipMultiPageBytes(int length, int page, int[] curPageOff, int[] nextPage) throws IOException {
        int res;
        int pageCounter = curPageOff[0];
        int curNextPage = nextPage[0];
        int curPage = page;
        for (int dct = 0; dct < length; dct += res) {
            int len = 1024 - pageCounter;
            if (len <= 0) {
                if (curNextPage <= 0) {
                    throw new IOException("not enough pages to skip");
                }
                BlockFile.pageSeek(this.file, curNextPage);
                int magic = this.file.readInt();
                if (magic != 1129270868) {
                    throw new IOException("Bad SkipSpan continuation magic number 0x" + Integer.toHexString(magic) + " on page " + curNextPage);
                }
                curPage = curNextPage;
                curNextPage = this.file.readUnsignedInt();
                pageCounter = 8;
                len = 1024 - pageCounter;
            }
            res = Math.min(len, length - dct);
            this.file.skipBytes(res);
            pageCounter += res;
        }
        nextPage[0] = curNextPage;
        curPageOff[0] = pageCounter;
        return curPage;
    }

    public BlockFile(RandomAccessInterface rai) throws IOException {
        this(rai, false);
    }

    public BlockFile(RandomAccessFile raf) throws IOException {
        this(new RAIFile(raf), false);
    }

    public BlockFile(RandomAccessFile raf, boolean init) throws IOException {
        this(new RAIFile(raf), init);
    }

    public BlockFile(File f, boolean init) throws IOException {
        this(new RAIFile(f, true, true), init);
    }

    public BlockFile(RandomAccessInterface rai, boolean init) throws IOException {
        if (rai == null) {
            throw new NullPointerException();
        }
        this.file = rai;
        if (init) {
            this.file.setLength(this.fileLen);
            this.writeSuperBlock();
            BSkipList.init(this, 2, this.spanSize);
        }
        this.readSuperBlock();
        if (this.magicBytes != 3549362387302744321L) {
            if ((this.magicBytes & 0x3141DE4932500000L) == 3549362387302744064L) {
                throw new IOException("Expected 1.1 but got " + (this.magicBytes >> 8 & 0xFFL) + '.' + (this.magicBytes & 0xFFL));
            }
            throw new IOException("Bad magic number");
        }
        boolean bl = this._wasMounted = this.mounted != 0;
        if (this._wasMounted) {
            this.log.warn("Warning - file was not previously closed");
        }
        if (this.fileLen != this.file.length()) {
            throw new IOException("Expected file length " + this.fileLen + " but actually " + this.file.length());
        }
        if (rai.canWrite()) {
            this.mount();
        }
        this.metaIndex = new BSkipList(this.spanSize, this, 2, new StringBytes(), new IntBytes());
    }

    public boolean wasMounted() {
        return this._wasMounted;
    }

    public static void pageSeek(RandomAccessInterface file, int page) throws IOException {
        if (page < 2) {
            throw new IOException("Negative page or superblock access attempt: " + page);
        }
        file.seek(((long)page - 1L) * 1024L);
    }

    public int allocPage() throws IOException {
        if (this.freeListStart != 0) {
            try {
                if (this.flb == null) {
                    this.flb = new FreeListBlock(this.file, this.freeListStart);
                }
                if (!this.flb.isEmpty()) {
                    if (this.log.shouldLog(10)) {
                        this.log.debug("Alloc from " + this.flb);
                    }
                    return this.flb.takePage();
                }
                if (this.log.shouldLog(10)) {
                    this.log.debug("Alloc returning empty " + this.flb);
                }
                this.freeListStart = this.flb.getNextPage();
                this.writeSuperBlock();
                int rv = this.flb.page;
                this.flb = null;
                return rv;
            }
            catch (IOException ioe) {
                this.log.error("Discarding corrupt free list block page " + this.freeListStart, ioe);
                this.freeListStart = 0;
            }
        }
        long offset = this.file.length();
        this.fileLen = offset + 1024L;
        this.file.setLength(this.fileLen);
        this.writeSuperBlock();
        return (int)(offset / 1024L + 1L);
    }

    public void freePage(int page) {
        if (page <= 2) {
            this.log.error("Bad page free attempt: " + page);
            return;
        }
        try {
            if (this.freeListStart == 0) {
                this.freeListStart = page;
                FreeListBlock.initPage(this.file, page);
                this.writeSuperBlock();
                if (this.log.shouldLog(10)) {
                    this.log.debug("Freed page " + page + " as new FLB");
                }
                return;
            }
            try {
                if (this.flb == null) {
                    this.flb = new FreeListBlock(this.file, this.freeListStart);
                }
                if (this.flb.isFull()) {
                    if (this.log.shouldLog(10)) {
                        this.log.debug("Full: " + this.flb);
                    }
                    FreeListBlock.initPage(this.file, page);
                    if (this.flb.getNextPage() == 0) {
                        this.flb.setNextPage(page);
                    } else {
                        this.flb = new FreeListBlock(this.file, page);
                        this.flb.setNextPage(this.freeListStart);
                        this.freeListStart = page;
                        this.writeSuperBlock();
                    }
                    if (this.log.shouldLog(10)) {
                        this.log.debug("Freed page " + page + " to full " + this.flb);
                    }
                    return;
                }
                this.flb.addPage(page);
                if (this.log.shouldLog(10)) {
                    this.log.debug("Freed page " + page + " to " + this.flb);
                }
            }
            catch (IOException ioe) {
                this.log.error("Discarding corrupt free list block page " + this.freeListStart, ioe);
                this.freeListStart = page;
                FreeListBlock.initPage(this.file, page);
                this.writeSuperBlock();
                this.flb = null;
            }
        }
        catch (IOException ioe) {
            this.log.error("Error freeing page: " + page, ioe);
        }
    }

    public BSkipList getIndex(String name, Serializer key, Serializer val) throws IOException {
        BSkipList bsl = (BSkipList)this.openIndices.get(name);
        if (bsl != null) {
            return bsl;
        }
        Integer page = (Integer)this.metaIndex.get((Comparable)((Object)name));
        if (page == null) {
            return null;
        }
        bsl = new BSkipList(this.spanSize, this, page, key, val, true);
        if (this.file.canWrite()) {
            this.log.info("Checking skiplist " + name + " in blockfile " + this.file);
            if (bsl.bslck(true, false)) {
                this.log.logAlways(30, "Repaired skiplist " + name + " in blockfile " + this.file);
            } else {
                this.log.info("No errors in skiplist " + name + " in blockfile " + this.file);
            }
        }
        this.openIndices.put(name, bsl);
        return bsl;
    }

    public BSkipList makeIndex(String name, Serializer key, Serializer val) throws IOException {
        if (this.metaIndex.get((Comparable)((Object)name)) != null) {
            throw new IOException("Index already exists");
        }
        int page = this.allocPage();
        this.metaIndex.put((Comparable)((Object)name), page);
        BSkipList.init(this, page, this.spanSize);
        BSkipList bsl = new BSkipList(this.spanSize, this, page, key, val, true);
        this.openIndices.put(name, bsl);
        return bsl;
    }

    public void delIndex(String name) throws IOException {
        Integer page = (Integer)this.metaIndex.remove((Comparable)((Object)name));
        if (page == null) {
            return;
        }
        IdentityBytes nb = new IdentityBytes();
        BSkipList bsl = new BSkipList(this.spanSize, this, page, nb, nb, true);
        bsl.delete();
    }

    public void closeIndex(String name) {
        BSkipList bsl = (BSkipList)this.openIndices.remove(name);
        if (bsl != null) {
            bsl.flush();
        }
    }

    public void close() throws IOException {
        if (this.metaIndex == null) {
            return;
        }
        this.metaIndex.close();
        this.metaIndex = null;
        Set oi = this.openIndices.keySet();
        for (Object k : oi) {
            BSkipList bsl = (BSkipList)this.openIndices.get(k);
            bsl.close();
        }
        if (this.file.canWrite()) {
            this.file.seek(20L);
            this.file.writeShort(0);
        }
    }

    public boolean bfck(boolean fix) {
        this.log.info("magic bytes " + this.magicBytes);
        this.log.info("fileLen " + this.fileLen);
        this.log.info("freeListStart " + this.freeListStart);
        this.log.info("mounted " + this.mounted);
        this.log.info("spanSize " + this.spanSize);
        this.log.info("Metaindex");
        this.log.info("Checking meta index in blockfile " + this.file);
        boolean rv = this.metaIndex.bslck(fix, true);
        if (rv) {
            this.log.warn("Repaired meta index in blockfile " + this.file);
        } else {
            this.log.info("No errors in meta index in blockfile " + this.file);
        }
        int items = 0;
        SkipIterator iter = this.metaIndex.iterator();
        while (iter.hasNext()) {
            String slname = (String)((Object)iter.nextKey());
            Integer page = (Integer)iter.next();
            this.log.info("List " + slname + " page " + page);
            try {
                BSkipList bsl = this.getIndex(slname, new UTF8StringBytes(), new IdentityBytes());
                if (bsl == null) {
                    this.log.error("Can't find list? " + slname);
                    continue;
                }
                ++items;
            }
            catch (IOException ioe) {
                this.log.error("Error with list " + slname, ioe);
            }
        }
        this.log.info("Checked meta index and " + items + " skiplists");
        return rv;
    }
}

