/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import net.i2p.I2PAppContext;
import net.i2p.crypto.EntropyHarvester;
import net.i2p.data.Base64;
import net.i2p.util.BufferedRandomSource;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class PooledRandomSource
extends RandomSource {
    private Log _log;
    protected RandomSource[] _pool;
    protected volatile int _nextPool;
    public static final int POOL_SIZE = 16;
    public static final String PROP_BUFFER_SIZE = "i2p.prng.totalBufferSizeKB";

    public PooledRandomSource(I2PAppContext context) {
        super(context);
        this._log = context.logManager().getLog(PooledRandomSource.class);
        this.initializePool(context);
    }

    protected void initializePool(I2PAppContext context) {
        this._pool = new RandomSource[16];
        String totalSizeProp = context.getProperty(PROP_BUFFER_SIZE);
        int totalSize = -1;
        if (totalSizeProp != null) {
            try {
                totalSize = Integer.parseInt(totalSizeProp);
            }
            catch (NumberFormatException nfe) {
                totalSize = -1;
            }
        }
        byte[] buf = new byte[1024];
        this.initSeed(buf);
        for (int i = 0; i < 16; ++i) {
            this._pool[i] = totalSize < 0 ? new BufferedRandomSource(context) : (totalSize > 0 ? new BufferedRandomSource(context, totalSize * 1024 / 16) : new RandomSource(context));
            this._pool[i].setSeed(buf);
            if (i <= 0) continue;
            this._pool[i - 1].nextBytes(buf);
            this._pool[i].setSeed(buf);
        }
        this._pool[0].nextBytes(buf);
        System.out.println("seeded and initialized: " + Base64.encode(buf));
        this._nextPool = 0;
    }

    private final RandomSource pickPRNG() {
        int cur = this._nextPool;
        RandomSource rv = this._pool[cur %= 16];
        ++cur;
        this._nextPool = cur %= 16;
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextInt(int n) {
        RandomSource prng;
        RandomSource randomSource = prng = this.pickPRNG();
        synchronized (randomSource) {
            return prng.nextInt(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextLong(long n) {
        RandomSource prng;
        RandomSource randomSource = prng = this.pickPRNG();
        synchronized (randomSource) {
            return prng.nextLong(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextBoolean() {
        RandomSource prng;
        RandomSource randomSource = prng = this.pickPRNG();
        synchronized (randomSource) {
            return prng.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] buf) {
        RandomSource prng;
        RandomSource randomSource = prng = this.pickPRNG();
        synchronized (randomSource) {
            prng.nextBytes(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double nextDouble() {
        RandomSource prng;
        RandomSource randomSource = prng = this.pickPRNG();
        synchronized (randomSource) {
            return prng.nextDouble();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float nextFloat() {
        RandomSource prng;
        RandomSource randomSource = prng = this.pickPRNG();
        synchronized (randomSource) {
            return prng.nextFloat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double nextGaussian() {
        RandomSource prng;
        RandomSource randomSource = prng = this.pickPRNG();
        synchronized (randomSource) {
            return prng.nextGaussian();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextInt() {
        RandomSource prng;
        RandomSource randomSource = prng = this.pickPRNG();
        synchronized (randomSource) {
            return prng.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextLong() {
        RandomSource prng;
        RandomSource randomSource = prng = this.pickPRNG();
        synchronized (randomSource) {
            return prng.nextLong();
        }
    }

    public EntropyHarvester harvester() {
        RandomSource prng = this.pickPRNG();
        return prng.harvester();
    }
}

