/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import net.i2p.util.Log;

public class HTTPSendData {
    private static final Log _log = new Log(HTTPSendData.class);

    public static boolean postData(String url, long length, InputStream dataToSend) {
        try {
            URL rurl = new URL(url);
            return HTTPSendData.postData(rurl, length, dataToSend);
        }
        catch (MalformedURLException mue) {
            return false;
        }
    }

    public static boolean postData(URL url, long length, InputStream dataToSend) {
        try {
            int read;
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-length", "" + length);
            OutputStream out = con.getOutputStream();
            byte[] buf = new byte[1024];
            long sent = 0L;
            GZIPOutputStream zipOut = new GZIPOutputStream(out);
            while ((read = dataToSend.read(buf)) != -1) {
                zipOut.write(buf, 0, read);
                if ((sent += (long)read) < length) continue;
            }
            zipOut.flush();
            zipOut.finish();
            zipOut.close();
            out.close();
            int rv = con.getResponseCode();
            _log.debug("Posted " + sent + " bytes: " + rv);
            return length == sent;
        }
        catch (IOException ioe) {
            _log.error("Error posting the data", ioe);
            return false;
        }
    }
}

