/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;

public class GetDateMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 32;
    private String _version;

    public GetDateMessage() {
    }

    public GetDateMessage(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        if (size > 0) {
            try {
                this._version = DataHelper.readString(in);
            }
            catch (DataFormatException dfe) {
                throw new I2CPMessageException("Bad version string", dfe);
            }
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._version == null) {
            return new byte[0];
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(16);
        try {
            DataHelper.writeString(os, this._version);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 32;
    }

    public int hashCode() {
        return 0x20 ^ DataHelper.hashCode(this._version);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GetDateMessage) {
            return DataHelper.eq(this._version, ((GetDateMessage)object)._version);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[GetDateMessage]");
        buf.append("\n\tVersion: ").append(this._version);
        return buf.toString();
    }
}

