/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.BWLimitsMessageHandler;
import net.i2p.client.ClientWriterRunner;
import net.i2p.client.DestReplyMessageHandler;
import net.i2p.client.I2CPMessageHandler;
import net.i2p.client.I2CPSSLSocketFactory;
import net.i2p.client.I2PClientMessageHandlerMap;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl2;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.internal.InternalClientManager;
import net.i2p.internal.QueuedI2CPMessageReader;

class I2PSimpleSession
extends I2PSessionImpl2 {
    public I2PSimpleSession(I2PAppContext context, Properties options) throws I2PSessionException {
        this._context = context;
        this._log = context.logManager().getLog(I2PSimpleSession.class);
        this._handlerMap = new SimpleMessageHandlerMap(context);
        this._closed = true;
        this._closing = false;
        if (options == null) {
            options = System.getProperties();
        }
        this.loadConfig(options);
    }

    public void connect() throws I2PSessionException {
        this._closed = false;
        try {
            if (this._context.isRouterContext()) {
                InternalClientManager mgr = this._context.internalClientManager();
                if (mgr == null) {
                    throw new I2PSessionException("Router is not ready for connections");
                }
                this._queue = mgr.connect();
                this._reader = new QueuedI2CPMessageReader(this._queue, (I2CPMessageReader.I2CPMessageEventListener)this);
            } else {
                this._socket = Boolean.valueOf(this.getOptions().getProperty("i2cp.SSL")) != false ? I2CPSSLSocketFactory.createSocket(this._context, this._hostname, this._portNum) : new Socket(this._hostname, this._portNum);
                this._out = this._socket.getOutputStream();
                this._out.write(42);
                this._out.flush();
                this._writer = new ClientWriterRunner(this._out, this);
                InputStream in = this._socket.getInputStream();
                this._reader = new I2CPMessageReader(in, this);
            }
            this._reader.startReading();
        }
        catch (UnknownHostException uhe) {
            this._closed = true;
            throw new I2PSessionException(this.getPrefix() + "Cannot connect to the router on " + this._hostname + ':' + this._portNum, uhe);
        }
        catch (IOException ioe) {
            this._closed = true;
            throw new I2PSessionException(this.getPrefix() + "Cannot connect to the router on " + this._hostname + ':' + this._portNum, ioe);
        }
    }

    public void updateOptions(Properties options) {
    }

    private static class SimpleMessageHandlerMap
    extends I2PClientMessageHandlerMap {
        public SimpleMessageHandlerMap(I2PAppContext context) {
            int highest = Math.max(35, 23);
            this._handlers = new I2CPMessageHandler[highest + 1];
            this._handlers[35] = new DestReplyMessageHandler(context);
            this._handlers[23] = new BWLimitsMessageHandler(context);
        }
    }
}

