/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.test.utilities;

import java.io.File;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileDigestIndex;
import org.ourfilesystem.utilities.FileLongIndex;

public class FileIndexTest {
    @Test
    public void testDig() {
        try {
            File f = new File("dig.idx");
            if (f.exists()) {
                f.delete();
            }
            FileDigestIndex di = new FileDigestIndex("digdata", "dig.idx");
            Random r = new Random();
            byte[] b0 = new byte[10];
            r.nextBytes(b0);
            BBytes bb0 = new BBytes(b0);
            byte[] b1 = new byte[10];
            r.nextBytes(b1);
            BBytes bb1 = new BBytes(b1);
            byte[] b2 = new byte[10];
            r.nextBytes(b2);
            BBytes bb2 = new BBytes(b2);
            File d = new File("digdata");
            d.mkdirs();
            File f0 = File.createTempFile("testing", ".dat", d);
            File f1 = File.createTempFile("testing", ".dat", d);
            File f2 = File.createTempFile("testing", ".dat", d);
            di.put(bb0, f0);
            di.put(bb1, f1);
            di.put(bb2, f2);
            di.close();
            di = new FileDigestIndex("digdata", "dig.idx");
            boolean t0 = false;
            boolean t1 = false;
            boolean t2 = false;
            Set<Object> ks = di.list();
            for (Object k : ks) {
                File tf;
                if (k.equals(bb0)) {
                    t0 = true;
                    tf = di.get(k);
                    Assert.assertTrue((boolean)tf.equals(f0));
                }
                if (k.equals(bb1)) {
                    t1 = true;
                    tf = di.get(k);
                    Assert.assertTrue((boolean)tf.equals(f1));
                }
                if (!k.equals(bb2)) continue;
                t2 = true;
                tf = di.get(k);
                Assert.assertTrue((boolean)tf.equals(f2));
            }
            Assert.assertTrue((boolean)t0);
            Assert.assertTrue((boolean)t1);
            Assert.assertTrue((boolean)t2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testLong() {
        try {
            File f = new File("long.idx");
            if (f.exists()) {
                f.delete();
            }
            FileLongIndex di = new FileLongIndex("longdata", "long.idx");
            Random r = new Random();
            long bb0 = r.nextLong();
            long bb1 = r.nextLong();
            long bb2 = r.nextLong();
            File d = new File("longdata");
            d.mkdirs();
            File f0 = File.createTempFile("testing", ".dat", d);
            File f1 = File.createTempFile("testing", ".dat", d);
            File f2 = File.createTempFile("testing", ".dat", d);
            di.put(bb0, f0);
            di.put(bb1, f1);
            di.put(bb2, f2);
            di.close();
            di = new FileLongIndex("longdata", "long.idx");
            boolean t0 = false;
            boolean t1 = false;
            boolean t2 = false;
            Set<Object> ks = di.list();
            for (Object k : ks) {
                File tf;
                if (k.equals(bb0)) {
                    t0 = true;
                    tf = di.get(k);
                    Assert.assertTrue((boolean)tf.equals(f0));
                }
                if (k.equals(bb1)) {
                    t1 = true;
                    tf = di.get(k);
                    Assert.assertTrue((boolean)tf.equals(f1));
                }
                if (!k.equals(bb2)) continue;
                t2 = true;
                tf = di.get(k);
                Assert.assertTrue((boolean)tf.equals(f2));
            }
            Assert.assertTrue((boolean)t0);
            Assert.assertTrue((boolean)t1);
            Assert.assertTrue((boolean)t2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

