/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.test.db;

import com.db4o.Db4oEmbedded;
import com.db4o.EmbeddedObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.EmbeddedConfiguration;
import com.db4o.query.Query;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class DB4OTest {
    @Test
    public void TestDeleteSave() {
        File f = new File("junk.test");
        if (f.exists()) {
            f.delete();
        }
        EmbeddedConfiguration db4oconfig = Db4oEmbedded.newConfiguration();
        db4oconfig.common().activationDepth(10);
        db4oconfig.common().updateDepth(10);
        db4oconfig.common().objectClass(DbParent.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(DbParent.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(DbParent.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(DbChild.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(DbChild.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(DbChild.class).cascadeOnUpdate(true);
        EmbeddedObjectContainer DB = Db4oEmbedded.openFile((EmbeddedConfiguration)db4oconfig, (String)"junk.test");
        DbSubChild sc = new DbSubChild();
        sc.Value = "SubChild";
        DbChild c = new DbChild();
        c.Sub = sc;
        c.Value = "Child";
        DbParent p = new DbParent();
        p.Child = c;
        p.Value = "Parent";
        DB.store((Object)p);
        Query q = DB.query();
        q.constrain(DbParent.class);
        ObjectSet os = q.execute();
        Assert.assertEquals((long)1L, (long)os.size());
        DbParent np = (DbParent)os.iterator().next();
        Assert.assertEquals((Object)"Parent", (Object)np.Value);
        Assert.assertEquals((Object)"Child", (Object)np.Child.Value);
        Assert.assertEquals((Object)"SubChild", (Object)np.Child.Sub.Value);
        DB.delete((Object)p);
        Assert.assertEquals((Object)"Parent", (Object)p.Value);
        Assert.assertEquals((Object)"Child", (Object)p.Child.Value);
        Assert.assertEquals((Object)"SubChild", (Object)p.Child.Sub.Value);
        q = DB.query();
        q.constrain(DbParent.class);
        os = q.execute();
        Assert.assertEquals((long)0L, (long)os.size());
        q = DB.query();
        q.constrain(DbChild.class);
        os = q.execute();
        Assert.assertEquals((long)0L, (long)os.size());
        q = DB.query();
        q.constrain(DbSubChild.class);
        os = q.execute();
        Assert.assertEquals((long)0L, (long)os.size());
        DB.store((Object)p);
        q = DB.query();
        q.constrain(DbParent.class);
        os = q.execute();
        Assert.assertEquals((long)1L, (long)os.size());
        DbParent np1 = (DbParent)os.iterator().next();
        Assert.assertEquals((Object)"Parent", (Object)np1.Value);
        Assert.assertEquals((Object)"Child", (Object)np1.Child.Value);
        Assert.assertEquals((Object)"SubChild", (Object)np1.Child.Sub.Value);
    }

    class DbChild {
        public String Value;
        public DbSubChild Sub;

        DbChild() {
        }
    }

    class DbParent {
        public DbChild Child;
        public String Value;

        DbParent() {
        }
    }

    class DbSubChild {
        public String Value;

        DbSubChild() {
        }
    }
}

