/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simulator.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.PublicKeySet;
import org.ourfilesystem.security.PublicKeySetSigned;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.FileUtils;

public class CryptoDataBaseImpl
implements CryptoDataBaseInterface {
    public long ID;

    public CryptoDataBaseImpl(long id) {
        this.ID = id;
    }

    @Override
    public KeySet generateNewKeys() {
        KeySet ks = new KeySet();
        PublicKeySet pub = new PublicKeySet();
        pub.setPublicEncryptionKey(this.ID);
        pub.setPublicSigningKey(this.ID);
        ks.setPublicKeySet(pub);
        ks.setPrivateEncryptionKey(this.ID);
        ks.setPrivateSigningKey(this.ID);
        return ks;
    }

    @Override
    public boolean verifyPeer(PublicKeySetSigned pubsigned, Object pub) {
        long dig = (Long)pubsigned.getPublicEncryptionKey();
        if (dig != (Long)pubsigned.getSignature().getDigest()) {
            return false;
        }
        long sid = (Long)pubsigned.getSignature().getSignature();
        return sid == dig * 65536L + (Long)pub;
    }

    @Override
    public Peer signPeer(Peer p, Object peerid, Object privkey) {
        PublicKeySetSigned pubsigned = p.getPeerKeysAndIdentity();
        SignedDigest sg = new SignedDigest();
        long dig = (Long)p.getPeerKeysAndIdentity().getPublicEncryptionKey();
        sg.setDigest(dig);
        sg.setPeerIdentifier(peerid);
        long id = (Long)privkey;
        sg.setSignature(dig * 65536L + id);
        pubsigned.setSignature(sg);
        return p;
    }

    @Override
    public boolean digEquals(Object id0, Object id1) {
        long lid1;
        long lid0 = (Long)id0;
        return lid0 == (lid1 = ((Long)id1).longValue());
    }

    @Override
    public boolean verifyPost(Post p, Object pubkey) {
        SignedDigest sg = p.getSignedDigest();
        long dig = (Long)sg.getDigest();
        if (p.getPostNumber() == dig) {
            long sig = (Long)sg.getSignature();
            return sig == dig * 65536L + (Long)pubkey;
        }
        return false;
    }

    @Override
    public Post signPost(Post p, Object peerid, Object privkey) {
        long dig = p.getPostNumber();
        long id = (Long)privkey;
        SignedDigest sg = new SignedDigest();
        sg.setDigest(dig);
        sg.setPeerIdentifier(peerid);
        sg.setSignature(dig * 65536L + id);
        p.setSignedDigest(sg);
        return p;
    }

    @Override
    public Object digestFile(File f) {
        try {
            FileInputStream fis = new FileInputStream(f);
            byte[] b = new byte[8];
            FileUtils.fillBytes(b, fis);
            fis.close();
            ByteBuffer buf = ByteBuffer.wrap(b);
            return buf.getLong();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void selfSignMyPeerId(Peer p, Object privkey) {
        PublicKeySetSigned pubsigned = p.getPeerKeysAndIdentity();
        SignedDigest sg = new SignedDigest();
        long dig = (Long)p.getPeerKeysAndIdentity().getPublicEncryptionKey();
        sg.setDigest(dig);
        sg.setPeerIdentifier(dig);
        long id = (Long)privkey;
        sg.setSignature(dig * 65536L + id);
        pubsigned.setSignature(sg);
    }

    @Override
    public void signLocation(Peer p, Object privkey) {
        SignedDigest sg = new SignedDigest();
        long dig = (Long)p.getLocation();
        sg.setDigest(dig);
        sg.setPeerIdentifier(null);
        long id = (Long)privkey;
        sg.setSignature(dig * 65536L + id);
        p.setLocationSignature(sg);
    }

    @Override
    public boolean verifyLocation(Peer p, Object pub) {
        SignedDigest sg = p.getLocationSignature();
        if (sg == null) {
            return false;
        }
        long id = (Long)pub;
        if (p.getLocation() == null) {
            return false;
        }
        if (sg.getDigest() == null) {
            return false;
        }
        if (!p.getLocation().equals(sg.getDigest())) {
            return false;
        }
        long dig = (Long)sg.getDigest();
        return sg.getSignature().equals(dig * 65536L + id);
    }
}

