/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.Peer;

public class PeerTable
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private LinkedList<Peer> Peers;
    private String[] columns = new String[]{"Nickname", "Introduction", "Location", "Identity", "Signed by"};

    public PeerTable() {
        this.Peers = new LinkedList();
    }

    public void addAllPeers(List<Peer> pl) {
        this.Peers.clear();
        this.Peers.addAll(pl);
        this.fireTableDataChanged();
    }

    public void addPeer(Peer p) {
        if (!this.Peers.contains(p)) {
            this.Peers.add(p);
            this.fireTableDataChanged();
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.Peers.size();
    }

    public Peer getPeer(int row) {
        Iterator i = this.Peers.iterator();
        Peer up = null;
        int cnt = 0;
        while (i.hasNext() && cnt <= row) {
            up = (Peer)i.next();
            ++cnt;
        }
        return up;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Peer up = this.getPeer(row);
        if (up != null) {
            if (col == 0) {
                return up.getNickname();
            }
            if (col == 1) {
                return up.getIntroduction();
            }
            if (col == 2) {
                return up.getLocation();
            }
            if (col == 3) {
                return up.getPeerKeysAndIdentity().getSignature().getDigest().toString().substring(0, 10);
            }
            if (col == 4) {
                return up.getPeerKeysAndIdentity().getSignature().getPeerIdentifier().toString().substring(0, 10);
            }
        }
        return null;
    }
}

