/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OFSSettings {
    private static String AUTOSIGN = "AUTOSIGN";
    private static String AUTOUPDATEPEERS = "AUTOPEERUPDATE";
    private static String AUTOUPDATEPOSTS = "AUTOPOSTUPDATE";
    private static String PEERUPDATEPERIOD = "PEERUPDATEPERIOD";
    private static String POSTUPDATEPERIOD = "POSTUPDATEPERIOD";
    private File PropertiesFile;
    private Properties Properties = new Properties();

    public OFSSettings(String basedir) {
        this.PropertiesFile = new File(String.valueOf(basedir) + File.separator + "properties.cfg");
        if (this.PropertiesFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.PropertiesFile);
                this.Properties.load(fis);
                fis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getProperty(String key, String defval) {
        return this.Properties.getProperty(key, defval);
    }

    public String getProperty(String key) {
        return this.Properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.Properties.setProperty(key, value);
        try {
            FileOutputStream fos = new FileOutputStream(this.PropertiesFile);
            this.Properties.store(fos, "please do not manually edit");
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAutoSign() {
        return Boolean.valueOf(this.getProperty(AUTOSIGN, Boolean.toString(false)));
    }

    public void setAutoSign(boolean val) {
        this.setProperty(AUTOSIGN, Boolean.toString(val));
    }

    public boolean isAutoUpdatePeers() {
        return Boolean.valueOf(this.getProperty(AUTOUPDATEPEERS, Boolean.toString(true)));
    }

    public void setAutoUpdatePeers(boolean val) {
        this.setProperty(AUTOUPDATEPEERS, Boolean.toString(val));
    }

    public int getPeerUpdatePeriod() {
        return Integer.valueOf(this.getProperty(PEERUPDATEPERIOD, Integer.toString(30)));
    }

    public void setPeerUpdatePeriod(int val) {
        this.setProperty(PEERUPDATEPERIOD, Integer.toString(val));
    }

    public void setPeerUpdatePeriodStr(String sv) {
        this.setPeerUpdatePeriod(this.str2minutes(sv));
    }

    public String getPeerUpdatePeriodStr() {
        return this.minutes2str(this.getPeerUpdatePeriod());
    }

    public boolean isAutoUpdatePosts() {
        return Boolean.valueOf(this.getProperty(AUTOUPDATEPOSTS, Boolean.toString(true)));
    }

    public void setAutoUpdatePosts(boolean val) {
        this.setProperty(AUTOUPDATEPOSTS, Boolean.toString(val));
    }

    public int getPostUpdatePeriod() {
        return Integer.valueOf(this.getProperty(POSTUPDATEPERIOD, Integer.toString(30)));
    }

    public void setPostUpdatePeriod(int val) {
        this.setProperty(POSTUPDATEPERIOD, Integer.toString(val));
    }

    public void setPostUpdatePeriodStr(String sv) {
        this.setPostUpdatePeriod(this.str2minutes(sv));
    }

    public String getPostUpdatePeriodStr() {
        return this.minutes2str(this.getPostUpdatePeriod());
    }

    private String minutes2str(int min) {
        if (min >= 60) {
            int hours = min / 60;
            return hours + "h";
        }
        return min + "m";
    }

    private int str2minutes(String val) {
        Matcher min = Pattern.compile("(\\d+)m").matcher(val);
        Matcher hr = Pattern.compile("(\\d+)h").matcher(val);
        if (min.find()) {
            int v = Integer.valueOf(min.group(1));
            return v;
        }
        if (hr.find()) {
            int v = Integer.valueOf(min.group(1));
            return v *= 60;
        }
        return 60;
    }
}

