/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.ourfilesystem.filehander.FileReturnInterface;
import org.ourfilesystem.utilities.HumReadFileSize;

public class DownloadsTableModel
extends AbstractTableModel
implements FileReturnInterface {
    private static final long serialVersionUID = 1L;
    private LinkedList<DLRow> Rows;
    private HashMap<File, DLRow> Map;
    private String[] columns = new String[]{"File", "Digest", "Total Size", "Progress", "Pending", "Priority", "Paused"};
    private Class[] classes = new Class[]{String.class, String.class, String.class, DLRow.class, Integer.class, Integer.class, Boolean.class};

    public DownloadsTableModel() {
        this.Rows = new LinkedList();
        this.Map = new HashMap();
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    public Class getColumnClass(int col) {
        return this.classes[col];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public synchronized int getRowCount() {
        return this.Rows.size();
    }

    public synchronized DLRow getRow(int row) {
        if (row < this.Rows.size()) {
            return this.Rows.get(row);
        }
        return null;
    }

    @Override
    public synchronized Object getValueAt(int row, int col) {
        DLRow r = this.getRow(row);
        if (r != null) {
            if (col == 0) {
                return r.SaveAs.getName();
            }
            if (col == 1) {
                return r.Dig;
            }
            if (col == 2) {
                return HumReadFileSize.fileSize(r.TotalSize);
            }
            if (col == 3) {
                return r;
            }
            if (col == 4) {
                return r.Pending;
            }
            if (col == 5) {
                return r.Priority;
            }
            if (col == 6) {
                return r.Paused;
            }
        }
        return null;
    }

    public synchronized void removeFile(File f) {
        DLRow dl = this.Map.get(f);
        this.Map.remove(f);
        int cnt = 0;
        while (cnt < this.Rows.size()) {
            if (dl == this.Rows.get(cnt)) {
                this.Rows.remove(cnt);
                this.fireTableRowsDeleted(cnt, cnt);
            }
            ++cnt;
        }
    }

    private synchronized void doStatusUpdate(File saveas, String dig, long totalsize, long amountcomplete, int pending, boolean paused, boolean inprogress, int priority) {
        DLRow r = this.Map.get(saveas);
        if (r == null) {
            r = new DLRow(saveas, dig, totalsize, amountcomplete, pending, paused, inprogress, priority);
            this.Map.put(saveas, r);
            this.Rows.add(r);
            this.fireTableRowsInserted(this.Rows.size() - 1, this.Rows.size() - 1);
        } else {
            r.update(saveas, dig, totalsize, amountcomplete, pending, paused, inprogress, priority);
            int cnt = 0;
            while (cnt < this.Rows.size()) {
                if (r == this.Rows.get(cnt)) {
                    this.fireTableRowsUpdated(cnt, cnt);
                }
                ++cnt;
            }
        }
    }

    public synchronized void clearAll() {
        this.Rows.clear();
        this.Map.clear();
        this.fireTableDataChanged();
    }

    @Override
    public synchronized void downloadStatusUpdate(final File saveas, final String dig, final long totalsize, final long amountcomplete, final int pending, final boolean paused, final boolean inprogress, final int priority) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadsTableModel.this.doStatusUpdate(saveas, dig, totalsize, amountcomplete, pending, paused, inprogress, priority);
            }
        });
    }

    public class DLRow {
        public File SaveAs;
        public String Dig;
        public long TotalSize;
        public long AmountComplete;
        public int Pending;
        public boolean Paused;
        public boolean InProgress;
        public int Priority;

        public DLRow(File saveas, String dig, long totalsize, long amountcomplete, int pending, boolean paused, boolean inprogress, int priority) {
            this.update(saveas, dig, totalsize, amountcomplete, pending, paused, inprogress, priority);
        }

        public void update(File saveas, String dig, long totalsize, long amountcomplete, int pending, boolean paused, boolean inprogress, int priority) {
            this.SaveAs = saveas;
            this.Dig = dig;
            this.TotalSize = totalsize;
            this.AmountComplete = amountcomplete;
            this.Pending = pending;
            this.Paused = paused;
            this.InProgress = inprogress;
            this.Priority = priority;
        }
    }

    public class ProgressCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            if (arg1 instanceof DLRow) {
                DLRow dl = (DLRow)arg1;
                if (dl.AmountComplete == 0L) {
                    this.setIndeterminate(true);
                } else {
                    int tot = (int)(dl.TotalSize / 0x100000L);
                    int prg = (int)(dl.AmountComplete / 0x100000L);
                    this.setMaximum(tot);
                    this.setValue(prg);
                    this.setIndeterminate(false);
                }
                return this;
            }
            return null;
        }
    }
}

