/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.PublicKeySet;
import org.ourfilesystem.security.PublicKeySetSigned;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class SecurityTools {
    public static SecureRandom Random = new SecureRandom();

    public static AsymmetricCipherKeyPair generateKeyPair() {
        RSAKeyGenerationParameters parms = new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), Random, 2048, 40);
        RSAKeyPairGenerator gen = new RSAKeyPairGenerator();
        gen.init((KeyGenerationParameters)parms);
        return gen.generateKeyPair();
    }

    public static void writeRSAPublicKey(RSAKeyParameters p, OutputStream fos) throws IOException {
        byte[] exp = p.getExponent().toByteArray();
        byte[] mod = p.getModulus().toByteArray();
        FileUtils.writeBytes(fos, exp);
        FileUtils.writeBytes(fos, mod);
    }

    public static RSAKeyParameters readRSAPublicKey(InputStream fis) throws IOException {
        byte[] exp = FileUtils.readBytes(fis);
        byte[] mod = FileUtils.readBytes(fis);
        RSAKeyParameters pub = new RSAKeyParameters(false, new BigInteger(mod), new BigInteger(exp));
        return pub;
    }

    public static void writeRSAPrivateKey(RSAPrivateCrtKeyParameters p, OutputStream fos) throws IOException {
        FileUtils.writeBytes(fos, p.getDP().toByteArray());
        FileUtils.writeBytes(fos, p.getDQ().toByteArray());
        FileUtils.writeBytes(fos, p.getExponent().toByteArray());
        FileUtils.writeBytes(fos, p.getModulus().toByteArray());
        FileUtils.writeBytes(fos, p.getP().toByteArray());
        FileUtils.writeBytes(fos, p.getPublicExponent().toByteArray());
        FileUtils.writeBytes(fos, p.getQ().toByteArray());
        FileUtils.writeBytes(fos, p.getQInv().toByteArray());
    }

    public static RSAPrivateCrtKeyParameters readRSAPrivateKey(InputStream fis) throws IOException {
        byte[] dp = FileUtils.readBytes(fis);
        byte[] dq = FileUtils.readBytes(fis);
        byte[] exp = FileUtils.readBytes(fis);
        byte[] mod = FileUtils.readBytes(fis);
        byte[] p = FileUtils.readBytes(fis);
        byte[] pe = FileUtils.readBytes(fis);
        byte[] q = FileUtils.readBytes(fis);
        byte[] qi = FileUtils.readBytes(fis);
        RSAPrivateCrtKeyParameters priv = new RSAPrivateCrtKeyParameters(new BigInteger(mod), new BigInteger(pe), new BigInteger(exp), new BigInteger(p), new BigInteger(q), new BigInteger(dp), new BigInteger(dq), new BigInteger(qi));
        return priv;
    }

    public static void writePublicKeySet(PublicKeySet k, OutputStream fos) throws IOException {
        SecurityTools.writeRSAPublicKey((RSAKeyParameters)k.getPublicEncryptionKey(), fos);
        SecurityTools.writeRSAPublicKey((RSAKeyParameters)k.getPublicSigningKey(), fos);
    }

    public static PublicKeySet readPublicKeySet(InputStream fis) throws IOException {
        PublicKeySet p = new PublicKeySet();
        p.setPublicEncryptionKey(SecurityTools.readRSAPublicKey(fis));
        p.setPublicSigningKey(SecurityTools.readRSAPublicKey(fis));
        return p;
    }

    public static void writeSignedDigest(SignedDigest s, OutputStream fos) throws IOException {
        FileUtils.writeBytes(fos, ((BBytes)s.getDigest()).getBytes());
        if (s.getPeerIdentifier() == null) {
            fos.write(2);
        } else {
            fos.write(1);
            FileUtils.writeBytes(fos, ((BBytes)s.getPeerIdentifier()).getBytes());
        }
        FileUtils.writeBytes(fos, ((BBytes)s.getSignature()).getBytes());
    }

    public static SignedDigest readSignedDigest(InputStream fis) throws IOException {
        SignedDigest s = new SignedDigest();
        s.setDigest(new BBytes(FileUtils.readBytes(fis)));
        int v = fis.read();
        if (v == 2) {
            s.setPeerIdentifier(null);
        } else {
            s.setPeerIdentifier(new BBytes(FileUtils.readBytes(fis)));
        }
        s.setSignature(new BBytes(FileUtils.readBytes(fis)));
        return s;
    }

    public static void writePublicKeySetSigned(PublicKeySetSigned k, OutputStream fos) throws IOException {
        SecurityTools.writePublicKeySet(k, fos);
        SecurityTools.writeSignedDigest(k.getSignature(), fos);
    }

    public static PublicKeySetSigned readPublicKeySetSigned(InputStream fis) throws IOException {
        PublicKeySet p = SecurityTools.readPublicKeySet(fis);
        PublicKeySetSigned ps = new PublicKeySetSigned();
        ps.setPublicEncryptionKey(p.getPublicEncryptionKey());
        ps.setPublicSigningKey(p.getPublicSigningKey());
        ps.setSignature(SecurityTools.readSignedDigest(fis));
        return ps;
    }

    public static void writeKeySet(KeySet k, OutputStream fos) throws IOException {
        SecurityTools.writeRSAPrivateKey((RSAPrivateCrtKeyParameters)k.getPrivateEncryptionKey(), fos);
        SecurityTools.writeRSAPrivateKey((RSAPrivateCrtKeyParameters)k.getPrivateSigningKey(), fos);
        SecurityTools.writePublicKeySet(k.getPublicKeySet(), fos);
    }

    public static KeySet readKeySet(InputStream fis) throws IOException {
        KeySet k = new KeySet();
        k.setPrivateEncryptionKey(SecurityTools.readRSAPrivateKey(fis));
        k.setPrivateSigningKey(SecurityTools.readRSAPrivateKey(fis));
        k.setPublicKeySet(SecurityTools.readPublicKeySet(fis));
        return k;
    }

    public static void DigestRSAPublicKey(Digest dig, RSAKeyParameters pub) {
        byte[] a = null;
        a = pub.getExponent().toByteArray();
        dig.update(a, 0, a.length);
        a = pub.getModulus().toByteArray();
        dig.update(a, 0, a.length);
    }

    public static byte[] digestPublicKey(PublicKeySet k) {
        SHA512Digest dig = new SHA512Digest();
        SecurityTools.DigestRSAPublicKey((Digest)dig, (RSAKeyParameters)k.getPublicEncryptionKey());
        SecurityTools.DigestRSAPublicKey((Digest)dig, (RSAKeyParameters)k.getPublicSigningKey());
        byte[] sig = new byte[dig.getDigestSize()];
        dig.doFinal(sig, 0);
        return sig;
    }

    public static SignedDigest signDigest(byte[] dig, BBytes peerid, RSAPrivateCrtKeyParameters key) {
        SignedDigest s = new SignedDigest();
        RSAEngine eng = new RSAEngine();
        PKCS1Encoding enc = new PKCS1Encoding((AsymmetricBlockCipher)eng);
        enc.init(true, (CipherParameters)key);
        try {
            byte[] sig = enc.processBlock(dig, 0, dig.length);
            s.setDigest(new BBytes(dig));
            s.setPeerIdentifier(peerid);
            s.setSignature(new BBytes(sig));
            return s;
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean verifySignedDigest(SignedDigest s, byte[] checkdig, RSAKeyParameters pub) {
        if (!Arrays.equals(((BBytes)s.getDigest()).getBytes(), checkdig)) {
            return false;
        }
        RSAEngine eng = new RSAEngine();
        PKCS1Encoding enc = new PKCS1Encoding((AsymmetricBlockCipher)eng);
        enc.init(false, (CipherParameters)pub);
        byte[] sig = ((BBytes)s.getSignature()).getBytes();
        try {
            byte[] decsig = enc.processBlock(sig, 0, sig.length);
            return Arrays.equals(decsig, checkdig);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static BBytes digestFile(File f) throws IOException {
        SHA512Digest d = new SHA512Digest();
        SecurityTools.digestFile((Digest)d, f);
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        return new BBytes(sig);
    }

    public static void digestFile(Digest d, File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        byte[] buf = new byte[1024];
        int len = fis.read(buf);
        while (len != -1) {
            if (len > 0) {
                d.update(buf, 0, len);
            }
            len = fis.read(buf);
        }
        fis.close();
    }

    public static void digestLong(Digest d, long val) {
        byte[] b = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.putLong(val);
        d.update(b, 0, b.length);
    }

    public static void digestString(Digest d, String str) {
        if (str != null) {
            byte[] strb = str.getBytes(Charset.forName("UTF-16BE"));
            d.update(strb, 0, strb.length);
        }
    }

    public static BBytes digestPeerLocation(Peer p) {
        SHA512Digest d = new SHA512Digest();
        SecurityTools.digestString((Digest)d, p.getIntroduction());
        SecurityTools.digestString((Digest)d, (String)p.getLocation());
        SecurityTools.digestString((Digest)d, p.getNickname());
        SecurityTools.digestLong((Digest)d, p.getUpdateCount());
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        return new BBytes(sig);
    }

    public static BBytes digestPost(Post p, BBytes peerid) throws IOException {
        BBytes fr = (BBytes)p.getFileReferenceDigest();
        File f = (File)p.getMessage();
        long pnum = p.getPostNumber();
        SHA512Digest d = new SHA512Digest();
        if (fr != null && fr.getBytes() != null) {
            d.update(fr.getBytes(), 0, fr.getBytes().length);
        }
        if (f != null && f.exists() && f.isFile()) {
            SecurityTools.digestFile((Digest)d, f);
        }
        SecurityTools.digestLong((Digest)d, pnum);
        if (p.isPosterHasFile()) {
            d.update((byte)1);
        } else {
            d.update((byte)0);
        }
        if (peerid != null) {
            d.update(peerid.getBytes(), 0, peerid.getBytes().length);
        }
        byte[] sig = new byte[d.getDigestSize()];
        d.doFinal(sig, 0);
        return new BBytes(sig);
    }

    public static void signPost(Post p, BBytes peerid, RSAPrivateCrtKeyParameters key) throws IOException {
        BBytes dig = SecurityTools.digestPost(p, peerid);
        p.setSignedDigest(SecurityTools.signDigest(dig.getBytes(), peerid, key));
    }

    public static boolean verifyPost(Post p, RSAKeyParameters pub) throws IOException {
        BBytes dig = SecurityTools.digestPost(p, (BBytes)p.getSignedDigest().getPeerIdentifier());
        return SecurityTools.verifySignedDigest(p.getSignedDigest(), dig.getBytes(), pub);
    }

    public static PublicKeySetSigned signPublicKeySet(PublicKeySet k, BBytes peerid, RSAPrivateCrtKeyParameters key) {
        PublicKeySetSigned s = new PublicKeySetSigned();
        s.setPublicEncryptionKey(k.getPublicEncryptionKey());
        s.setPublicSigningKey(k.getPublicSigningKey());
        byte[] dig = SecurityTools.digestPublicKey(k);
        s.setSignature(SecurityTools.signDigest(dig, peerid, key));
        return s;
    }

    public static boolean verifyPublicKeySetSigned(PublicKeySetSigned sk, RSAKeyParameters pubkey) {
        byte[] cdig = SecurityTools.digestPublicKey(sk);
        return SecurityTools.verifySignedDigest(sk.getSignature(), cdig, pubkey);
    }
}

