/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.security;

import java.io.File;
import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.PublicKeySet;
import org.ourfilesystem.security.PublicKeySetSigned;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;

public class CryptoDataBaseImpl
implements CryptoDataBaseInterface {
    @Override
    public KeySet generateNewKeys() {
        AsymmetricCipherKeyPair encpair = SecurityTools.generateKeyPair();
        AsymmetricCipherKeyPair signpair = SecurityTools.generateKeyPair();
        KeySet ks = new KeySet();
        ks.setPrivateEncryptionKey(encpair.getPrivate());
        ks.setPrivateSigningKey(signpair.getPrivate());
        PublicKeySet pub = new PublicKeySet();
        pub.setPublicEncryptionKey(encpair.getPublic());
        pub.setPublicSigningKey(signpair.getPublic());
        ks.setPublicKeySet(pub);
        return ks;
    }

    @Override
    public boolean verifyPeer(PublicKeySetSigned pubsign, Object pub) {
        return SecurityTools.verifyPublicKeySetSigned(pubsign, (RSAKeyParameters)pub);
    }

    @Override
    public boolean digEquals(Object id0, Object id1) {
        if (!(id0 instanceof BBytes) || !(id1 instanceof BBytes)) {
            throw new RuntimeException("Expecting digests to be of type BBytes: " + id0 + ", " + id1);
        }
        return id0.equals(id1);
    }

    @Override
    public Peer signPeer(Peer p, Object peerid, Object privkey) {
        PublicKeySetSigned sig = SecurityTools.signPublicKeySet(p.getPeerKeysAndIdentity(), (BBytes)peerid, (RSAPrivateCrtKeyParameters)privkey);
        p.setPeerKeysAndIdentity(sig);
        return p;
    }

    @Override
    public boolean verifyPost(Post p, Object pubkey) {
        try {
            return SecurityTools.verifyPost(p, (RSAKeyParameters)pubkey);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Post signPost(Post p, Object peerid, Object privkey) {
        try {
            SecurityTools.signPost(p, (BBytes)peerid, (RSAPrivateCrtKeyParameters)privkey);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p;
    }

    @Override
    public Object digestFile(File f) {
        try {
            return SecurityTools.digestFile(f);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void selfSignMyPeerId(Peer p, Object privkey) {
        PublicKeySetSigned sig = SecurityTools.signPublicKeySet(p.getPeerKeysAndIdentity(), null, (RSAPrivateCrtKeyParameters)privkey);
        sig.getSignature().setPeerIdentifier(sig.getSignature().getDigest());
        p.setPeerKeysAndIdentity(sig);
    }

    @Override
    public void signLocation(Peer p, Object privkey) {
        BBytes dig = SecurityTools.digestPeerLocation(p);
        SignedDigest sg = SecurityTools.signDigest(dig.getBytes(), null, (RSAPrivateCrtKeyParameters)privkey);
        p.setLocationSignature(sg);
    }

    @Override
    public boolean verifyLocation(Peer p, Object pub) {
        BBytes dig = SecurityTools.digestPeerLocation(p);
        return SecurityTools.verifySignedDigest(p.getLocationSignature(), dig.getBytes(), (RSAKeyParameters)pub);
    }
}

