/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.security;

import java.security.SecureRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.security.CryptoComInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;

public class CryptoComImpl
implements CryptoComInterface {
    public static int ChallengeLength = 16;
    private SecureRandom Random = new SecureRandom();

    @Override
    public Object getChallenge() {
        byte[] b = new byte[ChallengeLength];
        this.Random.nextBytes(b);
        return new BBytes(b);
    }

    @Override
    public boolean verifyChallenge(Object sent, SignedDigest received, Peer p) {
        BBytes bbs = (BBytes)sent;
        return SecurityTools.verifySignedDigest(received, bbs.getBytes(), (RSAKeyParameters)p.getPeerKeysAndIdentity().getPublicSigningKey());
    }

    @Override
    public SignedDigest signChallenge(Object challenge, KeySet mykeys) {
        BBytes chbb = (BBytes)challenge;
        return SecurityTools.signDigest(chbb.getBytes(), null, (RSAPrivateCrtKeyParameters)mykeys.getPrivateSigningKey());
    }
}

