/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.filehander;

import java.io.File;
import java.io.IOException;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class PendingSingleDownload {
    private BBytes Digest;
    private boolean Requested;
    private boolean Complete;
    private File SaveAs;
    private boolean Paused;
    private int Priority;

    public void Init(File sa, BBytes primary, int priority, boolean paused) {
        this.Priority = priority;
        this.Paused = paused;
        this.SaveAs = sa;
        this.Digest = primary;
    }

    public String getDig() {
        return this.Digest.toString().substring(0, 6);
    }

    public int getNumberRequested() {
        if (this.Complete) {
            return 0;
        }
        if (this.Requested) {
            return 1;
        }
        return 0;
    }

    public long getAmountComplete() {
        if (this.Complete) {
            return 0x100000L;
        }
        return 0L;
    }

    public long getTotalSize() {
        return 0x100000L;
    }

    public void ResetRequests() {
        this.Requested = false;
    }

    public BBytes getRequest() {
        if (!this.Requested) {
            this.Requested = true;
            return this.Digest;
        }
        return null;
    }

    public boolean isInProgress() {
        return !this.Complete && this.Requested;
    }

    public boolean isComplete() {
        return this.Complete;
    }

    public boolean ProcessPiece(LocalFileReference ref) {
        if (ref.getFileReference().getUnsignedDigest().equals(this.Digest)) {
            try {
                FileUtils.copyFile(ref.getFileReference().getFile(), this.SaveAs, false);
                this.Complete = true;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public BBytes getDigest() {
        return this.Digest;
    }

    public void setDigest(BBytes digest) {
        this.Digest = digest;
    }

    public boolean isRequested() {
        return this.Requested;
    }

    public void setRequested(boolean requested) {
        this.Requested = requested;
    }

    public File getSaveAs() {
        return this.SaveAs;
    }

    public void setSaveAs(File saveAs) {
        this.SaveAs = saveAs;
    }

    public boolean isPaused() {
        return this.Paused;
    }

    public void setPaused(boolean paused) {
        this.Paused = paused;
    }

    public int getPriority() {
        return this.Priority;
    }

    public void setPriority(int priority) {
        this.Priority = priority;
    }

    public void setComplete(boolean complete) {
        this.Complete = complete;
    }
}

