/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.jdk;

import com.db4o.internal.Platform4;
import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.ReflectorConfiguration;
import com.db4o.reflect.jdk.ClassLoaderJdkLoader;
import com.db4o.reflect.jdk.JavaReflectClass;
import com.db4o.reflect.jdk.JdkArray;
import com.db4o.reflect.jdk.JdkClass;
import com.db4o.reflect.jdk.JdkLoader;

public class JdkReflector
implements Reflector {
    private final JdkLoader _classLoader;
    protected Reflector _parent;
    private ReflectArray _array;
    private ReflectorConfiguration _config;

    public JdkReflector(ClassLoader classLoader) {
        this(new ClassLoaderJdkLoader(classLoader));
    }

    public JdkReflector(JdkLoader classLoader) {
        this(classLoader, JdkReflector.defaultConfiguration());
    }

    private JdkReflector(JdkLoader classLoader, ReflectorConfiguration config) {
        this._classLoader = classLoader;
        this._config = config;
    }

    private static ReflectorConfiguration defaultConfiguration() {
        return new ReflectorConfiguration(){

            public boolean testConstructors() {
                return false;
            }

            public boolean callConstructor(ReflectClass clazz) {
                return false;
            }
        };
    }

    public ReflectArray array() {
        if (this._array == null) {
            this._array = new JdkArray(this.parent());
        }
        return this._array;
    }

    public Object deepClone(Object obj) {
        return new JdkReflector(this._classLoader, this._config);
    }

    public ReflectClass forClass(Class clazz) {
        return this.createClass(clazz);
    }

    public ReflectClass forName(String className) {
        Class clazz = this._classLoader.loadClass(className);
        if (clazz == null) {
            return null;
        }
        return this.createClass(clazz);
    }

    protected JdkClass createClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return new JdkClass(this.parent(), this, clazz);
    }

    public ReflectClass forObject(Object a_object) {
        if (a_object == null) {
            return null;
        }
        return this.parent().forClass(a_object.getClass());
    }

    public boolean isCollection(ReflectClass candidate) {
        return false;
    }

    public boolean methodCallsSupported() {
        return true;
    }

    public void setParent(Reflector reflector) {
        this._parent = reflector;
    }

    public static ReflectClass[] toMeta(Reflector reflector, Class[] clazz) {
        ReflectClass[] claxx = null;
        if (clazz != null) {
            claxx = new ReflectClass[clazz.length];
            for (int i = 0; i < clazz.length; ++i) {
                if (clazz[i] == null) continue;
                claxx[i] = reflector.forClass(clazz[i]);
            }
        }
        return claxx;
    }

    static Class[] toNative(ReflectClass[] claxx) {
        Class[] clazz = null;
        if (claxx != null) {
            clazz = new Class[claxx.length];
            for (int i = 0; i < claxx.length; ++i) {
                clazz[i] = JdkReflector.toNative(claxx[i]);
            }
        }
        return clazz;
    }

    public static Class toNative(ReflectClass claxx) {
        if (claxx == null) {
            return null;
        }
        if (claxx instanceof JavaReflectClass) {
            return ((JavaReflectClass)claxx).getJavaClass();
        }
        ReflectClass d = claxx.getDelegate();
        if (d == claxx) {
            return null;
        }
        return JdkReflector.toNative(d);
    }

    public void configuration(ReflectorConfiguration config) {
        this._config = config;
    }

    public ReflectorConfiguration configuration() {
        return this._config;
    }

    Object nullValue(ReflectClass clazz) {
        return Platform4.nullValue(JdkReflector.toNative(clazz));
    }

    protected Reflector parent() {
        if (this._parent == null) {
            return this;
        }
        return this._parent;
    }
}

