/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;

public final class BooleanHandler
extends PrimitiveHandler {
    static final int LENGTH = 1;
    private static final byte TRUE = 84;
    private static final byte FALSE = 70;
    private static final byte NULL = 78;
    private static final Boolean DEFAULTVALUE = new Boolean(false);

    public Object defaultValue() {
        return DEFAULTVALUE;
    }

    public int linkLength() {
        return 1;
    }

    public Class primitiveJavaClass() {
        return Boolean.TYPE;
    }

    Object read1(ByteArrayBuffer a_bytes) {
        byte ret = a_bytes.readByte();
        if (ret == 84) {
            return new Boolean(true);
        }
        if (ret == 70) {
            return new Boolean(false);
        }
        return null;
    }

    public void write(Object obj, ByteArrayBuffer buffer) {
        buffer.writeByte(this.getEncodedByteValue(obj));
    }

    private byte getEncodedByteValue(Object obj) {
        if (obj == null) {
            return 78;
        }
        if (((Boolean)obj).booleanValue()) {
            return 84;
        }
        return 70;
    }

    public Object read(ReadContext context) {
        byte ret = context.readByte();
        if (ret == 84) {
            return new Boolean(true);
        }
        if (ret == 70) {
            return new Boolean(false);
        }
        return null;
    }

    public void write(WriteContext context, Object obj) {
        context.writeByte(this.getEncodedByteValue(obj));
    }

    public Object nullRepresentationInUntypedArrays() {
        return null;
    }

    public PreparedComparison internalPrepareComparison(Object source) {
        final boolean sourceBoolean = (Boolean)source;
        return new PreparedComparison(){

            public int compareTo(Object target) {
                if (target == null) {
                    return 1;
                }
                boolean targetBoolean = (Boolean)target;
                return sourceBoolean == targetBoolean ? 0 : (sourceBoolean ? 1 : -1);
            }
        };
    }
}

