/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeaderVariablePart;
import com.db4o.internal.fileheader.FileHeaderVariablePart2;
import com.db4o.internal.fileheader.NewFileHeaderBase;

public class FileHeader2
extends NewFileHeaderBase {
    private static final int BLOCKSIZE_OFFSET = ACCESS_TIME_OFFSET + 8;
    public static final int HEADER_LENGTH = BLOCKSIZE_OFFSET + 20 + 1;
    private int _transactionPointerAddress = 0;

    public int length() {
        return HEADER_LENGTH;
    }

    protected void read(LocalObjectContainer container, ByteArrayBuffer reader) {
        this.newTimerFileLock(container);
        this.oldEncryptionOff(container);
        this.checkThreadFileLock(container, reader);
        reader.seek(BLOCKSIZE_OFFSET);
        container.blockSizeReadFromFile(reader.readInt());
        SystemData systemData = container.systemData();
        systemData.classCollectionID(reader.readInt());
        container.systemData().idSystemType(reader.readByte());
        this._variablePart = this.createVariablePart(container);
        int variablePartAddress = reader.readInt();
        int variablePartLength = reader.readInt();
        this._variablePart.read(variablePartAddress, variablePartLength);
        this._transactionPointerAddress = reader.readInt();
        if (this._transactionPointerAddress != 0) {
            ByteArrayBuffer buffer = new ByteArrayBuffer(8);
            buffer.read(container, this._transactionPointerAddress, 0);
            systemData.transactionPointer1(buffer.readInt());
            systemData.transactionPointer2(buffer.readInt());
        }
    }

    public void writeFixedPart(LocalObjectContainer file, boolean startFileLockingThread, boolean shuttingDown, StatefulBuffer writer, int blockSize) {
        SystemData systemData = file.systemData();
        writer.append(SIGNATURE);
        writer.writeByte(this.version());
        writer.writeInt((int)this.timeToWrite(this._timerFileLock.openTime(), shuttingDown));
        writer.writeLong(this.timeToWrite(this._timerFileLock.openTime(), shuttingDown));
        writer.writeLong(this.timeToWrite(System.currentTimeMillis(), shuttingDown));
        writer.writeInt(blockSize);
        writer.writeInt(systemData.classCollectionID());
        writer.writeByte(systemData.idSystemType());
        writer.writeInt(((FileHeaderVariablePart2)this._variablePart).address());
        writer.writeInt(((FileHeaderVariablePart2)this._variablePart).length());
        writer.writeInt(this._transactionPointerAddress);
        writer.write();
        if (shuttingDown) {
            this.writeVariablePart(file, true);
        } else {
            file.syncFiles();
        }
        if (startFileLockingThread) {
            file.threadPool().start("db4o lock thread", this._timerFileLock);
        }
    }

    public void writeTransactionPointer(Transaction systemTransaction, int transactionPointer) {
        if (this._transactionPointerAddress == 0) {
            LocalObjectContainer file = ((LocalTransaction)systemTransaction).localContainer();
            this._transactionPointerAddress = file.allocateSafeSlot(8).address();
            file.writeHeader(false, false);
        }
        this.writeTransactionPointer(systemTransaction, transactionPointer, this._transactionPointerAddress, 0);
    }

    protected byte version() {
        return 2;
    }

    protected NewFileHeaderBase createNew() {
        return new FileHeader2();
    }

    public FileHeaderVariablePart createVariablePart(LocalObjectContainer file) {
        return new FileHeaderVariablePart2(file);
    }
}

