/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.StoredClass;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.ArrayIterator4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Entry4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.MappingIterator;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.Config4Class;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PendingClassInits;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.metadata.TraverseFieldCommand;
import com.db4o.reflect.ReflectClass;

public final class ClassMetadataRepository
extends PersistentBase {
    private Collection4 _classes;
    private Hashtable4 _creating;
    private final Transaction _systemTransaction;
    private Hashtable4 _classMetadataByBytes;
    private Hashtable4 _classMetadataByClass;
    private Hashtable4 _classMetadataByName;
    private Hashtable4 _classMetadataByID;
    private int _classMetadataCreationDepth;
    private Queue4 _initClassMetadataOnUp;
    private final PendingClassInits _classInits;

    public ClassMetadataRepository(Transaction systemTransaction) {
        this._systemTransaction = systemTransaction;
        this._initClassMetadataOnUp = new NonblockingQueue();
        this._classInits = new PendingClassInits(this._systemTransaction);
    }

    public void addClassMetadata(ClassMetadata clazz) {
        this.container().setDirtyInSystemTransaction(this);
        this._classes.add(clazz);
        if (clazz.stateUnread()) {
            this._classMetadataByBytes.put(clazz.i_nameBytes, (Object)clazz);
        } else {
            this._classMetadataByClass.put(clazz.classReflector(), (Object)clazz);
        }
        this.registerClassMetadataById(clazz);
    }

    private void registerClassMetadataById(ClassMetadata clazz) {
        if (clazz.getID() == 0) {
            clazz.write(this._systemTransaction);
        }
        this._classMetadataByID.put(clazz.getID(), (Object)clazz);
    }

    private byte[] asBytes(String str) {
        return this.container().stringIO().write(str);
    }

    public void attachQueryNode(final String fieldName, final Visitor4 visitor) {
        ClassMetadataIterator i = this.iterator();
        while (i.moveNext()) {
            final ClassMetadata classMetadata = i.currentClass();
            if (classMetadata.isInternal()) continue;
            classMetadata.traverseAllAspects(new TraverseFieldCommand(){

                protected void process(FieldMetadata field) {
                    if (field.canAddToQuery(fieldName)) {
                        visitor.visit(new Object[]{classMetadata, field});
                    }
                }
            });
        }
    }

    public void iterateTopLevelClasses(Visitor4 visitor) {
        ClassMetadataIterator i = this.iterator();
        while (i.moveNext()) {
            ClassMetadata classMetadata = i.currentClass();
            if (classMetadata.isInternal() || classMetadata.getAncestor() != null) continue;
            visitor.visit(classMetadata);
        }
    }

    void checkChanges() {
        Iterator4 i = this._classes.iterator();
        while (i.moveNext()) {
            ((ClassMetadata)i.current()).checkChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean createClassMetadata(ClassMetadata clazz, ReflectClass reflectClazz) {
        boolean result = false;
        ++this._classMetadataCreationDepth;
        try {
            ReflectClass parentReflectClazz = reflectClazz.getSuperclass();
            ClassMetadata parentClazz = null;
            if (parentReflectClazz != null && !parentReflectClazz.equals(this.container()._handlers.ICLASS_OBJECT)) {
                parentClazz = this.produceClassMetadata(parentReflectClazz);
            }
            result = this.container().createClassMetadata(clazz, reflectClazz, parentClazz);
        }
        finally {
            --this._classMetadataCreationDepth;
        }
        this.initClassMetadataOnUp();
        return result;
    }

    private void ensureAllClassesRead() {
        boolean allClassesRead = false;
        while (!allClassesRead) {
            Collection4<ClassMetadata> unreadClasses = new Collection4<ClassMetadata>();
            int numClasses = this._classes.size();
            Iterator4 classIter = this._classes.iterator();
            while (classIter.moveNext()) {
                ClassMetadata clazz = (ClassMetadata)classIter.current();
                if (!clazz.stateUnread()) continue;
                unreadClasses.add(clazz);
            }
            Iterator4 unreadIter = unreadClasses.iterator();
            while (unreadIter.moveNext()) {
                ClassMetadata clazz = (ClassMetadata)unreadIter.current();
                if ((clazz = this.readClassMetadata(clazz, null)).classReflector() != null) continue;
                clazz.forceRead();
            }
            allClassesRead = this._classes.size() == numClasses;
        }
        this.applyReadAs();
    }

    boolean fieldExists(String field) {
        ClassMetadataIterator i = this.iterator();
        while (i.moveNext()) {
            if (i.currentClass().fieldMetadataForName(field) == null) continue;
            return true;
        }
        return false;
    }

    public Collection4 forInterface(ReflectClass claxx) {
        Collection4<ClassMetadata> col = new Collection4<ClassMetadata>();
        ClassMetadataIterator i = this.iterator();
        while (i.moveNext()) {
            ClassMetadata clazz = i.currentClass();
            ReflectClass candidate = clazz.classReflector();
            if (candidate.isInterface() || !claxx.isAssignableFrom(candidate)) continue;
            col.add(clazz);
            Iterator4 j = new Collection4(col).iterator();
            while (j.moveNext()) {
                ClassMetadata higher;
                ClassMetadata existing = (ClassMetadata)j.current();
                if (existing == clazz || (higher = clazz.getHigherHierarchy(existing)) == null) continue;
                if (higher == clazz) {
                    col.remove(existing);
                    continue;
                }
                col.remove(clazz);
            }
        }
        return col;
    }

    public byte getIdentifier() {
        return 65;
    }

    ClassMetadata getActiveClassMetadata(ReflectClass reflectClazz) {
        return (ClassMetadata)this._classMetadataByClass.get(reflectClazz);
    }

    ClassMetadata classMetadataForReflectClass(ReflectClass reflectClazz) {
        ClassMetadata cached = (ClassMetadata)this._classMetadataByClass.get(reflectClazz);
        if (cached != null) {
            return cached;
        }
        ClassMetadata byName = (ClassMetadata)this._classMetadataByName.get(reflectClazz.getName());
        if (byName != null) {
            return byName;
        }
        return this.readClassMetadata(reflectClazz);
    }

    private ClassMetadata readClassMetadata(ReflectClass reflectClazz) {
        ClassMetadata clazz = (ClassMetadata)this._classMetadataByBytes.remove(this.getNameBytes(reflectClazz.getName()));
        if (clazz == null) {
            return null;
        }
        return this.readClassMetadata(clazz, reflectClazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassMetadata produceClassMetadata(ReflectClass reflectClazz) {
        ClassMetadata classMetadata = this.classMetadataForReflectClass(reflectClazz);
        if (classMetadata != null) {
            return classMetadata;
        }
        ClassMetadata classBeingCreated = (ClassMetadata)this._creating.get(reflectClazz);
        if (classBeingCreated != null) {
            return classBeingCreated;
        }
        ClassMetadata newClassMetadata = new ClassMetadata(this.container(), reflectClazz);
        this._creating.put(reflectClazz, (Object)newClassMetadata);
        try {
            if (!this.createClassMetadata(newClassMetadata, reflectClazz)) {
                ClassMetadata classMetadata2 = null;
                return classMetadata2;
            }
            if (!this.isRegistered(reflectClazz)) {
                this.addClassMetadata(newClassMetadata);
                this._classInits.process(newClassMetadata);
            } else {
                this.registerClassMetadataById(newClassMetadata);
                if (newClassMetadata.aspectsAreNull()) {
                    this._classInits.process(newClassMetadata);
                }
            }
            this.container().setDirtyInSystemTransaction(this);
        }
        finally {
            this._creating.remove(reflectClazz);
        }
        return newClassMetadata;
    }

    private boolean isRegistered(ReflectClass reflectClazz) {
        return this._classMetadataByClass.get(reflectClazz) != null;
    }

    ClassMetadata classMetadataForId(int id) {
        ClassMetadata classMetadata = (ClassMetadata)this._classMetadataByID.get(id);
        if (null == classMetadata) {
            return null;
        }
        return this.readClassMetadata(classMetadata, null);
    }

    public int classMetadataIdForName(String name) {
        ClassMetadata classMetadata = (ClassMetadata)this._classMetadataByBytes.get(this.getNameBytes(name));
        if (classMetadata == null) {
            classMetadata = this.findInitializedClassByName(name);
        }
        if (classMetadata != null) {
            return classMetadata.getID();
        }
        return 0;
    }

    public ClassMetadata getClassMetadata(String name) {
        ClassMetadata classMetadata = (ClassMetadata)this._classMetadataByBytes.remove(this.getNameBytes(name));
        if (classMetadata == null) {
            classMetadata = this.findInitializedClassByName(name);
        }
        if (classMetadata != null) {
            classMetadata = this.readClassMetadata(classMetadata, null);
        }
        return classMetadata;
    }

    private ClassMetadata findInitializedClassByName(String name) {
        ClassMetadata classMetadata = (ClassMetadata)this._classMetadataByName.get(name);
        if (classMetadata != null) {
            return classMetadata;
        }
        ClassMetadataIterator i = this.iterator();
        while (i.moveNext()) {
            classMetadata = (ClassMetadata)i.current();
            if (!name.equals(classMetadata.getName())) continue;
            this._classMetadataByName.put(name, (Object)classMetadata);
            return classMetadata;
        }
        return null;
    }

    public int getClassMetadataID(String name) {
        ClassMetadata clazz = (ClassMetadata)this._classMetadataByBytes.get(this.getNameBytes(name));
        if (clazz != null) {
            return clazz.getID();
        }
        return 0;
    }

    byte[] getNameBytes(String name) {
        return this.asBytes(this.resolveAliasRuntimeName(name));
    }

    private String resolveAliasRuntimeName(String name) {
        return this.container().configImpl().resolveAliasRuntimeName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOnUp(Transaction systemTrans) {
        ++this._classMetadataCreationDepth;
        systemTrans.container().showInternalClasses(true);
        try {
            Iterator4 i = this._classes.iterator();
            while (i.moveNext()) {
                ((ClassMetadata)i.current()).initOnUp(systemTrans);
            }
        }
        finally {
            systemTrans.container().showInternalClasses(false);
            --this._classMetadataCreationDepth;
        }
        this.initClassMetadataOnUp();
    }

    void initTables(int size) {
        this._classes = new Collection4();
        this._classMetadataByBytes = new Hashtable4(size);
        if (size < 16) {
            size = 16;
        }
        this._classMetadataByClass = new Hashtable4(size);
        this._classMetadataByName = new Hashtable4(size);
        this._classMetadataByID = new Hashtable4(size);
        this._creating = new Hashtable4(1);
    }

    private void initClassMetadataOnUp() {
        if (this._classMetadataCreationDepth != 0) {
            return;
        }
        ClassMetadata clazz = (ClassMetadata)this._initClassMetadataOnUp.next();
        while (clazz != null) {
            clazz.initOnUp(this._systemTransaction);
            clazz = (ClassMetadata)this._initClassMetadataOnUp.next();
        }
    }

    public ClassMetadataIterator iterator() {
        return new ClassMetadataIterator(this, new ArrayIterator4(this._classes.toArray()));
    }

    public Iterator4 ids() {
        return new ClassIDIterator(this._classes);
    }

    public int ownLength() {
        return 4 + this._classes.size() * 4;
    }

    void purge() {
        Iterator4 i = this._classes.iterator();
        while (i.moveNext()) {
            ((ClassMetadata)i.current()).purge();
        }
    }

    public final void readThis(Transaction trans, ByteArrayBuffer buffer) {
        int classCount = buffer.readInt();
        this.initTables(classCount);
        ObjectContainerBase container = this.container();
        int[] ids = this.readMetadataIds(buffer, classCount);
        ByteArrayBuffer[] metadataSlots = container.readSlotBuffers(trans, ids);
        for (int i = 0; i < classCount; ++i) {
            ClassMetadata classMetadata = new ClassMetadata(container, null);
            classMetadata.setID(ids[i]);
            this._classes.add(classMetadata);
            this._classMetadataByID.put(ids[i], (Object)classMetadata);
            byte[] name = classMetadata.readName1(trans, metadataSlots[i]);
            if (name == null) continue;
            this._classMetadataByBytes.put(name, (Object)classMetadata);
        }
        this.applyReadAs();
    }

    private int[] readMetadataIds(ByteArrayBuffer buffer, int classCount) {
        int[] ids = new int[classCount];
        for (int i = 0; i < classCount; ++i) {
            ids[i] = buffer.readInt();
        }
        return ids;
    }

    Hashtable4 classByBytes() {
        return this._classMetadataByBytes;
    }

    private void applyReadAs() {
        Hashtable4 readAs = this.container().configImpl().readAs();
        Iterator4 i = readAs.iterator();
        while (i.moveNext()) {
            ClassMetadata clazz;
            Entry4 entry = (Entry4)i.current();
            String dbName = (String)entry.key();
            String useName = (String)entry.value();
            byte[] dbbytes = this.getNameBytes(dbName);
            byte[] useBytes = this.getNameBytes(useName);
            if (this.classByBytes().get(useBytes) != null || (clazz = (ClassMetadata)this.classByBytes().get(dbbytes)) == null) continue;
            clazz.i_nameBytes = useBytes;
            clazz.setConfig(this.configClass(dbName));
            this.classByBytes().remove(dbbytes);
            this.classByBytes().put(useBytes, (Object)clazz);
        }
    }

    private Config4Class configClass(String name) {
        return this.container().configImpl().configClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetadata readClassMetadata(ClassMetadata classMetadata, ReflectClass clazz) {
        if (classMetadata == null) {
            throw new ArgumentNullException();
        }
        if (!classMetadata.stateUnread()) {
            return classMetadata;
        }
        ++this._classMetadataCreationDepth;
        try {
            classMetadata.resolveNameConfigAndReflector(this, clazz);
            ReflectClass claxx = classMetadata.classReflector();
            if (claxx != null) {
                this._classMetadataByClass.put(claxx, (Object)classMetadata);
                classMetadata.readThis();
                classMetadata.checkChanges();
                this._initClassMetadataOnUp.add(classMetadata);
            }
        }
        finally {
            --this._classMetadataCreationDepth;
        }
        this.initClassMetadataOnUp();
        return classMetadata;
    }

    public void checkAllClassChanges() {
        Iterator4 i = this._classMetadataByID.keys();
        while (i.moveNext()) {
            int classMetadataID = (Integer)i.current();
            this.classMetadataForId(classMetadataID);
        }
    }

    public void refreshClasses() {
        ClassMetadata clazz;
        ClassMetadataRepository rereader = new ClassMetadataRepository(this._systemTransaction);
        rereader._id = this._id;
        rereader.read(this.container().systemTransaction());
        Iterator4 i = rereader._classes.iterator();
        while (i.moveNext()) {
            clazz = (ClassMetadata)i.current();
            this.refreshClass(clazz);
        }
        i = this._classes.iterator();
        while (i.moveNext()) {
            clazz = (ClassMetadata)i.current();
            clazz.refresh();
        }
    }

    private void refreshClass(ClassMetadata clazz) {
        if (this._classMetadataByID.get(clazz.getID()) == null) {
            this._classes.add(clazz);
            this._classMetadataByID.put(clazz.getID(), (Object)clazz);
            this.refreshClassCache(clazz, null);
        }
    }

    public void refreshClassCache(ClassMetadata clazz, ReflectClass oldReflector) {
        if (clazz.stateUnread()) {
            this._classMetadataByBytes.put(clazz.readName(this._systemTransaction), (Object)clazz);
        } else {
            if (oldReflector != null) {
                this._classMetadataByClass.remove(oldReflector);
            }
            this._classMetadataByClass.put(clazz.classReflector(), (Object)clazz);
        }
    }

    void reReadClassMetadata(ClassMetadata clazz) {
        if (clazz != null) {
            this.reReadClassMetadata(clazz._ancestor);
            clazz.readName(this._systemTransaction);
            clazz.forceRead();
            clazz.setStateClean();
            clazz.bitFalse(6);
            clazz.bitFalse(8);
            clazz.bitFalse(4);
            clazz.bitFalse(7);
            clazz.checkChanges();
        }
    }

    public StoredClass[] storedClasses() {
        this.ensureAllClassesRead();
        StoredClass[] sclasses = new StoredClass[this._classes.size()];
        this._classes.toArray(sclasses);
        return sclasses;
    }

    public void writeAllClasses() {
        ClassMetadata clazz;
        int i;
        Collection4<ClassMetadata> deadClasses = new Collection4<ClassMetadata>();
        StoredClass[] storedClasses = this.storedClasses();
        for (i = 0; i < storedClasses.length; ++i) {
            clazz = (ClassMetadata)storedClasses[i];
            clazz.setStateDirty();
            if (!clazz.stateDead()) continue;
            deadClasses.add(clazz);
            clazz.setStateOK();
        }
        for (i = 0; i < storedClasses.length; ++i) {
            clazz = (ClassMetadata)storedClasses[i];
            clazz.write(this._systemTransaction);
        }
        Iterator4 it = deadClasses.iterator();
        while (it.moveNext()) {
            ((ClassMetadata)it.current()).setStateDead();
        }
    }

    public void writeThis(Transaction trans, ByteArrayBuffer buffer) {
        buffer.writeInt(this._classes.size());
        Iterator4 i = this._classes.iterator();
        while (i.moveNext()) {
            buffer.writeIDOf(trans, i.current());
        }
    }

    public String toString() {
        String str = "Active:\n";
        Iterator4 i = this._classes.iterator();
        while (i.moveNext()) {
            ClassMetadata clazz = (ClassMetadata)i.current();
            str = str + clazz.getID() + " " + clazz + "\n";
        }
        return str;
    }

    ObjectContainerBase container() {
        return this._systemTransaction.container();
    }

    public void setID(int id) {
        if (this.container().isClient()) {
            super.setID(id);
            return;
        }
        if (this._id == 0) {
            this.systemData().classCollectionID(id);
        }
        super.setID(id);
    }

    private SystemData systemData() {
        return this.localSystemTransaction().localContainer().systemData();
    }

    private LocalTransaction localSystemTransaction() {
        return (LocalTransaction)this._systemTransaction;
    }

    public void classMetadataNameResolved(ClassMetadata classMetadata, byte[] nameBytes) {
        this._classMetadataByBytes.remove(nameBytes);
        this._classMetadataByName.put(classMetadata.getName(), (Object)classMetadata);
    }

    private static class ClassIDIterator
    extends MappingIterator {
        public ClassIDIterator(Collection4 classes) {
            super(classes.iterator());
        }

        protected Object map(Object current) {
            return new Integer(((ClassMetadata)current).getID());
        }
    }
}

