/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.Sortable4;

public class Algorithms4 {
    private static final int QSORT_LENGTH_THRESHOLD = 7;

    public static void sort(Sortable4 sortable) {
        Algorithms4.sort(sortable, 0, sortable.size());
    }

    public static void sort(Sortable4 sortable, int start, int end) {
        int length = end - start;
        if (length < 7) {
            Algorithms4.insertionSort(sortable, start, end);
            return;
        }
        Algorithms4.qsort(sortable, start, end);
    }

    public static void qsort(Sortable4 sortable, int start, int end) {
        int d;
        int b;
        int length = end - start;
        int middle = start + length / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Algorithms4.middleValueIndex(sortable, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Algorithms4.middleValueIndex(sortable, middle - length, middle, middle + length);
                top = Algorithms4.middleValueIndex(sortable, top - 2 * length, top - length, top);
            }
            middle = Algorithms4.middleValueIndex(sortable, bottom, middle, top);
        }
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && sortable.compare(b, middle) <= 0) {
                if (sortable.compare(b, middle) == 0) {
                    middle = Algorithms4.newPartionIndex(middle, a, b);
                    Algorithms4.swap(sortable, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && sortable.compare(c, middle) >= 0) {
                if (sortable.compare(c, middle) == 0) {
                    middle = Algorithms4.newPartionIndex(middle, c, d);
                    Algorithms4.swap(sortable, c, d--);
                }
                --c;
            }
            if (b > c) break;
            middle = Algorithms4.newPartionIndex(middle, b, c);
            Algorithms4.swap(sortable, b++, c--);
        }
        length = Math.min(a - start, b - a);
        Algorithms4.swap(sortable, start, b - length, length);
        length = Math.min(d - c, end - 1 - d);
        Algorithms4.swap(sortable, b, end - length, length);
        length = b - a;
        if (length > 0) {
            Algorithms4.sort(sortable, start, start + length);
        }
        if ((length = d - c) > 0) {
            Algorithms4.sort(sortable, end - length, end);
        }
    }

    public static void insertionSort(Sortable4 sortable, int start, int end) {
        for (int i = start + 1; i < end; ++i) {
            for (int j = i; j > start && sortable.compare(j - 1, j) > 0; --j) {
                Algorithms4.swap(sortable, j - 1, j);
            }
        }
    }

    private static int newPartionIndex(int oldPartionIndex, int leftSwapIndex, int rightSwapIndex) {
        if (leftSwapIndex == oldPartionIndex) {
            return rightSwapIndex;
        }
        if (rightSwapIndex == oldPartionIndex) {
            return leftSwapIndex;
        }
        return oldPartionIndex;
    }

    private static int middleValueIndex(Sortable4 sortable, int a, int b, int c) {
        if (sortable.compare(a, b) < 0) {
            if (sortable.compare(b, c) < 0) {
                return b;
            }
            if (sortable.compare(a, c) < 0) {
                return c;
            }
            return a;
        }
        if (sortable.compare(b, c) > 0) {
            return b;
        }
        if (sortable.compare(a, c) > 0) {
            return c;
        }
        return a;
    }

    private static void swap(Sortable4 sortable, int left, int right) {
        if (left == right) {
            return;
        }
        sortable.swap(left, right);
    }

    private static void swap(Sortable4 sortable, int from, int to, int length) {
        while (length-- > 0) {
            Algorithms4.swap(sortable, from++, to++);
        }
    }
}

