package org.ourfilesystem.utilities;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

public class HumReadFileSize {

	public static long KB = 1024L;
	public static long MB = KB * KB;
	public static long GB = MB * KB;
	
	public static String fileSize(long size) {
		if (size > GB) {
			long gb = size / GB;
			return "" + gb + "GB";
		}
		else if (size > MB) {
			long mb = size / MB;
			return "" + mb + "MB";
		}
		else if (size > KB) {
			long kb = size / KB;
			return "" + kb + "KB";
		}
		return "" + size + "B";
	}
	
}
