package org.ourfilesystem.utilities;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import org.ourfilesystem.db.FileReference;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.security.PublicKeySetSigned;
import org.ourfilesystem.security.SignedDigest;

public class Cloning {
	
	public static SignedDigest cloneSignedDigest(SignedDigest sg) {
		if (sg != null) {
			SignedDigest nsg = new SignedDigest();
			nsg.setDigest(sg.getDigest());
			nsg.setPeerIdentifier(sg.getPeerIdentifier());
			nsg.setSignature(sg.getSignature());
			return nsg;
		}
		return null;
	}
	
	public static PublicKeySetSigned clonePublicKeySetSigned(PublicKeySetSigned p) {
		if (p != null) {
			PublicKeySetSigned np = new PublicKeySetSigned();
			np.setPublicEncryptionKey(p.getPublicEncryptionKey());
			np.setPublicSigningKey(p.getPublicSigningKey());
			np.setSignature(cloneSignedDigest(p.getSignature()));
			return np;
		}
		return null;
	}
	
	public static Peer clonePeer(Peer p) {
		if (p != null) {
			Peer np = new Peer();
			np.setLocation(p.getLocation());
			np.setNickname(p.getNickname());
			np.setIntroduction(p.getIntroduction());
			np.setUpdateCount(p.getUpdateCount());
			np.setPeerKeysAndIdentity(clonePublicKeySetSigned(p.getPeerKeysAndIdentity()));
			np.setLocationSignature(cloneSignedDigest(p.getLocationSignature()));
			return np;
		}
		return null;
	}
	
	public static FileReference cloneFileReference(FileReference fr) {
		if (fr != null) {
			FileReference n = new FileReference();
			n.setUnsignedDigest(fr.getUnsignedDigest());
			return n;
		}
		return null;
	}
	
	public static Post clonePost(Post p) {
		if (p != null) {
			Post np = new Post();
			np.setFileReferenceDigest(p.getFileReferenceDigest());
			np.setMessage(p.getMessage());
			np.setPosterHasFile(p.isPosterHasFile());
			np.setPostNumber(p.getPostNumber());
			np.setSignedDigest(cloneSignedDigest(p.getSignedDigest()));
			return np;			
		}
		return null;
	}

}
