package org.ourfilesystem.test.db;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import static org.junit.Assert.*;

import java.io.File;

import org.junit.Test;

import com.db4o.Db4oEmbedded;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.EmbeddedConfiguration;
import com.db4o.query.Query;

public class DB4OTest {
	
	class DbChild {
		public String Value;
		public DbSubChild Sub;
	}
	
	class DbSubChild {
		public String Value;
	}
	
	class DbParent {
		public DbChild Child;
		public String Value;
	}
	
	@Test
	public void TestDeleteSave() {
		File f = new File("junk.test");
		if (f.exists()) f.delete();
		ObjectContainer DB;
		
		EmbeddedConfiguration db4oconfig = Db4oEmbedded.newConfiguration();
		db4oconfig.common().activationDepth(10);
		db4oconfig.common().updateDepth(10);
		db4oconfig.common().objectClass(DbParent.class).cascadeOnDelete(true);
		db4oconfig.common().objectClass(DbParent.class).cascadeOnActivate(true);
		db4oconfig.common().objectClass(DbParent.class).cascadeOnUpdate(true);
		db4oconfig.common().objectClass(DbChild.class).cascadeOnDelete(true);
		db4oconfig.common().objectClass(DbChild.class).cascadeOnActivate(true);
		db4oconfig.common().objectClass(DbChild.class).cascadeOnUpdate(true);

		DB = Db4oEmbedded.openFile(db4oconfig, "junk.test");
		
		DbSubChild sc = new DbSubChild();
		sc.Value = "SubChild";
		DbChild c = new DbChild();
		c.Sub = sc;
		c.Value = "Child";
		DbParent p = new DbParent();
		p.Child = c;
		p.Value = "Parent";
		
		DB.store(p);
		
		Query q = DB.query();
		q.constrain(DbParent.class);
		ObjectSet<DbParent> os = q.execute();
		
		assertEquals(1, os.size());
		
		DbParent np = os.iterator().next();
		assertEquals("Parent", np.Value);
		assertEquals("Child", np.Child.Value);
		assertEquals("SubChild", np.Child.Sub.Value);

		DB.delete(p);
		//DB.deactivate(p, 100);
		
		assertEquals("Parent", p.Value);
		assertEquals("Child", p.Child.Value);		
		assertEquals("SubChild", p.Child.Sub.Value);		
		
		q = DB.query();
		q.constrain(DbParent.class);
		os = q.execute();
		
		assertEquals(0, os.size());
		
		q = DB.query();
		q.constrain(DbChild.class);
		os = q.execute();
		
		assertEquals(0, os.size());
		
		q = DB.query();
		q.constrain(DbSubChild.class);
		os = q.execute();
		
		assertEquals(0, os.size());
		
		DB.store(p);
		
		q = DB.query();
		q.constrain(DbParent.class);
		os = q.execute();
		
		assertEquals(1, os.size());
		
		DbParent np1 = os.iterator().next();
		assertEquals("Parent", np1.Value);
		assertEquals("Child", np1.Child.Value);
		assertEquals("SubChild", np1.Child.Sub.Value);
		
	}

}
