package org.ourfilesystem.test.com;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.io.File;
import java.util.HashMap;
import java.util.List;

import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.com.SignatureRequestInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseComInterface;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.security.CryptoComInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.SignedDigest;

public class ComTestFixture implements CoreComInterface, DataBaseComInterface, CryptoComInterface, SignatureRequestInterface {

	public ComPeerInterface IncomingConnection;
	public PostFailed PostFailed;
	public FileFailed FileFailed;
	public ConnectionClosed ConnectionClosed;
	public List<Post> ReceivedPosts;
	public File ReceivedFile;
	public List<Peer> ReceivedPeers;
	public PostRequest PostRequest;
	public boolean RequestedPeers;
	public Object FileRequested;
	public VerifyChallenge VerifyChallenge;
	public Sign Sign;
	public Peer SignatureRequest;
	
	//-- things to set.
	public Peer MyPeer;
	public KeySet MyKeySet;
	public HashMap<Object, Peer> Peers;
	public boolean ProcessPostReturn;
	public Object ProcessFileReturn;
	public List<Post> PostReturn;
	public List<Peer> PeerReturn;
	public File ReturnFile;
	public Object Challenge;
	public boolean Verified;
	public SignedDigest SignedChallenge;
	
	public ComTestFixture() {
		Peers = new HashMap<Object, Peer>();
	}
	
	public class PostFailed {
		public Object ConPeer;
		public Object PeerId;
		public long FromNumber;
		public long ToNumber;
	}
	
	public class FileFailed {
		public Object ConPeer;
		public Object FileDig;
	}
	
	public class ConnectionClosed {
		public Object ConPeer;
		public boolean Error;
	}
	
	public class PostRequest {
		public Object PeerId;
		public long FromNumber;
		public long ToNumber;
	}
	
	public class VerifyChallenge {
		public Object Sent;
		public Object Received;
		public Peer Peer;
	}
	
	public class Sign {
		public Object Challenge;
		public KeySet KeySet;
	}
	
	@Override
	public void newConnection(ComPeerInterface com) {
		IncomingConnection = com;
	}

	@Override
	public void requestPostsFailed(Object conpeer, Object peerid, long fromnumber, long tonumber) {
		PostFailed = new PostFailed();
		PostFailed.ConPeer = conpeer;
		PostFailed.PeerId = peerid;
		PostFailed.FromNumber = fromnumber;
		PostFailed.ToNumber = tonumber;
	}

	@Override
	public void requestFileFailed(Object conpeer, Object filedig) {
		FileFailed = new FileFailed();
		FileFailed.ConPeer = conpeer;
		FileFailed.FileDig = filedig;
	}

	@Override
	public void connectionClosed(Object conpeer, boolean error) {
		ConnectionClosed = new ConnectionClosed();
		ConnectionClosed.ConPeer = conpeer;
		ConnectionClosed.Error = error;
	}

	@Override
	public Peer getMyPeer() {
		return MyPeer;
	}

	@Override
	public KeySet getMyKeySet() {
		return MyKeySet;
	}

	@Override
	public void addEventInterface(EventInterface evt) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Peer getPeer(Object digest) {
		return Peers.get(digest);
	}

	@Override
	public boolean processPeerPosts(List<Post> posts) {
		ReceivedPosts = posts;
		return ProcessPostReturn;
	}

	@Override
	public Object processPeerFile(File frs) {
		ReceivedFile = frs;
		return ProcessFileReturn;
	}

	@Override
	public void processPeers(List<Peer> peers) {
		ReceivedPeers = peers;
	}

	@Override
	public List<Post> requestPosts(Object peerid, long fromnumber, long tonumber) {
		PostRequest = new PostRequest();
		PostRequest.PeerId = peerid;
		PostRequest.FromNumber = fromnumber;
		PostRequest.ToNumber = tonumber;
		return PostReturn;
	}

	@Override
	public List<Peer> requestPeers() {
		RequestedPeers = true;
		return PeerReturn;
	}

	@Override
	public File requestsFiles(Object digestlist) {
		FileRequested = digestlist;
		return ReturnFile;
	}

	@Override
	public Object getChallenge() {
		return Challenge;
	}

	@Override
	public void SignatureRequest(Peer p) {
		SignatureRequest = p;
	}

	@Override
	public boolean verifyChallenge(Object sent, SignedDigest in, Peer p) {
		return Verified;
	}

	@Override
	public SignedDigest signChallenge(Object challenge, KeySet mykeys) {
		return SignedChallenge;
	}

	@Override
	public void requestPostSucceed(Object conpeer, Object peerid) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestFileSucceed(Object conpeer, Object filedig) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean isBadPeer(Object dig) {
		// TODO Auto-generated method stub
		return false;
	}

}
