package org.ourfilesystem.simpleui;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.ourfilesystem.db.LocalFileReference;

public class FileTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 1L;

	private HashSet<LocalFileReference> Files;
	
	private String[] columns = {
			"Reference",
			"Date",
			"Local Copy"
		};
		
		public FileTableModel() {
			Files = new HashSet<LocalFileReference>();
		}
		
		public void addAllFiles(List<LocalFileReference> l) {
			Files.addAll(l);
			fireTableDataChanged();
		}
		
		public void addNewFile(LocalFileReference l) {
			Files.add(l);
			fireTableDataChanged();
		}
		
		public String getColumnName(int col) {
			return columns[col];
		}
		
		@SuppressWarnings({ "unchecked", "rawtypes" })
		public Class getColumnClass(int col) {
			if (col == 0) {
				return String.class;
			}
			if (col == 1) {
				return Date.class;
			}
			if (col == 2) {
				return String.class;
			}
			return null;
		}
		
		@Override
		public int getRowCount() {
			return Files.size();
		}

		@Override
		public int getColumnCount() {
			return columns.length;
		}

		@Override
		public Object getValueAt(int row, int col) {
			LocalFileReference r = null;
			Iterator<LocalFileReference> i = Files.iterator();
			int cnt = 0;
			while (i.hasNext() && cnt <= row) {
				r = i.next();
				cnt++;
			}
			if (r != null) {
				if (col == 0) {
					return r.getFileReference().getUnsignedDigest().toString().substring(0, 10);
				}
				if (col == 1) {
					return r.getLocalDate();
				}
				if (col == 2) {
					return r.getFileReference().getFile();
				}
			}
			return r;
		}


}
