package org.ourfilesystem.simpleui;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.StorageInterface;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public class BadPeerDialog extends JDialog {
	private static final long serialVersionUID = 1L;
	private final JPanel contentPanel = new JPanel();

	private JTable table;
	private PeerTable PeerTable;
	private JPopupMenu PeerPopup;
	private StorageInterface Store;
	private SearchPanel SearchPanel;
	
	public void addAllPeers(List<Peer> peers) {
		PeerTable.addAllPeers(peers);
	}

	/**
	 * Create the dialog.
	 */
	public BadPeerDialog() {
		setTitle("Bad Peers");
		setBounds(100, 100, 450, 300);
		PeerTable = new PeerTable();
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(new BorderLayout(0, 0));
		{
			PeerPopup = new JPopupMenu("Bad Peers");
			JMenuItem exp = new JMenuItem("Mark Selected Peers as Good");
			PeerPopup.add(exp);
			exp.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent a) {
					int rows[] = table.getSelectedRows();
					for (int cnt = 0; cnt < rows.length; cnt++) {
						int r = table.convertRowIndexToModel(rows[cnt]);
						Peer p = PeerTable.getPeer(r);
						Store.removeBadPeer(p.getPeerKeysAndIdentity().getSignature().getDigest());
					}
					update();
				}
			});
			JMenuItem exl = new JMenuItem("Exclude selected peers from search results.");
			PeerPopup.add(exl);
			exl.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent a) {
					int rows[] = table.getSelectedRows();
					for (int cnt = 0; cnt < rows.length; cnt++) {
						int r = table.convertRowIndexToModel(rows[cnt]);
						Peer p = PeerTable.getPeer(r);
						if (p != null) {
							SearchPanel.addExcludePeer(p);
						}
					}
					update();
				}
			});
			JMenuItem inc = new JMenuItem("Include selected peers in search results.");
			PeerPopup.add(inc);
			inc.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent a) {
					int rows[] = table.getSelectedRows();
					for (int cnt = 0; cnt < rows.length; cnt++) {
						int r = table.convertRowIndexToModel(rows[cnt]);
						Peer p = PeerTable.getPeer(r);
						if (p != null) {
							SearchPanel.addIncludePeer(p);
						}
					}
					update();
				}
			});
			JScrollPane scrollPane = new JScrollPane();
			contentPanel.add(scrollPane, BorderLayout.CENTER);
			{
				table = new JTable(PeerTable);
				table.setAutoCreateRowSorter(true);
				scrollPane.setViewportView(table);
				table.setComponentPopupMenu(PeerPopup);
			}
		}
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton btnNewButton = new JButton("Update");
				buttonPane.add(btnNewButton);
				btnNewButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent e) {
						update();
					}
				});
			}
			{
				JButton cancelButton = new JButton("Dismiss");
				cancelButton.setActionCommand("Cancel");
				buttonPane.add(cancelButton);
				cancelButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent e) {
						setVisible(false);
					}
				});
			}
		}
	}

	public void update() {
		this.addAllPeers(Store.listBadPeers());
	}

	public void setStore(StorageInterface store) {
		Store = store;
	}

	public SearchPanel getSearchPanel() {
		return SearchPanel;
	}

	public void setSearchPanel(SearchPanel searchPanel) {
		SearchPanel = searchPanel;
	}

}
