package org.ourfilesystem.filehander;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.io.File;

import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.postcodec.PostDecoded;

public interface FileHandlerInterface {
	
	public void setFileReturnInterface(FileReturnInterface ri);
	
	public void setCoreUserInterface(CoreUserInterface ui);
	
	public void setMaxPendingPeicesDown(int number);
	
	public int getMaxPendingPeicesDown();
	
	public void insertFile(File file, PostDecoded dec);
	
	public void requestFile(File saveas, PostDecoded dec, boolean paused, int priority);
	
	public void pauseFile(File saveas);
	
	public void resumeFile(File saveas);
	
	public void removeFile(File saveas);
	
	public void setPriority(File saveas, int priority);
	
	public void updateAllStatus();
	
}
