package org.ourfilesystem.db;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

public class PostHoles {
	
	private Object PeerId;
	private long FirstNumber;
	private long LastNumber;
	
	public PostHoles(long lastlastnum, long newpost) {
		FirstNumber = lastlastnum;
		LastNumber = newpost;
	}

	public long getFirstNumber() {
		return FirstNumber;
	}

	public void setFirstNumber(long firstNumber) {
		FirstNumber = firstNumber;
	}

	public long getLastNumber() {
		return LastNumber;
	}

	public void setLastNumber(long lastNumber) {
		LastNumber = lastNumber;
	}

	public PostHoles newPostReceived(long num) {
		if (FirstNumber == num) {
			FirstNumber++;
		}
		else if (LastNumber == num) {
			LastNumber--;
		}
		else if (FirstNumber < num && num < LastNumber) {
			PostHoles ph = new PostHoles(FirstNumber, num-1);
			FirstNumber = num + 1;
			return ph;
		}
		return null;
	}
	
	public boolean isDone() {
		return FirstNumber > LastNumber;
	}

	public Object getPeerId() {
		return PeerId;
	}

	public void setPeerId(Object peerId) {
		PeerId = peerId;
	}

}
