package org.ourfilesystem.db;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import org.ourfilesystem.security.SignedDigest;

public class Post {
	
	/**
	 * This is a small piece of data to be handled by higher level presentation pieces of code.
	 * This data must be small, because it is always sync'd with other peers.  The crypto engine
	 * must be able to know how to digest the object that is passed.  This will most likely
	 * be a file, but we don't want to limit to only files here.
	 */
	private Object Message;
	
	/**
	 * This is an optional UnsignedDigest to a FileReference.  This allows us to optionally link
	 * a message to a larger file.  This allows us to attribute files using Posts. 
	 */
	private Object FileReferenceDigest;
	
	/**
	 * The Peer that posted this message actually has the file.
	 * Peers that don't have files can still attribute them.
	 */
	private boolean PosterHasFile;
	
	/**
	 * The number of this message.
	 */
	private long PostNumber;
	
	/**
	 * This is the signed digest of the Message and the FileReference UnsignedDigest.  Signed by
	 * the Original Poster. 
	 */
	private SignedDigest SignedDigest;

	public Object getMessage() {
		return Message;
	}

	public void setMessage(Object message) {
		Message = message;
	}

	public Object getFileReferenceDigest() {
		return FileReferenceDigest;
	}

	public void setFileReferenceDigest(Object fileReferenceDigest) {
		FileReferenceDigest = fileReferenceDigest;
	}

	public SignedDigest getSignedDigest() {
		return SignedDigest;
	}

	public void setSignedDigest(SignedDigest signedDigest) {
		SignedDigest = signedDigest;
	}

	public boolean isPosterHasFile() {
		return PosterHasFile;
	}

	public void setPosterHasFile(boolean posterHasFile) {
		PosterHasFile = posterHasFile;
	}

	public long getPostNumber() {
		return PostNumber;
	}

	public void setPostNumber(long postNumber) {
		PostNumber = postNumber;
	}
	
	public boolean equals(Object o) {
		if (!(o instanceof Post)) {
			return false;
		}
		Post op = (Post)o;
		if (op.getPostNumber() != getPostNumber()) return false;
		if (!op.getSignedDigest().getPeerIdentifier().equals(getSignedDigest().getPeerIdentifier())) return false;
		return true;
	}
	
	public int hashCode() {
		return (int)getPostNumber() ^ getSignedDigest().getPeerIdentifier().hashCode();
	}

}
