package org.ourfilesystem.db;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.io.File;

public class FileReference {
	
	/**
	 * This is the simple digest of the file.  It is unsigned so that
	 * we can limit duplicate files from multiple users.
	 */
	private Object UnsignedDigest;
	
	/**
	 * This is OPTIONAL real file reference to the local file system.
	 * If this peer does not download the file or is not the source, then
	 * this is null.
	 */
	private File File;

	public Object getUnsignedDigest() {
		return UnsignedDigest;
	}

	public void setUnsignedDigest(Object unsignedDigest) {
		UnsignedDigest = unsignedDigest;
	}

	public File getFile() {
		return File;
	}

	public void setFile(File file) {
		File = file;
	}

}
