package org.ourfilesystem.db;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.security.PublicKeySetSigned;
import org.ourfilesystem.security.SignedDigest;

public class DataBaseTools {

	public static boolean verifyPeerSignature(Peer p, StorageInterface store, CryptoDataBaseInterface security) {
		PublicKeySetSigned s = p.getPeerKeysAndIdentity();
		if (s != null) {
			SignedDigest sg = s.getSignature();
			if (sg != null) {
				if (store.isBadPeer(sg.getDigest())) {
					return false;
				}
				Object signid = sg.getPeerIdentifier();
				if (store.isBadPeer(signid)) {
					return false;
				}
				Peer signpeer = store.getPeer(signid);
				if (signpeer != null) {
					if (security.verifyPeer(s, signpeer.getPeerKeysAndIdentity().getPublicSigningKey())) {
						Peer mp = store.getMyPeerData();
						if (security.digEquals(mp.getPeerKeysAndIdentity().getSignature().getDigest(), signid)) {
							return true;
						}
						else {
							return verifyPeerSignature(signpeer, store, security);								
						}
					}
				}
			}
		}
		return false;
	}
	
}
