package org.ourfilesystem.db;

/*
    OurFileSystem is a peer2peer file sharing program.
    Copyright (C) 2012  Robert Gass

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */

import java.io.File;
import java.util.List;

import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.security.KeySet;

public interface DataBaseComInterface {
	
	/**
	 * Get the peer data for this peer.
	 * @return
	 */
	public Peer getMyPeer();
	
	/**
	 * Get the keyset for this node so we can authenticate
	 * with other peers when we connect.
	 * @return
	 */
	public KeySet getMyKeySet();
	
	/**
	 * Once data is successfully processed from a peer we 
	 * can send events to the user interface.
	 * @param evt
	 */
	public void addEventInterface(EventInterface evt);
	
	/**
	 * The the peer for new connection.  Used to establish encryption between peers.
	 * @param digest
	 * @return
	 */
	public Peer getPeer(Object digest);
	
	/**
	 * Posts have been received from someone.  Here they must
	 * be verified and then added to the database.
	 * Add all that are valid, then throw the exception if any have been found invalid.
	 * @param posts
	 */
	public boolean processPeerPosts(List<Post> posts);
	
	/**
	 * Process FileReferences.  All we do is check the signature and 
	 * store the file after checking for duplicates.
	 * Add all that are valid, then throw the exception if any have been found invalid.
	 * @param frs
	 */
	public Object processPeerFile(File frs);
	
	/**
	 * Process new peer data.  Check the signatures.  Add the user
	 * if the signature is validated.
	 * @param peers
	 */
	public void processPeers(List<Peer> peers);
	
	/**
	 * Return all the messages from the signing peer after the start digest up to 
	 * the end digest up to the max.  Error must be returned if the same peer has not signed
	 * the start and the end.
	 * @param start
	 * @param end
	 * @param max
	 * @return
	 */
	public List<Post> requestPosts(Object peerid, long fromnumber, long tonumber);
	
	/**
	 * Return all the peers we know of.
	 * @return
	 */
	public List<Peer> requestPeers();
	
	/**
	 * Request all the file references this node has that matches the digests passed
	 * up to the max. 
	 * @param digestlist
	 * @param max
	 * @return
	 */
	public File requestsFiles(Object digestlist);
	
	public boolean isBadPeer(Object dig);
	
	
}
