/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.utilities.BBytes;

public class FileUtils {
    public static long MAXFILESIZE = 0xA00000L;

    public static void writeBytes(OutputStream os, byte[] b) throws IOException {
        if (b == null) {
            os.write(2);
        } else {
            os.write(1);
            byte[] ob = new byte[b.length + 4];
            ByteBuffer buf = ByteBuffer.wrap(ob);
            buf.putInt(b.length);
            buf.put(b);
            os.write(ob);
        }
    }

    public static byte[] readBytes(InputStream i) throws IOException {
        int f = i.read();
        if (f == 2) {
            return null;
        }
        byte[] lb = new byte[4];
        FileUtils.fillBytes(lb, i);
        ByteBuffer buf = ByteBuffer.wrap(lb);
        int len = buf.getInt();
        if ((long)len > MAXFILESIZE) {
            throw new IOException("Byte buffer too large.");
        }
        byte[] ob = new byte[len];
        FileUtils.fillBytes(ob, i);
        return ob;
    }

    public static void fillBytes(byte[] b, InputStream i) throws IOException {
        int len = i.read(b);
        while (len < b.length && len != -1) {
            int il = i.read(b, len, b.length - len);
            if (il == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (il <= 0) continue;
            len += il;
        }
    }

    public static void writeLong(long v, OutputStream os) throws IOException {
        byte[] b = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.putLong(v);
        FileUtils.writeBytes(os, b);
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] b = FileUtils.readBytes(is);
        ByteBuffer buf = ByteBuffer.wrap(b);
        return buf.getLong();
    }

    public static void writeInt(int v, OutputStream os) throws IOException {
        byte[] b = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.putInt(v);
        FileUtils.writeBytes(os, b);
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] b = FileUtils.readBytes(is);
        ByteBuffer buf = ByteBuffer.wrap(b);
        return buf.getInt();
    }

    public static void writeString(String s, OutputStream os) throws IOException {
        if (s == null) {
            os.write(2);
        } else {
            os.write(1);
            FileUtils.writeBytes(os, s.getBytes(Charset.forName("UTF-16BE")));
        }
    }

    public static String readString(InputStream is) throws IOException {
        int v = is.read();
        if (v == 2) {
            return null;
        }
        byte[] b = FileUtils.readBytes(is);
        return new String(b, Charset.forName("UTF-16BE"));
    }

    public static List<File> findFiles(String dir, String filename) {
        LinkedList<File> rf = new LinkedList<File>();
        File df = new File(dir);
        if (df.isDirectory()) {
            Pattern p = Pattern.compile(filename);
            Matcher m = p.matcher("");
            FileUtils.findFiles(df, m, rf);
        }
        return rf;
    }

    private static void findFiles(File dir, Matcher m, List<File> rf) {
        if (dir.exists() && dir.isDirectory()) {
            File[] fl = dir.listFiles();
            int cnt = 0;
            while (cnt < fl.length) {
                if (fl[cnt].exists()) {
                    if (fl[cnt].isDirectory()) {
                        FileUtils.findFiles(fl[cnt], m, rf);
                    } else {
                        m.reset(fl[cnt].getName());
                        if (m.find()) {
                            rf.add(fl[cnt]);
                        }
                    }
                }
                ++cnt;
            }
        }
    }

    public static void copyFile(File from, File to, boolean deleteoncopy) throws IOException {
        FileOutputStream fos = new FileOutputStream(to);
        FileChannel foc = fos.getChannel();
        FileInputStream fis = new FileInputStream(from);
        FileChannel fic = fis.getChannel();
        foc.transferFrom(fic, 0L, from.length());
        foc.close();
        fic.close();
        if (deleteoncopy) {
            from.delete();
        }
    }

    public static void writePeer(OutputStream os, Peer p) throws IOException {
        FileUtils.writeLong(p.getUpdateCount(), os);
        FileUtils.writeString(p.getIntroduction(), os);
        SecurityTools.writePublicKeySetSigned(p.getPeerKeysAndIdentity(), os);
        FileUtils.writeString((String)p.getLocation(), os);
        FileUtils.writeString(p.getNickname(), os);
        SecurityTools.writeSignedDigest(p.getLocationSignature(), os);
    }

    public static Peer readPeer(InputStream is) throws IOException {
        Peer p = new Peer();
        p.setUpdateCount(FileUtils.readLong(is));
        p.setIntroduction(FileUtils.readString(is));
        p.setPeerKeysAndIdentity(SecurityTools.readPublicKeySetSigned(is));
        p.setLocation(FileUtils.readString(is));
        p.setNickname(FileUtils.readString(is));
        p.setLocationSignature(SecurityTools.readSignedDigest(is));
        return p;
    }

    public static Post readPost(InputStream is, File TempDir) throws IOException {
        Post p = new Post();
        int v = is.read();
        if (v == 1) {
            p.setFileReferenceDigest(new BBytes(FileUtils.readBytes(is)));
        }
        if ((v = is.read()) == 1) {
            File f = File.createTempFile("postinput", ".dat", TempDir);
            FileUtils.readFile(is, f);
            p.setMessage(f);
        }
        p.setPostNumber(FileUtils.readLong(is));
        v = is.read();
        if (v == 1) {
            p.setPosterHasFile(true);
        } else {
            p.setPosterHasFile(false);
        }
        p.setSignedDigest(SecurityTools.readSignedDigest(is));
        return p;
    }

    public static void writePost(OutputStream os, Post p) throws IOException {
        if (p.getFileReferenceDigest() == null) {
            os.write(2);
        } else {
            os.write(1);
            FileUtils.writeBytes(os, ((BBytes)p.getFileReferenceDigest()).getBytes());
        }
        if (p.getMessage() == null) {
            os.write(2);
        } else {
            os.write(1);
            FileUtils.sendFile(os, (File)p.getMessage());
        }
        FileUtils.writeLong(p.getPostNumber(), os);
        if (p.isPosterHasFile()) {
            os.write(1);
        } else {
            os.write(0);
        }
        SecurityTools.writeSignedDigest(p.getSignedDigest(), os);
    }

    public static void sendFile(OutputStream os, File in) throws IOException {
        long numlength = in.length();
        FileUtils.writeLong(numlength, os);
        FileInputStream fis = new FileInputStream(in);
        FileChannel fic = fis.getChannel();
        WritableByteChannel oc = Channels.newChannel(os);
        long pos = 0L;
        while (numlength > 0L) {
            long num = fic.transferTo(pos, numlength, oc);
            pos += num;
            numlength -= num;
        }
        fic.close();
    }

    public static void readFile(InputStream is, File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        FileChannel foc = fos.getChannel();
        long len = FileUtils.readLong(is);
        if (len > MAXFILESIZE) {
            throw new RuntimeException("File too large.");
        }
        long pos = 0L;
        ReadableByteChannel ic = Channels.newChannel(is);
        while (len > 0L) {
            long nt = foc.transferFrom(ic, pos, len);
            if (nt == 0L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            pos += nt;
            len -= nt;
        }
        foc.close();
    }

    public static void deleteDir(String f) {
        FileUtils.deleteDir(new File(f));
    }

    public static void deleteDir(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] fl = f.listFiles();
                int c = 0;
                while (c < fl.length) {
                    FileUtils.deleteDir(fl[c]);
                    ++c;
                }
            }
            f.delete();
        }
    }

    public static boolean diff(File f0, File f1) throws IOException {
        int b1;
        int b0;
        if (f0.length() != f1.length()) {
            return false;
        }
        FileInputStream fi0 = new FileInputStream(f0);
        FileInputStream fi1 = new FileInputStream(f1);
        boolean eq = true;
        do {
            if ((b0 = fi0.read()) == (b1 = fi1.read())) continue;
            eq = false;
        } while (b0 != -1 && b1 != -1 && eq);
        fi0.close();
        fi1.close();
        return eq;
    }
}

