/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui.db;

import com.db4o.Db4oEmbedded;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.postcodec.Codec;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.ui.db.DBInterface;
import org.ourfilesystem.ui.db.QueryResultsImpl;
import org.ourfilesystem.ui.db.QueryResultsInterface;
import org.ourfilesystem.utilities.BBytes;

public class DBImpl
implements DBInterface,
EventInterface {
    private ObjectContainer DB;

    public DBImpl(String file) {
        this.DB = Db4oEmbedded.openFile((String)file);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DBImpl.this.DB.close();
            }
        });
    }

    @Override
    public void saveNewPost(final PostDecoded p) {
        ObjectSet os = this.DB.query((Predicate)new Predicate<PostDecoded>(){

            public boolean match(PostDecoded c) {
                return c.getPost().getPost().equals(p.getPost().getPost());
            }
        });
        if (os.size() == 0) {
            this.DB.store((Object)p);
            this.DB.commit();
        }
    }

    @Override
    public QueryResultsInterface search(final HashMap<String, HashSet<String>> orstring, final HashMap<String, HashSet<String>> andstring, final HashMap<String, HashSet<String>> excludestrings, final HashMap<String, HashSet<Long>> ornum, final HashMap<String, Long> andnums, final HashMap<String, Long> lessthan, final HashMap<String, Long> greaterthan, HashMap<String, Long> averagelessthan, HashMap<String, Long> averagegreaterthan, final HashSet<String> excludebackrefs, final HashMap<String, HashSet<Object>> hasreferences, final HashSet<Object> directrefs, final HashSet<BBytes> includepeers, final HashSet<BBytes> excludepeers, final Date fromd, final Date tod) {
        final HashSet excludebad = new HashSet();
        final HashSet excluderefs = new HashSet();
        final HashSet includerefs = new HashSet();
        ObjectSet os = this.DB.query((Predicate)new Predicate<PostDecoded>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean match(PostDecoded p) {
                Long v;
                String s;
                BBytes peerid;
                Object stri;
                Matcher m;
                Object ks;
                boolean ok = true;
                if (excludestrings != null) {
                    for (Map.Entry e : excludestrings.entrySet()) {
                        ks = p.getStringKeySet((String)e.getKey());
                        if (ks == null) continue;
                        for (String string : (HashSet)e.getValue()) {
                            String string3 = string.toLowerCase();
                            string3 = string3.replaceAll("\\*", ".*");
                            m = Pattern.compile(string3).matcher("");
                            stri = ks.iterator();
                            while (stri.hasNext()) {
                                String s2 = (String)stri.next();
                                s2 = s2.toLowerCase();
                                m.reset(s2);
                                if (!m.find()) continue;
                                BBytes ref = (BBytes)p.getPost().getPost().getFileReferenceDigest();
                                if (ref != null) {
                                    HashSet hashSet = excludebad;
                                    synchronized (hashSet) {
                                        excludebad.add(ref);
                                    }
                                }
                                return false;
                            }
                        }
                    }
                }
                if (excludebackrefs != null) {
                    for (String k : excludebackrefs) {
                        Set<Object> os = p.getOtherReferences().get(k);
                        if (os == null) continue;
                        for (BBytes bBytes : os) {
                            if (bBytes == null) continue;
                            BBytes br = (BBytes)p.getPost().getPost().getFileReferenceDigest();
                            if (br != null) {
                                stri = excluderefs;
                                synchronized (stri) {
                                    excluderefs.add(br);
                                }
                                return false;
                            }
                            stri = includerefs;
                            synchronized (stri) {
                                includerefs.add(bBytes);
                            }
                        }
                    }
                }
                if (fromd != null && p.getPost().getLocalDate().compareTo(fromd) < 0) {
                    return false;
                }
                if (tod != null && p.getPost().getLocalDate().compareTo(tod) > 0) {
                    return false;
                }
                if (directrefs != null && directrefs.size() > 0 && !directrefs.contains(p.getPost().getPost().getFileReferenceDigest())) {
                    return false;
                }
                if (includepeers != null && includepeers.size() > 0 && !includepeers.contains(peerid = (BBytes)p.getPost().getPost().getSignedDigest().getPeerIdentifier())) {
                    return false;
                }
                if (excludepeers != null && excludepeers.size() > 0 && excludepeers.contains(peerid = (BBytes)p.getPost().getPost().getSignedDigest().getPeerIdentifier())) {
                    return false;
                }
                if (orstring != null) {
                    for (Map.Entry e : orstring.entrySet()) {
                        if (e.getValue() == null || ((HashSet)e.getValue()).size() <= 0) continue;
                        ks = p.getStringKeySet((String)e.getKey());
                        boolean thisoneok = false;
                        Iterator iterator = ((HashSet)e.getValue()).iterator();
                        while (iterator.hasNext() && !thisoneok) {
                            String v3 = (String)iterator.next();
                            v3 = v3.toLowerCase();
                            if (ks == null) continue;
                            v3 = v3.replaceAll("\\*", ".*");
                            Matcher m2 = Pattern.compile(v3).matcher("");
                            Iterator stri2 = ks.iterator();
                            while (stri2.hasNext() && !thisoneok) {
                                s = (String)stri2.next();
                                s = s.toLowerCase();
                                m2.reset(s);
                                if (!m2.find()) continue;
                                thisoneok = true;
                            }
                        }
                        if (thisoneok) continue;
                        return false;
                    }
                }
                if (andstring != null) {
                    for (Map.Entry e : andstring.entrySet()) {
                        ks = p.getStringKeySet((String)e.getKey());
                        if (e.getValue() == null || ((HashSet)e.getValue()).size() <= 0) continue;
                        if (ks == null) {
                            return false;
                        }
                        for (String string : (HashSet)e.getValue()) {
                            String string5 = string.toLowerCase();
                            string5 = string5.replaceAll("\\*", ".*");
                            m = Pattern.compile(string5).matcher("");
                            Iterator sti = ks.iterator();
                            boolean fnd = false;
                            while (sti.hasNext() && !fnd) {
                                s = (String)sti.next();
                                s = s.toLowerCase();
                                m.reset(s);
                                if (!m.find()) continue;
                                fnd = true;
                            }
                            if (fnd) continue;
                            return false;
                        }
                    }
                }
                if (ornum != null) {
                    for (Map.Entry e : ornum.entrySet()) {
                        if (e.getValue() == null || ((HashSet)e.getValue()).size() <= 0) continue;
                        ks = p.getNumberValues().get(e.getKey());
                        if (ks != null) {
                            if (((HashSet)e.getValue()).contains(ks)) continue;
                            return false;
                        }
                        return false;
                    }
                }
                if (andnums != null) {
                    for (Map.Entry e : andnums.entrySet()) {
                        ks = p.getNumberValues().get(e.getKey());
                        if (e.getValue() == null) continue;
                        if (ks == null) {
                            return false;
                        }
                        if (((Long)ks).equals(e.getValue())) continue;
                        return false;
                    }
                }
                if (lessthan != null) {
                    for (Map.Entry e : lessthan.entrySet()) {
                        v = p.getNumberValues().get(e.getKey());
                        if (e.getValue() == null) continue;
                        if (v == null) {
                            return false;
                        }
                        if (((Long)e.getValue()).compareTo(v) >= 0) continue;
                        return false;
                    }
                }
                if (greaterthan != null) {
                    for (Map.Entry e : greaterthan.entrySet()) {
                        v = p.getNumberValues().get(e.getKey());
                        if (e.getValue() == null) continue;
                        if (v == null) {
                            return false;
                        }
                        if (((Long)e.getValue()).compareTo(v) <= 0) continue;
                        return false;
                    }
                }
                if (hasreferences != null) {
                    int cnt = 0;
                    boolean hasref = false;
                    Iterator i = hasreferences.entrySet().iterator();
                    while (i.hasNext() && !hasref) {
                        Map.Entry e = i.next();
                        String string = (String)e.getKey();
                        Set refs = (Set)e.getValue();
                        Set<Object> prefs = p.getOtherReferences().get(string);
                        if (refs == null) continue;
                        Iterator i2 = refs.iterator();
                        while (i2.hasNext() && !hasref) {
                            Object r = i2.next();
                            ++cnt;
                            if (prefs == null || !prefs.contains(r)) continue;
                            hasref = true;
                        }
                    }
                    if (cnt == 0) {
                        hasref = true;
                    }
                    if (!hasref) {
                        return false;
                    }
                }
                return ok;
            }
        });
        LinkedList<PostDecoded> rl = new LinkedList<PostDecoded>();
        excluderefs.removeAll(includerefs);
        for (PostDecoded p : os) {
            if (excludebackrefs != null || excluderefs.size() > 0) {
                boolean remove = false;
                BBytes ref = (BBytes)p.getPost().getPost().getFileReferenceDigest();
                if (ref != null) {
                    if (excluderefs.contains(ref)) {
                        remove = true;
                    }
                    if (excludebad.contains(ref)) {
                        remove = true;
                    }
                }
                if (remove) continue;
                rl.add(p);
                continue;
            }
            rl.add(p);
        }
        QueryResultsImpl r = new QueryResultsImpl(rl);
        return r;
    }

    @Override
    public void newPostReceived(LocalPost postlist) {
        try {
            PostDecoded pd = Codec.decode(postlist);
            this.saveNewPost(pd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void newPeerReceived(final Peer peer) {
        ObjectSet os = this.DB.query((Predicate)new Predicate<Peer>(){

            public boolean match(Peer p) {
                return p.getPeerKeysAndIdentity().getSignature().getDigest().equals(peer.getPeerKeysAndIdentity().getSignature().getDigest());
            }
        });
        Iterator i = os.iterator();
        while (i.hasNext()) {
            this.DB.delete(i.next());
        }
        this.DB.store((Object)peer);
        this.DB.commit();
    }

    @Override
    public void newFileDownloaded(LocalFileReference filelist) {
    }

    @Override
    public void downloadFailed(Object dig) {
    }

    @Override
    public void connectionFailure(Peer p) {
    }

    @Override
    public synchronized Peer searchPeer(final Object id) {
        ObjectSet os = this.DB.query((Predicate)new Predicate<Peer>(){

            public boolean match(Peer p) {
                return p.getPeerKeysAndIdentity().getSignature().getDigest().equals(id);
            }
        });
        if (os.size() > 0) {
            Iterator i = os.iterator();
            return (Peer)i.next();
        }
        return null;
    }

    @Override
    public void connectionEvent(ConnectionUpdateInterface con) {
    }
}

