/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.test.ui.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.ourfilesystem.filehander.FileSplitter;
import org.ourfilesystem.utilities.FileUtils;

public class FileSplitterTest {
    @Test
    public void test() {
        try {
            Random r = new Random();
            long totalsize = 1047552L;
            File tmpdir = new File("tmpdir99");
            if (tmpdir.exists()) {
                if (!tmpdir.isDirectory()) {
                    Assert.fail();
                }
            } else {
                tmpdir.mkdirs();
            }
            File startfile = File.createTempFile("startfile", ".dat", tmpdir);
            System.out.println("Starting file: " + startfile);
            FileOutputStream fos = new FileOutputStream(startfile);
            byte[] b = new byte[1024];
            long pos = 0L;
            while (pos < totalsize) {
                r.nextBytes(b);
                int ws = Math.min((int)(totalsize - pos), 1024);
                fos.write(b, 0, ws);
                pos += (long)ws;
            }
            fos.close();
            long splitsize = 23552L;
            List<File> flist = FileSplitter.split(startfile, tmpdir, splitsize);
            int expected = (int)(totalsize / splitsize);
            if (totalsize % splitsize != 0L) {
                ++expected;
            }
            Assert.assertEquals((long)flist.size(), (long)expected);
            for (File f : flist) {
                if (f.length() <= splitsize + 16L) continue;
                System.out.println("fsize: " + f.length() + " splitsize: " + splitsize);
                Assert.fail();
            }
            File outfile = File.createTempFile("endfile", ".dat", tmpdir);
            int cnt = flist.size() - 1;
            while (cnt >= 0) {
                System.out.println(" + " + flist.get(cnt));
                FileSplitter.insert(outfile, flist.get(cnt));
                --cnt;
            }
            System.out.println("diff: " + startfile + " <> " + outfile);
            Assert.assertTrue((boolean)FileUtils.diff(startfile, outfile));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

