/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.test.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.com.SignatureRequestInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;

public class CoreTestListener
implements EventInterface,
SignatureRequestInterface {
    @Override
    public void SignatureRequest(Peer p) {
        System.out.println("---------------------------------------------------------");
        System.out.println("Peer requested a signature: " + p.getIntroduction() + " @ " + p.getLocation());
        System.out.println("---------------------------------------------------------");
    }

    @Override
    public void newPostReceived(LocalPost postlist) {
        System.out.println("---------------------------------------------------------");
        System.out.println("New post received: " + postlist.getLocalDate() + " :: N" + postlist.getPost().getPostNumber());
        System.out.println("Linked to file? " + (postlist.getPost().getFileReferenceDigest() != null));
        File mf = (File)postlist.getPost().getMessage();
        try {
            byte[] buf = new byte[1024];
            FileInputStream fis = new FileInputStream(mf);
            int numread = fis.read(buf);
            while (numread != -1) {
                System.out.write(buf, 0, numread);
                numread = fis.read(buf);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("---------------------------------------------------------");
    }

    @Override
    public void newPeerReceived(Peer peerlist) {
        System.out.println("---------------------------------------------------------");
        System.out.println("Peer received: " + peerlist.getIntroduction() + " @ " + peerlist.getLocation());
        System.out.println("---------------------------------------------------------");
    }

    @Override
    public void newFileDownloaded(LocalFileReference filelist) {
        System.out.println("---------------------------------------------------------");
        System.out.println("File downloaded: " + filelist.getLocalDate() + " :: " + filelist.getFileReference().getFile());
        System.out.println("---------------------------------------------------------");
    }

    @Override
    public void downloadFailed(Object dig) {
        System.out.println("---------------------------------------------------------");
        System.out.println("Download failed: " + dig);
        System.out.println("---------------------------------------------------------");
    }

    @Override
    public void connectionFailure(Peer p) {
    }

    @Override
    public void connectionEvent(ConnectionUpdateInterface con) {
    }
}

