/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.ourfilesystem.com.ComConnectionImpl;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSServerSocket;
import org.ourfilesystem.com.SignatureRequestInterface;
import org.ourfilesystem.core.Core;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseComImpl;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.StorageImpl2;
import org.ourfilesystem.db.TimeImpl;
import org.ourfilesystem.filehander.FileHandler;
import org.ourfilesystem.filehander.FileReturnInterface;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.security.CryptoComImpl;
import org.ourfilesystem.security.CryptoDataBaseImpl;
import org.ourfilesystem.simpleui.BadPeerDialog;
import org.ourfilesystem.simpleui.ConnectionsTable;
import org.ourfilesystem.simpleui.DownloadsTableModel;
import org.ourfilesystem.simpleui.ExpandedPostDialog;
import org.ourfilesystem.simpleui.ExpandedPostTableModel;
import org.ourfilesystem.simpleui.NetworkConfigDialog;
import org.ourfilesystem.simpleui.NewExpandedPostDialog;
import org.ourfilesystem.simpleui.PeerTable;
import org.ourfilesystem.simpleui.SearchPanel;
import org.ourfilesystem.simpleui.SignRequestDialog;
import org.ourfilesystem.simpleui.WriteDefaultPostTemplate;
import org.ourfilesystem.simpleui.WriteDefaultSearchTemplate;
import org.ourfilesystem.ui.db.DBImpl;
import org.ourfilesystem.utilities.FileUtils;
import org.ourfilesystem.utilities.Licenses;

public class SimpleGUI
implements EventInterface,
SignatureRequestInterface,
FileReturnInterface {
    private JFrame frame;
    private JTextField textField;
    private NetworkConfigDialog ProxyDialog;
    private ComConnectionImpl Com;
    private Core Core;
    private String BaseDir;
    private File DownloadDir;
    private int Port;
    private PeerTable PeerTable;
    private ConnectionsTable ConTable;
    private BadPeerDialog BadDialog;
    private StorageImpl2 Store;
    private DBImpl SearchDB;
    private ExpandedPostTableModel ExpPostTable;
    private FileHandler FHandler;
    private JTextField textField_2;
    private JTable table;
    private JTable table_1;
    private JPopupMenu SearchPopup;
    private JPopupMenu PeerPopup;
    private JTextField textField_3;
    private JTable table_4;
    private SearchPanel SearchPanel;
    private NewExpandedPostDialog NewPostDialog;
    private ExpandedPostDialog PostDialog;
    private DownloadsTableModel DownloadModel;
    private JTable DownloadsTable;
    private JPopupMenu DownloadMenu;
    private HashSet<Peer> SignaturesRequested;
    private File ChooserDir = new File(".");

    public void InitPeer(OFSServerSocket server, OFSConnector con, boolean editlocation) {
        if (this.Core == null || this.Com == null) {
            this.Core = new Core();
            this.Store = new StorageImpl2(this.BaseDir);
            Peer p = this.Store.getMyPeerData();
            CryptoDataBaseImpl sec = new CryptoDataBaseImpl();
            TimeImpl time = new TimeImpl();
            DataBaseComImpl comdb = new DataBaseComImpl(this.Core);
            comdb.setStore(this.Store);
            comdb.addEventInterface(this);
            comdb.addEventInterface(this.SearchDB);
            comdb.setSecurity(sec);
            comdb.setTime(time);
            CryptoComImpl cryptcom = new CryptoComImpl();
            this.Com = new ComConnectionImpl(this.Core, comdb, cryptcom, this, String.valueOf(this.BaseDir) + File.separator + "tmp", server, con);
            this.Core.setComConnector(this.Com);
            this.Core.setComDataBase(comdb);
            this.Core.addEventInterface(this);
            this.Core.addEventInterface(this.SearchDB);
            this.Core.setSecurity(sec);
            this.Core.setUserDataBase(this.Store);
            this.Core.setTime(time);
            this.FHandler = new FileHandler(String.valueOf(this.BaseDir) + File.separator + "searchdb.dat", String.valueOf(this.BaseDir) + File.separator + "tmp", this.Core, this);
            this.Core.addEventInterface(this.FHandler);
            comdb.addEventInterface(this.FHandler);
            if (p == null) {
                System.out.println("WARNING: No peer data was found.  Generating new keys.");
                this.Core.generateNewKeys();
            }
            this.initialize(editlocation);
            this.frame.setVisible(true);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("The SimpleGUI requires one argument.");
            System.out.println("<basedir>");
            System.exit(1);
        }
        System.out.println(Licenses.getLicense());
        final String basedir = args[0];
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new SimpleGUI(basedir);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SimpleGUI(String basedir) {
        this.SignaturesRequested = new HashSet();
        this.BaseDir = basedir;
        this.DownloadDir = new File(String.valueOf(this.BaseDir) + File.separator + "downloads");
        this.DownloadDir.mkdirs();
        final File lockfile = new File(String.valueOf(this.BaseDir) + File.separator + "lock.dat");
        if (lockfile.exists()) {
            System.out.println("ERROR: Delete: " + lockfile + " to restart.");
            System.exit(1);
        } else {
            try {
                lockfile.createNewFile();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        lockfile.delete();
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.SearchDB = new DBImpl(String.valueOf(basedir) + File.separator + "search.dat");
        this.FHandler = new FileHandler(String.valueOf(basedir) + File.separator + "filedb.dat", String.valueOf(basedir) + File.separator + "tmp", this.Core, this);
        this.ProxyDialog = new NetworkConfigDialog(this, basedir);
    }

    public void addLocalPost(Object message, Object fileref) {
        this.Core.addLocalPost(message, fileref);
    }

    public void insertFile(File fileref, PostDecoded post) {
        if (fileref.isFile()) {
            this.FHandler.insertFile(fileref, post);
        }
        if (fileref.isDirectory()) {
            File[] flist = fileref.listFiles();
            int cnt = 0;
            while (cnt < flist.length) {
                this.insertFile(flist[cnt], post);
                ++cnt;
            }
        }
    }

    private void initialize(boolean editlocation) {
        this.PostDialog = new ExpandedPostDialog(this);
        this.frame = new JFrame();
        this.frame.setBounds(100, 100, 850, 700);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout(0, 0));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.frame.getContentPane().add(tabbedPane);
        JPanel panel = new JPanel();
        tabbedPane.addTab("Identity", null, panel, null);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[5];
        int[] nArray = new int[13];
        nArray[1] = 28;
        gbl_panel.rowHeights = nArray;
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblIpurl = new JLabel("IP/URL:Port");
        GridBagConstraints gbc_lblIpurl = new GridBagConstraints();
        gbc_lblIpurl.anchor = 12;
        gbc_lblIpurl.insets = new Insets(0, 0, 5, 5);
        gbc_lblIpurl.gridx = 1;
        gbc_lblIpurl.gridy = 1;
        panel.add((Component)lblIpurl, gbc_lblIpurl);
        this.textField = new JTextField();
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.fill = 2;
        gbc_textField.insets = new Insets(0, 0, 5, 5);
        gbc_textField.gridx = 2;
        gbc_textField.gridy = 1;
        panel.add((Component)this.textField, gbc_textField);
        this.textField.setColumns(10);
        this.textField.setEditable(editlocation);
        JLabel lblIntroduction = new JLabel("Introduction");
        GridBagConstraints gbc_lblIntroduction = new GridBagConstraints();
        gbc_lblIntroduction.anchor = 13;
        gbc_lblIntroduction.insets = new Insets(0, 0, 5, 5);
        gbc_lblIntroduction.gridx = 1;
        gbc_lblIntroduction.gridy = 2;
        panel.add((Component)lblIntroduction, gbc_lblIntroduction);
        this.textField_2 = new JTextField();
        GridBagConstraints gbc_textField_2 = new GridBagConstraints();
        gbc_textField_2.insets = new Insets(0, 0, 5, 5);
        gbc_textField_2.fill = 2;
        gbc_textField_2.gridx = 2;
        gbc_textField_2.gridy = 2;
        panel.add((Component)this.textField_2, gbc_textField_2);
        this.textField_2.setColumns(10);
        JLabel lblNickname = new JLabel("Nickname");
        GridBagConstraints gbc_lblNickname = new GridBagConstraints();
        gbc_lblNickname.anchor = 13;
        gbc_lblNickname.insets = new Insets(0, 0, 5, 5);
        gbc_lblNickname.gridx = 1;
        gbc_lblNickname.gridy = 3;
        panel.add((Component)lblNickname, gbc_lblNickname);
        this.textField_3 = new JTextField();
        GridBagConstraints gbc_textField_3 = new GridBagConstraints();
        gbc_textField_3.insets = new Insets(0, 0, 5, 5);
        gbc_textField_3.fill = 2;
        gbc_textField_3.gridx = 2;
        gbc_textField_3.gridy = 3;
        panel.add((Component)this.textField_3, gbc_textField_3);
        this.textField_3.setColumns(10);
        JButton btnConfigureSocksProxy = new JButton("Configure Network");
        GridBagConstraints gbc_btnConfigureSocksProxy = new GridBagConstraints();
        gbc_btnConfigureSocksProxy.insets = new Insets(0, 0, 5, 5);
        gbc_btnConfigureSocksProxy.gridx = 2;
        gbc_btnConfigureSocksProxy.gridy = 4;
        panel.add((Component)btnConfigureSocksProxy, gbc_btnConfigureSocksProxy);
        btnConfigureSocksProxy.setActionCommand("SOCKSCONFIG");
        btnConfigureSocksProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getActionCommand().equals("SOCKSCONFIG")) {
                    SimpleGUI.this.ProxyDialog.setVisible(true);
                }
            }
        });
        JButton btnSaveChanges = new JButton("Save Changes");
        GridBagConstraints gbc_btnSaveChanges = new GridBagConstraints();
        gbc_btnSaveChanges.insets = new Insets(0, 0, 5, 5);
        gbc_btnSaveChanges.gridx = 2;
        gbc_btnSaveChanges.gridy = 6;
        panel.add((Component)btnSaveChanges, gbc_btnSaveChanges);
        btnSaveChanges.setActionCommand("SAVESTUFF");
        btnSaveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("SAVESTUFF")) {
                    String nick;
                    String intro;
                    String location = SimpleGUI.this.textField.getText();
                    if (location != null && !location.equals("")) {
                        SimpleGUI.this.Core.setMyLocation(location);
                    }
                    if ((intro = SimpleGUI.this.textField_2.getText()) != null && !intro.equals("")) {
                        SimpleGUI.this.Core.setMyIntroduction(intro);
                    }
                    if ((nick = SimpleGUI.this.textField_3.getText()) != null && !nick.equals("")) {
                        SimpleGUI.this.Core.setMyNickname(nick);
                    }
                }
            }
        });
        JButton btnExportPeerIdenity = new JButton("Export Peer Idenity File");
        GridBagConstraints gbc_btnExportPeerIdenity = new GridBagConstraints();
        gbc_btnExportPeerIdenity.insets = new Insets(0, 0, 5, 5);
        gbc_btnExportPeerIdenity.gridx = 2;
        gbc_btnExportPeerIdenity.gridy = 7;
        panel.add((Component)btnExportPeerIdenity, gbc_btnExportPeerIdenity);
        btnExportPeerIdenity.setActionCommand("EXPORT");
        btnExportPeerIdenity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("EXPORT")) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setCurrentDirectory(SimpleGUI.this.ChooserDir);
                    int returnVal = chooser.showSaveDialog(SimpleGUI.this.frame);
                    if (returnVal == 0) {
                        System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
                        File f = chooser.getSelectedFile();
                        Peer p = SimpleGUI.this.Core.getMyPeerData();
                        if (p != null) {
                            try {
                                FileOutputStream fos = new FileOutputStream(f);
                                FileUtils.writePeer(fos, p);
                                fos.close();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                JOptionPane.showMessageDialog(SimpleGUI.this.frame, "ERROR: Could not export your peer data. " + ex.getMessage());
                            }
                        }
                    }
                    SimpleGUI.this.ChooserDir = chooser.getCurrentDirectory();
                }
            }
        });
        JButton btnImportAndSign = new JButton("Import and Sign Peer Idenity File");
        GridBagConstraints gbc_btnImportAndSign = new GridBagConstraints();
        gbc_btnImportAndSign.insets = new Insets(0, 0, 5, 5);
        gbc_btnImportAndSign.gridx = 2;
        gbc_btnImportAndSign.gridy = 8;
        panel.add((Component)btnImportAndSign, gbc_btnImportAndSign);
        btnImportAndSign.setActionCommand("IMPORT");
        btnImportAndSign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("IMPORT")) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setCurrentDirectory(SimpleGUI.this.ChooserDir);
                    int returnVal = chooser.showOpenDialog(SimpleGUI.this.frame);
                    if (returnVal == 0) {
                        System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
                        File f = chooser.getSelectedFile();
                        try {
                            FileInputStream fis = new FileInputStream(f);
                            Peer p = FileUtils.readPeer(fis);
                            fis.close();
                            SimpleGUI.this.Core.signPeer(p);
                            JOptionPane.showMessageDialog(SimpleGUI.this.frame, "Peer has been signed and can now join the network.");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(SimpleGUI.this.frame, "ERROR: Could not sign the peer data. " + ex.getMessage());
                        }
                    }
                    SimpleGUI.this.ChooserDir = chooser.getCurrentDirectory();
                }
            }
        });
        JPanel panel_1 = new JPanel();
        tabbedPane.addTab("Peers", null, panel_1, null);
        panel_1.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        panel_1.add(scrollPane);
        this.PeerTable = new PeerTable();
        this.table = new JTable(this.PeerTable);
        this.table.setAutoCreateRowSorter(true);
        scrollPane.setViewportView(this.table);
        JPanel buttPan = new JPanel();
        panel_1.add((Component)buttPan, "North");
        JButton shwBadPeers = new JButton("Show Bad Peers");
        shwBadPeers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SimpleGUI.this.BadDialog.setVisible(true);
            }
        });
        buttPan.add(shwBadPeers);
        JButton btnUpdatePeers = new JButton("Update Peers");
        buttPan.add(btnUpdatePeers);
        btnUpdatePeers.setActionCommand("UPDATEPEERS");
        btnUpdatePeers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getActionCommand().equals("UPDATEPEERS")) {
                    List<Peer> pl = SimpleGUI.this.Core.getPeerList();
                    SimpleGUI.this.PeerTable.addAllPeers(pl);
                    SimpleGUI.this.Core.updatePeers();
                }
            }
        });
        JPanel panel_2 = new JPanel();
        tabbedPane.addTab("Connections", null, panel_2, null);
        panel_2.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane_1 = new JScrollPane();
        panel_2.add(scrollPane_1);
        this.ConTable = new ConnectionsTable();
        this.table_1 = new JTable(this.ConTable);
        this.table_1.setAutoCreateRowSorter(true);
        scrollPane_1.setViewportView(this.table_1);
        JPanel panel_6 = new JPanel();
        tabbedPane.addTab("Posts", null, panel_6, null);
        panel_6.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane_2 = new JSplitPane();
        splitPane_2.setOrientation(0);
        panel_6.add((Component)splitPane_2, "Center");
        this.SearchPopup = new JPopupMenu("Search/References");
        this.setupPopupMenu();
        this.ExpPostTable = new ExpandedPostTableModel(this.SearchDB);
        this.table_4 = new JTable(this.ExpPostTable);
        TableRowSorter<ExpandedPostTableModel> sorter = new TableRowSorter<ExpandedPostTableModel>(this.ExpPostTable);
        sorter.setComparator(5, new Comparator<String>(){

            private long str2long(String v) {
                Pattern p = Pattern.compile("(\\d+)(\\w+)");
                Matcher m = p.matcher(v);
                long val = 0L;
                if (m.find()) {
                    val = Long.valueOf(m.group(1));
                    String mu = m.group(2);
                    if (mu.equals("KB")) {
                        val *= 1024L;
                    }
                    if (mu.equals("MB")) {
                        val *= 0x100000L;
                    }
                    if (mu.equals("GB")) {
                        val *= 0x40000000L;
                    }
                }
                return val;
            }

            @Override
            public int compare(String arg0, String arg1) {
                Long v0 = this.str2long(arg0);
                Long v1 = this.str2long(arg1);
                return v0.compareTo(v1);
            }
        });
        this.table_4.setRowSorter(sorter);
        this.table_4.setComponentPopupMenu(this.SearchPopup);
        JScrollPane expscroll = new JScrollPane(this.table_4);
        splitPane_2.setRightComponent(expscroll);
        this.table_4.setSelectionMode(2);
        this.table_4.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent c) {
                int row;
                if (!c.isPopupTrigger() && c.getClickCount() == 2 && (row = SimpleGUI.this.table_4.getSelectedRow()) >= 0) {
                    int r = SimpleGUI.this.table_4.convertRowIndexToModel(row);
                    PostDecoded pd = SimpleGUI.this.ExpPostTable.getPost(r);
                    SimpleGUI.this.openPost(pd);
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        JPanel panel_7 = new JPanel();
        splitPane_2.setLeftComponent(panel_7);
        final JPanel testp = new JPanel();
        this.SearchPanel = new SearchPanel(this);
        try {
            File searchtemplate = new File(String.valueOf(this.BaseDir) + File.separator + "search.template");
            if (!searchtemplate.exists()) {
                WriteDefaultSearchTemplate.writeDefaultFile(searchtemplate);
            }
            this.SearchPanel.PopulatePanel(testp, searchtemplate);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        List<Peer> bpl = this.Store.listBadPeers();
        for (Peer p : bpl) {
            this.SearchPanel.addExcludePeer(p);
        }
        this.BadDialog = new BadPeerDialog();
        this.BadDialog.setStore(this.Store);
        this.BadDialog.setSearchPanel(this.SearchPanel);
        this.BadDialog.update();
        this.PeerPopup = new JPopupMenu("Peer selection");
        JMenuItem exp = new JMenuItem("Exclude Selected Peers from Search");
        this.PeerPopup.add(exp);
        exp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                int[] rows = SimpleGUI.this.table.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.table.convertRowIndexToModel(rows[cnt]);
                    Peer p = SimpleGUI.this.PeerTable.getPeer(r);
                    if (p != null) {
                        SimpleGUI.this.SearchPanel.addExcludePeer(p);
                    }
                    ++cnt;
                }
            }
        });
        JMenuItem inc = new JMenuItem("Include Selected Peers for Search");
        this.PeerPopup.add(inc);
        inc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                int[] rows = SimpleGUI.this.table.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.table.convertRowIndexToModel(rows[cnt]);
                    Peer p = SimpleGUI.this.PeerTable.getPeer(r);
                    if (p != null) {
                        SimpleGUI.this.SearchPanel.addIncludePeer(p);
                    }
                    ++cnt;
                }
            }
        });
        JMenuItem del = new JMenuItem("Mark peer as Bad.");
        this.PeerPopup.add(del);
        del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] rows = SimpleGUI.this.table.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.table.convertRowIndexToModel(rows[cnt]);
                    Peer p = SimpleGUI.this.PeerTable.getPeer(r);
                    if (p != null) {
                        SimpleGUI.this.Core.setBadPeer(p);
                    }
                    ++cnt;
                }
                SimpleGUI.this.updatePeerTable();
                SimpleGUI.this.BadDialog.update();
            }
        });
        this.table.setComponentPopupMenu(this.PeerPopup);
        JPanel buttonpanel = new JPanel();
        panel_7.add(buttonpanel);
        JButton btnLoadSearchTemplate = new JButton("Load Search Template");
        buttonpanel.add(btnLoadSearchTemplate);
        btnLoadSearchTemplate.setActionCommand("LOADSEARCH");
        btnLoadSearchTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                if (a.getActionCommand().equals("LOADSEARCH")) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setCurrentDirectory(SimpleGUI.this.ChooserDir);
                    int returnVal = chooser.showOpenDialog(SimpleGUI.this.frame);
                    if (returnVal == 0) {
                        System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
                        File f = chooser.getSelectedFile();
                        try {
                            SimpleGUI.this.SearchPanel.PopulatePanel(testp, f);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(SimpleGUI.this.frame, "There was a problem with that template file.");
                            try {
                                SimpleGUI.this.SearchPanel.PopulatePanel(testp, new File(String.valueOf(SimpleGUI.this.BaseDir) + File.separator + "search.template"));
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                                System.exit(1);
                            }
                            e.printStackTrace();
                        }
                    }
                    SimpleGUI.this.ChooserDir = chooser.getCurrentDirectory();
                }
            }
        });
        JButton updatebut = new JButton("Update Posts");
        updatebut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                SimpleGUI.this.Core.updatePosts();
            }
        });
        buttonpanel.add(updatebut);
        panel_7.setLayout(new BoxLayout(panel_7, 3));
        File f = new File(String.valueOf(this.BaseDir) + File.separator + "newpost.template");
        if (!f.exists()) {
            try {
                WriteDefaultPostTemplate.writeDefaultFile(f);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.NewPostDialog = new NewExpandedPostDialog(this, f.getPath(), String.valueOf(this.BaseDir) + File.separator + "tmp");
        JButton newpost = new JButton("New Post");
        newpost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                SimpleGUI.this.NewPostDialog.setVisible(true);
            }
        });
        buttonpanel.add(newpost);
        JScrollPane testscroll = new JScrollPane(testp);
        panel_7.add(testscroll);
        JButton btnSearch = new JButton("Search");
        panel_7.add(btnSearch);
        panel_7.getRootPane().setDefaultButton(btnSearch);
        btnSearch.requestFocus();
        btnSearch.setActionCommand("SEARCH");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getActionCommand().equals("SEARCH")) {
                    SimpleGUI.this.ExpPostTable.setQueryResults(SimpleGUI.this.SearchPanel.doSearch(SimpleGUI.this.SearchDB));
                }
            }
        });
        splitPane_2.setDividerLocation(200);
        JPanel panel_3 = new JPanel();
        tabbedPane.addTab("Downloads", null, panel_3, null);
        panel_3.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane_2 = new JScrollPane();
        panel_3.add(scrollPane_2);
        this.DownloadMenu = new JPopupMenu("Downloads");
        this.DownloadModel = new DownloadsTableModel();
        this.FHandler.setFileReturnInterface(this.DownloadModel);
        this.DownloadsTable = new JTable(this.DownloadModel);
        this.DownloadsTable.setComponentPopupMenu(this.DownloadMenu);
        scrollPane_2.setViewportView(this.DownloadsTable);
        TableColumn col = this.DownloadsTable.getColumnModel().getColumn(2);
        col.setCellRenderer(new DownloadsTableModel.ProgressCellRenderer(this.DownloadModel));
        this.setupDownloadsPopup();
        this.updateMyInfoDisplay();
        this.updatePeerTable();
        this.updatePostTable();
        this.FHandler.Process();
        this.FHandler.updateAllStatus();
    }

    private void setupDownloadsPopup() {
        JMenuItem setpriority = new JMenuItem("Change Priority");
        this.DownloadMenu.add(setpriority);
        setpriority.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] rows = SimpleGUI.this.DownloadsTable.getSelectedRows();
                if (rows.length > 0) {
                    Object[] vals = new Object[]{0, 1, 2, 3, 4, 5};
                    Integer v = (Integer)JOptionPane.showInputDialog(SimpleGUI.this.frame, "Set the download priority\nHigher values are downloaded first.", "Download Priority", 3, null, vals, 0);
                    if (v != null) {
                        int cnt = 0;
                        while (cnt < rows.length) {
                            int r = SimpleGUI.this.DownloadsTable.convertRowIndexToModel(rows[cnt]);
                            DownloadsTableModel.DLRow dl = SimpleGUI.this.DownloadModel.getRow(r);
                            if (dl != null) {
                                SimpleGUI.this.FHandler.setPriority(dl.SaveAs, v);
                            }
                            ++cnt;
                        }
                    }
                }
            }
        });
        JMenuItem pause = new JMenuItem("Pause Download.");
        this.DownloadMenu.add(pause);
        pause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] rows = SimpleGUI.this.DownloadsTable.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.DownloadsTable.convertRowIndexToModel(rows[cnt]);
                    DownloadsTableModel.DLRow dl = SimpleGUI.this.DownloadModel.getRow(r);
                    if (dl != null) {
                        SimpleGUI.this.FHandler.pauseFile(dl.SaveAs);
                    }
                    ++cnt;
                }
            }
        });
        JMenuItem resume = new JMenuItem("Resume Download.");
        this.DownloadMenu.add(resume);
        resume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] rows = SimpleGUI.this.DownloadsTable.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.DownloadsTable.convertRowIndexToModel(rows[cnt]);
                    DownloadsTableModel.DLRow dl = SimpleGUI.this.DownloadModel.getRow(r);
                    if (dl != null) {
                        SimpleGUI.this.FHandler.resumeFile(dl.SaveAs);
                    }
                    ++cnt;
                }
            }
        });
        JMenuItem remove = new JMenuItem("Remove from the list.");
        this.DownloadMenu.add(remove);
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = SimpleGUI.this.DownloadsTable.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.DownloadsTable.convertRowIndexToModel(rows[cnt]);
                    DownloadsTableModel.DLRow dl = SimpleGUI.this.DownloadModel.getRow(r);
                    if (dl != null) {
                        SimpleGUI.this.FHandler.removeFile(dl.SaveAs);
                    }
                    ++cnt;
                }
                SimpleGUI.this.refreshDownloads();
            }
        });
    }

    private void openPost(PostDecoded pd) {
        String nick = "";
        Peer p = this.Store.getPeer(pd.getPost().getPost().getSignedDigest().getPeerIdentifier());
        if (p != null) {
            nick = p.getNickSig();
        }
        this.PostDialog.setPost(pd, nick);
        this.PostDialog.setVisible(true);
    }

    public void refreshDownloads() {
        this.DownloadModel.clearAll();
        this.FHandler.updateAllStatus();
    }

    private void setupPopupMenu() {
        JMenuItem openPost = new JMenuItem("Open post.");
        openPost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = SimpleGUI.this.table_4.getSelectedRow();
                if (row >= 0) {
                    int r = SimpleGUI.this.table_4.convertRowIndexToModel(row);
                    PostDecoded pd = SimpleGUI.this.ExpPostTable.getPost(r);
                    SimpleGUI.this.openPost(pd);
                }
            }
        });
        this.SearchPopup.add(openPost);
        JMenuItem download = new JMenuItem("Download selected.");
        download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                int[] i = SimpleGUI.this.table_4.getSelectedRows();
                int cnt = 0;
                while (cnt < i.length) {
                    int r = SimpleGUI.this.table_4.convertRowIndexToModel(i[cnt]);
                    PostDecoded pd = SimpleGUI.this.ExpPostTable.getPost(r);
                    SimpleGUI.this.requestDownload(pd);
                    ++cnt;
                }
            }
        });
        this.SearchPopup.add(download);
        this.SearchPopup.addSeparator();
        JMenuItem searchforreference = new JMenuItem("Search for posts referencing selected.");
        searchforreference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                int[] rows = SimpleGUI.this.table_4.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.table_4.convertRowIndexToModel(rows[cnt]);
                    PostDecoded pd = SimpleGUI.this.ExpPostTable.getPost(r);
                    SimpleGUI.this.SearchPanel.addDirectReference(pd);
                    ++cnt;
                }
            }
        });
        this.SearchPopup.add(searchforreference);
        JMenuItem postreference = new JMenuItem("Reference selected for new post.");
        postreference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                int[] rows = SimpleGUI.this.table_4.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.table_4.convertRowIndexToModel(rows[cnt]);
                    PostDecoded pd = SimpleGUI.this.ExpPostTable.getPost(r);
                    SimpleGUI.this.NewPostDialog.addReference(pd);
                    SimpleGUI.this.NewPostDialog.setVisible(true);
                    ++cnt;
                }
            }
        });
        this.SearchPopup.add(postreference);
        this.SearchPopup.addSeparator();
    }

    public void requestDownload(PostDecoded pd) {
        Set<String> filelst;
        if (pd != null && (filelst = pd.getStringKeySet(FileHandler.FILENAME)) != null && filelst.size() > 0) {
            String filename = filelst.iterator().next();
            File sf = new File(String.valueOf(this.DownloadDir.getPath()) + File.separator + filename);
            this.FHandler.requestFile(sf, pd, false, 0);
        }
    }

    public void resetPopupMenu() {
        this.SearchPopup.removeAll();
        this.setupPopupMenu();
    }

    public void addReference(final String ref) {
        JMenuItem mi = new JMenuItem("Search for " + ref + " of selected");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = SimpleGUI.this.table_4.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.table_4.convertRowIndexToModel(rows[cnt]);
                    PostDecoded pd = SimpleGUI.this.ExpPostTable.getPost(r);
                    SimpleGUI.this.SearchPanel.addHasReference(ref, pd);
                    ++cnt;
                }
            }
        });
        this.SearchPopup.add(mi);
        JMenuItem pi = new JMenuItem("Another is a " + ref + " of this");
        pi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = SimpleGUI.this.table_4.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = SimpleGUI.this.table_4.convertRowIndexToModel(rows[cnt]);
                    PostDecoded pd = SimpleGUI.this.ExpPostTable.getPost(r);
                    SimpleGUI.this.NewPostDialog.addReference(ref, pd);
                    SimpleGUI.this.NewPostDialog.setVisible(true);
                    ++cnt;
                }
            }
        });
        this.SearchPopup.add(pi);
    }

    public void setLocation(String str) {
        this.Core.setMyLocation(str);
        this.updateMyInfoDisplay();
    }

    private void updateMyInfoDisplay() {
        Peer p = this.Core.getMyPeerData();
        if (p != null) {
            String str = (String)p.getLocation();
            if (str != null) {
                this.textField.setText(str);
            } else {
                this.textField.setText("localhost:" + this.Port);
            }
            if (p.getIntroduction() != null) {
                this.textField_2.setText(p.getIntroduction());
            }
            if (p.getNickname() != null) {
                this.textField_3.setText(p.getNickname());
            }
        } else {
            this.textField.setText("localhost:" + this.Port);
        }
    }

    private void updatePostTable() {
    }

    private void updatePeerTable() {
        this.PeerTable.addAllPeers(this.Core.getPeerList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SignatureRequest(final Peer p) {
        boolean okforwindow = false;
        if (p != null && p.getLocation() != null && p.getIntroduction() != null) {
            HashSet<Peer> hashSet = this.SignaturesRequested;
            synchronized (hashSet) {
                if (!this.SignaturesRequested.contains(p)) {
                    okforwindow = true;
                    this.SignaturesRequested.add(p);
                }
            }
        }
        if (okforwindow) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        SignRequestDialog s = new SignRequestDialog(SimpleGUI.this.Core, p);
                        s.setVisible(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public void newPostReceived(LocalPost postlist) {
    }

    @Override
    public void newPeerReceived(final Peer peerlist) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleGUI.this.PeerTable.addPeer(peerlist);
            }
        });
    }

    @Override
    public void newFileDownloaded(LocalFileReference filelist) {
    }

    @Override
    public void connectionFailure(final Peer p) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleGUI.this.ConTable.removeConnection(p);
            }
        });
    }

    @Override
    public void downloadFailed(Object dig) {
    }

    @Override
    public void downloadStatusUpdate(File saveas, long totalsize, long amountcomplete, int pending, boolean paused, boolean inprogress, int priority) {
    }

    public JTable getDownloadsTable() {
        return this.DownloadsTable;
    }

    @Override
    public void connectionEvent(final ConnectionUpdateInterface con) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleGUI.this.ConTable.connectionUpdate(con);
            }
        });
    }
}

