/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.filehander.FileHandler;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.simpleui.SimpleGUI;
import org.ourfilesystem.ui.db.DBInterface;
import org.ourfilesystem.ui.db.QueryResultsInterface;
import org.ourfilesystem.utilities.BBytes;

public class SearchPanel {
    private HashMap<String, JTextField> OrStrings;
    private HashMap<String, JTextField> AndStrings;
    private HashMap<String, JTextField> ExcludeStrings;
    private HashMap<String, HashMap<String, JCheckBox>> OrStringsOpt;
    private HashMap<String, HashMap<String, JCheckBox>> AndStringsOpt;
    private HashMap<String, HashMap<String, JCheckBox>> ExcludeStringsOpt;
    private HashMap<String, JTextField> OrNumbers;
    private HashMap<String, JTextField> AndNumbers;
    private HashMap<String, JTextField> LessThan;
    private HashMap<String, JTextField> GreaterThan;
    private HashMap<String, JTextField> AverageLessThan;
    private HashMap<String, JTextField> AverageGreaterThan;
    private HashMap<String, JCheckBox> ExcludeReferences;
    private HashMap<String, ReferencesTableModel> HasReferences;
    private ReferencesTableModel DirectReferences;
    private PeerTableModel IncludePeers;
    private PeerTableModel ExcludePeers;
    private JDateChooser FromDate;
    private JDateChooser ToDate;
    private JCheckBox UseDates;
    private SimpleGUI GUI;

    public SearchPanel(SimpleGUI gui) {
        this.GUI = gui;
        this.createObjects();
    }

    private void createObjects() {
        this.OrStrings = new HashMap();
        this.AndStrings = new HashMap();
        this.ExcludeStrings = new HashMap();
        this.OrStringsOpt = new HashMap();
        this.AndStringsOpt = new HashMap();
        this.ExcludeStringsOpt = new HashMap();
        this.OrNumbers = new HashMap();
        this.AndNumbers = new HashMap();
        this.LessThan = new HashMap();
        this.GreaterThan = new HashMap();
        this.AverageLessThan = new HashMap();
        this.AverageGreaterThan = new HashMap();
        this.ExcludeReferences = new HashMap();
        this.HasReferences = new HashMap();
        this.DirectReferences = new ReferencesTableModel();
        this.IncludePeers = new PeerTableModel();
        this.ExcludePeers = new PeerTableModel();
        this.FromDate = new JDateChooser();
        this.ToDate = new JDateChooser();
        this.UseDates = new JCheckBox("Limit to these dates.");
    }

    public synchronized void PopulatePanel(JPanel pan, File templatefile) throws IOException {
        pan.removeAll();
        pan.setVisible(false);
        this.createObjects();
        this.GUI.resetPopupMenu();
        pan.setLayout((LayoutManager)new MigLayout("", "[][grow]", ""));
        int rows = 0;
        BufferedReader br = new BufferedReader(new FileReader(templatefile));
        String cmd = br.readLine();
        while (cmd != null) {
            JButton but;
            JTable t;
            JLabel l;
            JCheckBox jcb;
            HashMap<String, JCheckBox> cb;
            JLabel l2;
            JComponent f;
            String[] parts = cmd.split("\\s+");
            if (parts[0].equals("ORS")) {
                if (parts.length == 2 && this.OrStrings.get(parts[1]) == null) {
                    f = new JTextField();
                    this.OrStrings.put(parts[1], (JTextField)f);
                    l2 = new JLabel(String.valueOf(parts[1]) + " has one of ");
                    pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                    pan.add((Component)f, "cell 1 " + rows + ",growx");
                    ++rows;
                }
            } else if (parts[0].equals("ANDS")) {
                if (parts.length == 2 && this.AndStrings.get(parts[1]) == null) {
                    f = new JTextField();
                    this.AndStrings.put(parts[1], (JTextField)f);
                    l2 = new JLabel(String.valueOf(parts[1]) + " has all of ");
                    pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                    pan.add((Component)f, "cell 1 " + rows + ",growx");
                    ++rows;
                }
            } else if (parts[0].equals("EXCLUDE") && parts.length == 2 && this.ExcludeStrings.get(parts[1]) == null) {
                f = new JTextField();
                this.ExcludeStrings.put(parts[1], (JTextField)f);
                l2 = new JLabel(String.valueOf(parts[1]) + " exclude values ");
                pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                pan.add((Component)f, "cell 1 " + rows + ",growx");
                ++rows;
            }
            if (parts[0].equals("ORSO")) {
                if (parts.length > 2 && this.OrStringsOpt.get(parts[1]) == null) {
                    cb = new HashMap<String, JCheckBox>();
                    this.OrStringsOpt.put(parts[1], cb);
                    l2 = new JLabel(String.valueOf(parts[1]) + " has one of ");
                    pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                    int cnt = 2;
                    while (cnt < parts.length) {
                        jcb = new JCheckBox(parts[cnt]);
                        cb.put(parts[cnt], jcb);
                        pan.add((Component)jcb, "cell 1 " + rows + ",growx");
                        ++cnt;
                    }
                    ++rows;
                }
            } else if (parts[0].equals("ANDSO")) {
                if (parts.length > 2 && this.AndStringsOpt.get(parts[1]) == null) {
                    cb = new HashMap();
                    this.AndStringsOpt.put(parts[1], cb);
                    l2 = new JLabel(String.valueOf(parts[1]) + " has all of ");
                    pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                    int cnt = 2;
                    while (cnt < parts.length) {
                        jcb = new JCheckBox(parts[cnt]);
                        cb.put(parts[cnt], jcb);
                        pan.add((Component)jcb, "cell 1 " + rows + ",growx");
                        ++cnt;
                    }
                    ++rows;
                }
            } else if (parts[0].equals("EXCLUDEO")) {
                if (parts.length > 2 && this.ExcludeStringsOpt.get(parts[1]) == null) {
                    cb = new HashMap();
                    this.ExcludeStringsOpt.put(parts[1], cb);
                    l2 = new JLabel(String.valueOf(parts[1]) + " exclude values ");
                    pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                    int cnt = 2;
                    while (cnt < parts.length) {
                        jcb = new JCheckBox(parts[cnt]);
                        cb.put(parts[cnt], jcb);
                        pan.add((Component)jcb, "cell 1 " + rows + ",growx");
                        ++cnt;
                    }
                    ++rows;
                }
            } else if (parts[0].equals("ORN")) {
                if (parts.length == 2 && this.OrNumbers.get(parts[1]) == null) {
                    f = new JTextField();
                    this.OrNumbers.put(parts[1], (JTextField)f);
                    l2 = new JLabel(String.valueOf(parts[1]) + " has one of ");
                    pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                    pan.add((Component)f, "cell 1 " + rows + ",growx");
                    ++rows;
                }
            } else if (parts[0].equals("ANDN")) {
                if (parts.length == 2 && this.AndNumbers.get(parts[1]) == null) {
                    f = new JTextField();
                    this.AndNumbers.put(parts[1], (JTextField)f);
                    l2 = new JLabel(String.valueOf(parts[1]) + " has all of ");
                    pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                    pan.add((Component)f, "cell 1 " + rows + ",growx");
                    ++rows;
                }
            } else if (parts[0].equals("LESS")) {
                if (parts.length == 2 && this.LessThan.get(parts[1]) == null) {
                    f = new JTextField();
                    this.LessThan.put(parts[1], (JTextField)f);
                    l2 = new JLabel(String.valueOf(parts[1]) + " is less than ");
                    pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                    pan.add((Component)f, "cell 1 " + rows + ",growx");
                    ++rows;
                }
            } else if (parts[0].equals("GREATER")) {
                if (parts.length == 2 && this.GreaterThan.get(parts[1]) == null) {
                    f = new JTextField();
                    this.GreaterThan.put(parts[1], (JTextField)f);
                    l2 = new JLabel(String.valueOf(parts[1]) + " is greater than ");
                    pan.add((Component)l2, "cell 0 " + rows + ",alignx left");
                    pan.add((Component)f, "cell 1 " + rows + ",growx");
                    ++rows;
                }
            } else if (parts[0].equals("EXCLUDEREF")) {
                if (parts.length == 2 && this.ExcludeReferences.get(parts[1]) == null) {
                    f = new JCheckBox("Exclude references marked as " + parts[1]);
                    this.ExcludeReferences.put(parts[1], (JCheckBox)f);
                    pan.add((Component)f, "cell 1 " + rows + ",growx");
                    ++rows;
                }
            } else if (parts[0].equals("HASREF")) {
                if (parts.length == 2 && this.HasReferences.get(parts[1]) == null) {
                    l = new JLabel("is a " + parts[1] + " of ");
                    ReferencesTableModel m = new ReferencesTableModel();
                    this.HasReferences.put(parts[1], m);
                    this.GUI.addReference(parts[1]);
                    JTable t2 = new JTable(m);
                    JScrollPane p = new JScrollPane(t2);
                    p.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
                    pan.add((Component)l, "cell 0 " + rows + ",alignx left");
                    pan.add((Component)p, "cell 1 " + rows + ",growx,growy");
                    JButton but2 = new JButton("Clear");
                    pan.add((Component)but2, "cell 1 " + rows);
                    but2.setActionCommand(parts[1]);
                    but2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            SearchPanel.this.clearHasReferences(arg0.getActionCommand());
                        }
                    });
                    ++rows;
                }
            } else if (parts[0].equals("REF")) {
                l = new JLabel("References to ");
                pan.add((Component)l, "cell 0 " + rows + ",alignx left");
                t = new JTable(this.DirectReferences);
                JScrollPane p = new JScrollPane(t);
                p.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
                pan.add((Component)p, "cell 1 " + rows + ",growx,growy");
                but = new JButton("Clear");
                pan.add((Component)but, "cell 1 " + rows);
                but.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SearchPanel.this.clearDirectReferences();
                    }
                });
                ++rows;
            } else if (parts[0].equals("INCPEERS")) {
                l = new JLabel("Only include posts from ");
                pan.add((Component)l, "cell 0 " + rows + ",alignx left");
                t = new JTable(this.IncludePeers);
                JScrollPane p = new JScrollPane(t);
                p.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
                pan.add((Component)p, "cell 1 " + rows + ",growx,growy");
                but = new JButton("Clear");
                pan.add((Component)but, "cell 1 " + rows);
                but.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SearchPanel.this.clearIncludePeers();
                    }
                });
                ++rows;
            } else if (parts[0].equals("EXPEERS")) {
                l = new JLabel("Exclude posts from ");
                pan.add((Component)l, "cell 0 " + rows + ",alignx left");
                t = new JTable(this.ExcludePeers);
                JScrollPane p = new JScrollPane(t);
                p.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
                pan.add((Component)p, "cell 1 " + rows + ",growx,growy");
                but = new JButton("Clear");
                pan.add((Component)but, "cell 1 " + rows);
                but.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SearchPanel.this.clearExcludePeers();
                    }
                });
                ++rows;
            } else if (parts[0].equals("DATES")) {
                l = new JLabel("From date ");
                pan.add((Component)l, "cell 0 " + rows + ",alignx left");
                pan.add((Component)this.FromDate, "cell 1 " + rows + ",growx");
                l = new JLabel("To date ");
                pan.add((Component)l, "cell 0 " + rows + ",alignx left");
                pan.add((Component)this.ToDate, "cell 1 " + rows + ",growx");
                pan.add((Component)this.UseDates, "cell 1 " + rows + ",growx");
                ++rows;
            }
            cmd = br.readLine();
        }
        br.close();
        pan.setVisible(true);
    }

    private HashSet<String> parseString(String str) {
        HashSet<String> quotes = new HashSet<String>();
        int idx0 = str.indexOf(34);
        while (idx0 != -1) {
            String frag = str.substring(0, idx0);
            int idx1 = (str = str.substring(idx0 + 1, str.length())).indexOf(34);
            if (idx1 != -1) {
                quotes.add(str.substring(0, idx1));
                str = str.substring(idx1 + 1, str.length());
            }
            str = String.valueOf(frag) + str;
            idx0 = str.indexOf(34);
        }
        HashSet<String> r = new HashSet<String>();
        r.addAll(quotes);
        String[] sr = str.split("\\s+");
        int cnt = 0;
        while (cnt < sr.length) {
            if (sr[cnt].matches("\\S+")) {
                r.add(sr[cnt]);
            }
            ++cnt;
        }
        return r;
    }

    private void clearHasReferences(String ab) {
        ReferencesTableModel m = this.HasReferences.get(ab);
        if (m != null) {
            m.clear();
        }
    }

    private void clearDirectReferences() {
        this.DirectReferences.clear();
    }

    private void clearIncludePeers() {
        this.IncludePeers.clear();
    }

    private void clearExcludePeers() {
        this.ExcludePeers.clear();
    }

    public synchronized void addHasReference(String key, PostDecoded p) {
        ReferencesTableModel m;
        if (this.HasReferences != null && p != null && (m = this.HasReferences.get(key)) != null) {
            m.addNew(p);
        }
    }

    public synchronized void addDirectReference(PostDecoded p) {
        if (this.DirectReferences != null && p != null) {
            this.DirectReferences.addNew(p);
        }
    }

    public synchronized void addIncludePeer(Peer p) {
        if (this.IncludePeers != null) {
            this.IncludePeers.addNew(p);
        }
    }

    public synchronized void addExcludePeer(Peer p) {
        if (this.ExcludePeers != null) {
            this.ExcludePeers.addNew(p);
        }
    }

    public synchronized QueryResultsInterface doSearch(DBInterface db) {
        HashSet<String> s;
        HashSet<String> vals;
        HashMap<String, HashSet<String>> orstring = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> andstring = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> excludestring = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<Long>> ornum = new HashMap<String, HashSet<Long>>();
        HashMap<String, Long> andnums = new HashMap<String, Long>();
        HashMap<String, Long> lessthan = new HashMap<String, Long>();
        HashMap<String, Long> greaterthan = new HashMap<String, Long>();
        HashMap<String, Long> averageless = new HashMap<String, Long>();
        HashMap<String, Long> averagegreater = new HashMap<String, Long>();
        HashSet<String> excludebackrefs = new HashSet<String>();
        HashMap<String, HashSet<Object>> hasrefs = new HashMap<String, HashSet<Object>>();
        HashSet<Object> directrefs = new HashSet<Object>();
        HashSet<BBytes> includepeers = new HashSet<BBytes>();
        HashSet<BBytes> excludepeers = new HashSet<BBytes>();
        Date fromdate = null;
        Date todate = null;
        for (Map.Entry<String, HashMap<String, JCheckBox>> e : this.AndStringsOpt.entrySet()) {
            vals = (HashSet<String>)andstring.get(e.getKey());
            if (vals == null) {
                vals = new HashSet<String>();
                andstring.put(e.getKey(), vals);
            }
            for (Map.Entry<String, JCheckBox> e9 : e.getValue().entrySet()) {
                if (!e9.getValue().isSelected()) continue;
                vals.add(e9.getKey());
            }
        }
        for (Map.Entry<String, HashMap<String, JCheckBox>> e : this.OrStringsOpt.entrySet()) {
            vals = (HashSet<String>)orstring.get(e.getKey());
            if (vals == null) {
                vals = new HashSet<String>();
                orstring.put(e.getKey(), vals);
            }
            for (Map.Entry<String, JCheckBox> e9 : e.getValue().entrySet()) {
                if (!e9.getValue().isSelected()) continue;
                vals.add(e9.getKey());
            }
        }
        for (Map.Entry<String, HashMap<String, JCheckBox>> e : this.ExcludeStringsOpt.entrySet()) {
            vals = (HashSet<String>)excludestring.get(e.getKey());
            if (vals == null) {
                vals = new HashSet<String>();
                excludestring.put(e.getKey(), vals);
            }
            for (Map.Entry<String, JCheckBox> e9 : e.getValue().entrySet()) {
                if (!e9.getValue().isSelected()) continue;
                vals.add(e9.getKey());
            }
        }
        for (Map.Entry<String, JTextField> e : this.OrStrings.entrySet()) {
            orstring.put(e.getKey(), this.parseString(e.getValue().getText()));
        }
        for (Map.Entry<String, JTextField> e : this.AndStrings.entrySet()) {
            andstring.put(e.getKey(), this.parseString(e.getValue().getText()));
        }
        for (Map.Entry<String, JTextField> e : this.ExcludeStrings.entrySet()) {
            s = this.parseString(e.getValue().getText());
            excludestring.put(e.getKey(), s);
        }
        for (Map.Entry<String, JTextField> e : this.OrNumbers.entrySet()) {
            s = this.parseString(e.getValue().getText());
            HashSet<Long> ns = new HashSet<Long>();
            Iterator<String> i2 = s.iterator();
            while (i2.hasNext()) {
                try {
                    ns.add(Long.valueOf(i2.next()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ornum.put(e.getKey(), ns);
        }
        for (Map.Entry<String, JTextField> e : this.AndNumbers.entrySet()) {
            try {
                long t = Long.valueOf(e.getValue().getText());
                andnums.put(e.getKey(), t);
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        for (Map.Entry<String, JTextField> e : this.LessThan.entrySet()) {
            try {
                long t = Long.valueOf(e.getValue().getText());
                lessthan.put(e.getKey(), t);
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        for (Map.Entry<String, JTextField> e : this.GreaterThan.entrySet()) {
            try {
                long t = Long.valueOf(e.getValue().getText());
                greaterthan.put(e.getKey(), t);
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        for (Map.Entry<String, JTextField> e : this.AverageLessThan.entrySet()) {
            try {
                long t = Long.valueOf(e.getValue().getText());
                averageless.put(e.getKey(), t);
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        for (Map.Entry<String, JTextField> e : this.AverageGreaterThan.entrySet()) {
            try {
                long t = Long.valueOf(e.getValue().getText());
                averagegreater.put(e.getKey(), t);
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        for (Map.Entry<String, JCheckBox> e : this.ExcludeReferences.entrySet()) {
            if (!e.getValue().isSelected()) continue;
            excludebackrefs.add(e.getKey());
        }
        for (Map.Entry<String, ReferencesTableModel> e : this.HasReferences.entrySet()) {
            HashSet<Object> h = new HashSet<Object>();
            for (PostDecoded p : e.getValue().List) {
                if (p.getPost() == null || p.getPost().getPost() == null || p.getPost().getPost().getFileReferenceDigest() == null) continue;
                h.add(p.getPost().getPost().getFileReferenceDigest());
            }
            hasrefs.put(e.getKey(), h);
        }
        for (PostDecoded p : this.DirectReferences.List) {
            if (p.getPost() == null || p.getPost().getPost() == null || p.getPost().getPost().getFileReferenceDigest() == null) continue;
            directrefs.add(p.getPost().getPost().getFileReferenceDigest());
        }
        for (Peer p : this.IncludePeers.List) {
            includepeers.add((BBytes)p.getPeerKeysAndIdentity().getSignature().getDigest());
        }
        for (Peer p : this.ExcludePeers.List) {
            excludepeers.add((BBytes)p.getPeerKeysAndIdentity().getSignature().getDigest());
        }
        if (this.UseDates.isSelected()) {
            fromdate = this.FromDate.getDate();
            todate = this.ToDate.getDate();
        }
        return db.search(orstring, andstring, excludestring, ornum, andnums, lessthan, greaterthan, averageless, averagegreater, excludebackrefs, hasrefs, directrefs, includepeers, excludepeers, fromdate, todate);
    }

    private class PeerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public LinkedList<Peer> List = new LinkedList();

        public void addNew(Peer pd) {
            if (!this.List.contains(pd)) {
                this.List.add(pd);
            }
            this.fireTableDataChanged();
        }

        public void clear() {
            this.List.clear();
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Nickname";
            }
            if (col == 1) {
                return "Digest";
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.List.size();
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            Peer pd = this.List.get(arg0);
            if (arg1 == 0 && pd != null) {
                return pd.getNickSig();
            }
            if (arg1 == 1 && pd != null) {
                return pd.getPeerKeysAndIdentity().getSignature().getDigest();
            }
            return null;
        }
    }

    private class ReferencesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public LinkedList<PostDecoded> List = new LinkedList();

        public void addNew(PostDecoded pd) {
            this.List.add(pd);
            this.fireTableDataChanged();
        }

        public void clear() {
            this.List.clear();
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "File Name";
            }
            if (col == 1) {
                return "Digest";
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.List.size();
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            PostDecoded pd = this.List.get(arg0);
            if (arg1 == 0 && pd != null) {
                Set<String> nl = pd.getStringValues().get(FileHandler.FILENAME);
                if (nl != null && nl.size() > 0) {
                    return nl.iterator().next();
                }
                return "<none>";
            }
            if (arg1 == 1 && pd != null && pd.getPost() != null && pd.getPost().getPost() != null) {
                return pd.getPost().getPost().getFileReferenceDigest();
            }
            return null;
        }
    }
}

