/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSI2PConnector;
import org.ourfilesystem.com.OFSI2PServerSocket;
import org.ourfilesystem.com.OFSServerSocket;
import org.ourfilesystem.com.SimpleConnector;
import org.ourfilesystem.com.SimpleServerSocket;
import org.ourfilesystem.simpleui.SimpleGUI;

public class NetworkConfigDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static String I2PKey = "USEI2P";
    private static String ProxyAddrKey = "PROXYADDR";
    private static String ProxyPortKey = "PROXYPORT";
    private static String ProxyUseKey = "PROXYUSE";
    private static String PeerPortKey = "PEERPORT";
    private JTextField textField;
    private JTextField textField_1;
    private JCheckBox useproxy;
    private boolean SimpleStarted;
    private boolean I2PStarted;
    private boolean UseI2P;
    private boolean UseProxy;
    private String ProxyAddr;
    private int ProxyPort;
    private int PeerPort;
    private SimpleServerSocket SimpleServer;
    private SimpleConnector SimpleConnector;
    private OFSI2PServerSocket I2PServer;
    private OFSI2PConnector I2PConnector;
    private String BaseDir;
    private SimpleGUI GUI;
    private File I2PConfigFile;
    private File ConfigFile;
    private JTextField peerPort;
    private JCheckBox UseI2PBox;
    private JTextField inboundNickname;
    private JTextField outboundNickname;
    private JTextField i2cpUsername;
    private JTextField i2cpHost;
    private JTextField i2cpPort;
    private JSpinner inboundQuantity;
    private JSpinner outboundQuantity;
    private JSpinner inboundLength;
    private JSpinner outboundLength;
    private JSpinner inboundVariance;
    private JSpinner outboundVariance;
    private JSpinner inboundBackup;
    private JSpinner outboundBackupQuantity;
    private JCheckBox inboundAllowZeroHop;
    private JCheckBox outboundAllowZeroHop;
    private JSpinner inboundIPRestriction;
    private JSpinner outboundIPRestriction;
    private JCheckBox i2cpDontPublishLeaseSet;
    private JCheckBox i2cpSSL;
    private JTextField Password;

    private void LoadI2PConfig() {
        if (this.I2PConfigFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.I2PConfigFile);
                Properties p = new Properties();
                p.load(fis);
                fis.close();
                this.loadProperties(p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void saveI2PConfig() {
        try {
            FileOutputStream fos = new FileOutputStream(this.I2PConfigFile);
            Properties p = this.getProperties();
            p.store(fos, "do not manually edit please");
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean LoadConfig() {
        boolean loadedok = false;
        Properties p = new Properties();
        if (this.ConfigFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.ConfigFile);
                p.load(fis);
                fis.close();
                loadedok = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not read the proxy configuration file!");
            }
        }
        this.UseI2P = Boolean.valueOf(p.getProperty(I2PKey, "false"));
        this.UseProxy = Boolean.valueOf(p.getProperty(ProxyUseKey, "true"));
        this.ProxyAddr = p.getProperty(ProxyAddrKey, "127.0.0.1");
        this.ProxyPort = Integer.valueOf(p.getProperty(ProxyPortKey, "9050"));
        this.PeerPort = Integer.valueOf(p.getProperty(PeerPortKey, "9140"));
        return loadedok;
    }

    private void SaveConfig() {
        Properties p = new Properties();
        p.setProperty(I2PKey, Boolean.toString(this.UseI2P));
        p.setProperty(ProxyUseKey, Boolean.toString(this.UseProxy));
        p.setProperty(ProxyAddrKey, this.ProxyAddr);
        p.setProperty(ProxyPortKey, Integer.toString(this.ProxyPort));
        p.setProperty(PeerPortKey, Integer.toString(this.PeerPort));
        try {
            FileOutputStream fos = new FileOutputStream(this.ConfigFile);
            p.store(fos, "proxy configuration for ofs");
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public OFSServerSocket getServerSocket() {
        if (this.SimpleServer == null) {
            try {
                this.SimpleServer = new SimpleServerSocket(new ServerSocket(this.PeerPort));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.SimpleServer;
        }
        return this.SimpleServer;
    }

    public OFSConnector getConnector() {
        if (this.SimpleConnector == null) {
            this.SimpleConnector = new SimpleConnector(this.UseProxy, this.ProxyAddr, this.ProxyPort);
        }
        this.SimpleConnector.setProxyAddr(this.ProxyAddr);
        this.SimpleConnector.setUseProxy(this.UseProxy);
        this.SimpleConnector.setProxyPort(this.ProxyPort);
        return this.SimpleConnector;
    }

    public NetworkConfigDialog(SimpleGUI gui, String bd) {
        this.GUI = gui;
        this.SimpleStarted = false;
        this.I2PStarted = false;
        this.BaseDir = bd;
        File basedir = new File(this.BaseDir);
        if (!basedir.exists()) {
            basedir.mkdirs();
        }
        this.I2PConfigFile = new File(String.valueOf(this.BaseDir) + File.separator + "i2p.cfg");
        this.ConfigFile = new File(String.valueOf(this.BaseDir) + File.separator + "proxy.cfg");
        boolean justgo = this.LoadConfig();
        this.setTitle("Network Configuration");
        this.setBounds(100, 100, 492, 604);
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)tabbedPane, "North");
        JPanel panel = new JPanel();
        tabbedPane.addTab("Basic", null, panel, null);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow,fill]", "[][][][][][]"));
        this.UseI2PBox = new JCheckBox("Use I2P");
        panel.add((Component)this.UseI2PBox, "cell 1 0");
        this.UseI2PBox.setSelected(this.UseI2P);
        JLabel lblSocksProxyAddress = new JLabel("SOCKS Proxy address");
        panel.add((Component)lblSocksProxyAddress, "cell 0 2");
        this.textField = new JTextField();
        panel.add((Component)this.textField, "cell 1 2");
        this.textField.setColumns(10);
        this.textField.setText(this.getProxyAddr());
        JLabel lblSocksProxyPort = new JLabel("SOCKS Proxy Port");
        panel.add((Component)lblSocksProxyPort, "cell 0 3");
        this.textField_1 = new JTextField();
        panel.add((Component)this.textField_1, "cell 1 3");
        this.textField_1.setColumns(10);
        this.textField_1.setText(Integer.toString(this.getProxyPort()));
        this.useproxy = new JCheckBox("Enable SOCKS Proxy");
        panel.add((Component)this.useproxy, "cell 1 4");
        this.useproxy.setSelected(this.isUseProxy());
        JLabel lblPeerPort = new JLabel("Peer Port");
        panel.add((Component)lblPeerPort, "cell 0 5");
        this.peerPort = new JTextField();
        panel.add((Component)this.peerPort, "cell 1 5");
        this.peerPort.setColumns(10);
        this.peerPort.setText(Integer.toString(this.getPeerPort()));
        JPanel panel_1 = new JPanel();
        tabbedPane.addTab("I2P Advanced", null, panel_1, null);
        panel_1.setLayout((LayoutManager)new MigLayout("", "[][grow,fill]", "[][][][][][][][][][][][][][][][][][][][]"));
        JLabel lblInboundquantity = new JLabel("inbound.quantity");
        panel_1.add((Component)lblInboundquantity, "cell 0 0,alignx trailing");
        LinkedList<String> lst = new LinkedList<String>();
        lst.add("Default");
        lst.add("1");
        lst.add("2");
        lst.add("3");
        lst.add("4");
        lst.add("5");
        lst.add("6");
        lst.add("7");
        lst.add("8");
        lst.add("9");
        lst.add("10");
        lst.add("11");
        lst.add("12");
        lst.add("13");
        lst.add("14");
        lst.add("15");
        lst.add("16");
        SpinnerListModel mod = new SpinnerListModel(lst);
        this.inboundQuantity = new JSpinner(mod);
        panel_1.add((Component)this.inboundQuantity, "cell 1 0");
        JLabel lblOutboundquantity = new JLabel("outbound.quantity");
        panel_1.add((Component)lblOutboundquantity, "cell 0 1,alignx trailing");
        lst = new LinkedList();
        lst.add("Default");
        lst.add("1");
        lst.add("2");
        lst.add("3");
        lst.add("4");
        lst.add("5");
        lst.add("6");
        lst.add("7");
        lst.add("8");
        lst.add("9");
        lst.add("10");
        lst.add("11");
        lst.add("12");
        lst.add("13");
        lst.add("14");
        lst.add("15");
        lst.add("16");
        mod = new SpinnerListModel(lst);
        this.outboundQuantity = new JSpinner(mod);
        panel_1.add((Component)this.outboundQuantity, "cell 1 1");
        JLabel lblInboundlength = new JLabel("inbound.length");
        panel_1.add((Component)lblInboundlength, "cell 0 2,alignx trailing");
        lst = new LinkedList();
        lst.add("Default");
        lst.add("0");
        lst.add("1");
        lst.add("2");
        lst.add("3");
        lst.add("4");
        lst.add("5");
        lst.add("6");
        lst.add("7");
        mod = new SpinnerListModel(lst);
        this.inboundLength = new JSpinner(mod);
        panel_1.add((Component)this.inboundLength, "cell 1 2");
        JLabel lblOutboundlength = new JLabel("outbound.length");
        panel_1.add((Component)lblOutboundlength, "cell 0 3,alignx trailing");
        lst = new LinkedList();
        lst.add("Default");
        lst.add("0");
        lst.add("1");
        lst.add("2");
        lst.add("3");
        lst.add("4");
        lst.add("5");
        lst.add("6");
        lst.add("7");
        mod = new SpinnerListModel(lst);
        this.outboundLength = new JSpinner(mod);
        panel_1.add((Component)this.outboundLength, "cell 1 3");
        JLabel lblInboundvariance = new JLabel("inbound.lengthVariance");
        panel_1.add((Component)lblInboundvariance, "cell 0 4,alignx trailing");
        lst = new LinkedList();
        lst.add("Default");
        lst.add("7");
        lst.add("6");
        lst.add("5");
        lst.add("4");
        lst.add("3");
        lst.add("2");
        lst.add("1");
        lst.add("0");
        lst.add("-1");
        lst.add("-2");
        lst.add("-3");
        lst.add("-4");
        lst.add("-5");
        lst.add("-6");
        lst.add("-7");
        mod = new SpinnerListModel(lst);
        this.inboundVariance = new JSpinner(mod);
        panel_1.add((Component)this.inboundVariance, "cell 1 4");
        JLabel lblOutboundvariance = new JLabel("outbound.lengthVariance");
        panel_1.add((Component)lblOutboundvariance, "cell 0 5,alignx trailing");
        lst = new LinkedList();
        lst.add("Default");
        lst.add("7");
        lst.add("6");
        lst.add("5");
        lst.add("4");
        lst.add("3");
        lst.add("2");
        lst.add("1");
        lst.add("0");
        lst.add("-1");
        lst.add("-2");
        lst.add("-3");
        lst.add("-4");
        lst.add("-5");
        lst.add("-6");
        lst.add("-7");
        mod = new SpinnerListModel(lst);
        this.outboundVariance = new JSpinner(mod);
        panel_1.add((Component)this.outboundVariance, "cell 1 5");
        JLabel lblInboundbackup = new JLabel("inbound.backupQuantity");
        panel_1.add((Component)lblInboundbackup, "cell 0 6,alignx trailing");
        lst = new LinkedList();
        lst.add("Default");
        lst.add("0");
        lst.add("1");
        lst.add("2");
        lst.add("3");
        lst.add("4");
        lst.add("5");
        lst.add("6");
        lst.add("7");
        mod = new SpinnerListModel(lst);
        this.inboundBackup = new JSpinner(mod);
        panel_1.add((Component)this.inboundBackup, "cell 1 6");
        JLabel lblOutboundbackup = new JLabel("outbound.backupQuantity");
        panel_1.add((Component)lblOutboundbackup, "cell 0 7,alignx trailing");
        lst = new LinkedList();
        lst.add("Default");
        lst.add("0");
        lst.add("1");
        lst.add("2");
        lst.add("3");
        lst.add("4");
        lst.add("5");
        lst.add("6");
        lst.add("7");
        mod = new SpinnerListModel(lst);
        this.outboundBackupQuantity = new JSpinner(mod);
        panel_1.add((Component)this.outboundBackupQuantity, "cell 1 7");
        JLabel lblInboundnickname = new JLabel("inbound.nickname");
        panel_1.add((Component)lblInboundnickname, "cell 0 8,alignx trailing");
        this.inboundNickname = new JTextField();
        panel_1.add((Component)this.inboundNickname, "cell 1 8,growx");
        this.inboundNickname.setColumns(10);
        JLabel lblOutboundnickname = new JLabel("outbound.nickname");
        panel_1.add((Component)lblOutboundnickname, "cell 0 9,alignx trailing");
        this.outboundNickname = new JTextField();
        panel_1.add((Component)this.outboundNickname, "cell 1 9,growx");
        this.outboundNickname.setColumns(10);
        this.inboundAllowZeroHop = new JCheckBox("inbound.allowZeroHop");
        panel_1.add((Component)this.inboundAllowZeroHop, "cell 1 10,aligny baseline");
        this.outboundAllowZeroHop = new JCheckBox("outbound.allowZeroHop");
        panel_1.add((Component)this.outboundAllowZeroHop, "cell 1 11");
        JLabel lblInboundiprestriction = new JLabel("inbound.IPRestriction");
        panel_1.add((Component)lblInboundiprestriction, "cell 0 12,alignx trailing");
        lst = new LinkedList();
        lst.add("Default");
        lst.add("0");
        lst.add("1");
        lst.add("2");
        lst.add("3");
        lst.add("4");
        mod = new SpinnerListModel(lst);
        this.inboundIPRestriction = new JSpinner(mod);
        panel_1.add((Component)this.inboundIPRestriction, "cell 1 12");
        JLabel lblOutboundiprestriction = new JLabel("outbound.IPRestriction");
        panel_1.add((Component)lblOutboundiprestriction, "cell 0 13,alignx trailing");
        lst = new LinkedList();
        lst.add("Default");
        lst.add("0");
        lst.add("1");
        lst.add("2");
        lst.add("3");
        lst.add("4");
        mod = new SpinnerListModel(lst);
        this.outboundIPRestriction = new JSpinner(mod);
        panel_1.add((Component)this.outboundIPRestriction, "cell 1 13");
        this.i2cpDontPublishLeaseSet = new JCheckBox("i2cp.dontPublishLeaseSet");
        panel_1.add((Component)this.i2cpDontPublishLeaseSet, "cell 1 14,alignx center");
        JLabel lblIcpusername = new JLabel("i2cp.username");
        panel_1.add((Component)lblIcpusername, "cell 0 15,alignx trailing");
        this.i2cpUsername = new JTextField();
        panel_1.add((Component)this.i2cpUsername, "cell 1 15,growx");
        this.i2cpUsername.setColumns(10);
        JLabel lblIcppassword = new JLabel("i2cp.password");
        panel_1.add((Component)lblIcppassword, "cell 0 16,alignx trailing");
        this.Password = new JTextField();
        panel_1.add((Component)this.Password, "cell 1 16,growx");
        this.Password.setColumns(10);
        JLabel lblIcptcphost = new JLabel("i2cp.tcp.host");
        panel_1.add((Component)lblIcptcphost, "cell 0 17,alignx trailing");
        this.i2cpHost = new JTextField();
        panel_1.add((Component)this.i2cpHost, "cell 1 17,growx");
        this.i2cpHost.setColumns(10);
        JLabel lblIcptcpport = new JLabel("i2cp.tcp.port");
        panel_1.add((Component)lblIcptcpport, "cell 0 18,alignx trailing");
        this.i2cpPort = new JTextField();
        panel_1.add((Component)this.i2cpPort, "cell 1 18,growx");
        this.i2cpPort.setColumns(10);
        this.i2cpSSL = new JCheckBox("i2cp.SSL");
        panel_1.add((Component)this.i2cpSSL, "cell 1 19");
        this.UseI2PBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                NetworkConfigDialog.this.setEditable();
            }
        });
        this.LoadI2PConfig();
        this.setEditable();
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                NetworkConfigDialog.this.go();
            }
        });
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        if (justgo) {
            this.setVisible(false);
            this.go();
        } else {
            this.setVisible(true);
        }
    }

    private void setEditable() {
        this.useproxy.setEnabled(!this.UseI2PBox.isSelected());
        this.textField.setEditable(!this.UseI2PBox.isSelected());
        this.textField_1.setEditable(!this.UseI2PBox.isSelected());
        this.peerPort.setEditable(!this.UseI2PBox.isSelected());
    }

    private Properties getProperties() {
        Properties props = new Properties();
        Pattern p = Pattern.compile("\\S+");
        Matcher m = p.matcher("");
        if (!this.getInboundQuantity().getValue().equals("Default")) {
            props.setProperty("inbound.quantity", this.getInboundQuantity().getValue().toString());
        }
        if (!this.getOutboundQuantity().getValue().equals("Default")) {
            props.setProperty("outbound.quantity", this.getOutboundQuantity().getValue().toString());
        }
        if (!this.getInboundLength().getValue().equals("Default")) {
            props.setProperty("inbound.length", this.getInboundLength().getValue().toString());
        }
        if (!this.getOutboundLength().getValue().equals("Default")) {
            props.setProperty("outbound.length", this.getOutboundLength().getValue().toString());
        }
        if (!this.getInboundVariance().getValue().equals("Default")) {
            props.setProperty("inbound.lengthVariance", this.getInboundVariance().getValue().toString());
        }
        if (!this.getOutboundVariance().getValue().equals("Default")) {
            props.setProperty("outbound.lengthVariance", this.getOutboundVariance().getValue().toString());
        }
        if (!this.getInboundBackup().getValue().equals("Default")) {
            props.setProperty("inbound.backupQuantity", this.getInboundBackup().getValue().toString());
        }
        if (!this.getOutboundBackupQuantity().getValue().equals("Default")) {
            props.setProperty("outbound.backupQuantity", this.getOutboundBackupQuantity().getValue().toString());
        }
        String s = this.getInboundNickname().getText();
        m.reset(s);
        if (m.find()) {
            props.setProperty("inbound.nickname", s);
        }
        s = this.getOutboundNickname().getText();
        m.reset(s);
        if (m.find()) {
            props.setProperty("outbound.nickname", s);
        }
        if (this.getInboundAllowZeroHop().isSelected()) {
            props.setProperty("inbound.allowZeroHop", "true");
        } else {
            props.setProperty("inbound.allowZeroHop", "false");
        }
        if (this.getOutboundAllowZeroHop().isSelected()) {
            props.setProperty("outbound.allowZeroHop", "true");
        } else {
            props.setProperty("outbound.allowZeroHop", "false");
        }
        if (!this.getInboundIPRestriction().equals("Default")) {
            props.setProperty("inbound.IPRestriction", this.getInboundIPRestriction().getValue().toString());
        }
        if (!this.getOutboundIPRestriction().equals("Default")) {
            props.setProperty("outbound.IPRestriction", this.getOutboundIPRestriction().getValue().toString());
        }
        if (this.getI2cpDontPublishLeaseSet().isSelected()) {
            props.setProperty("i2cp.dontPublishLeaseSet", "true");
        } else {
            props.setProperty("i2cp.dontPublishLeaseSet", "false");
        }
        s = this.getI2cpUsername().getText();
        m.reset(s);
        if (m.find()) {
            props.setProperty("i2cp.username", s);
        }
        s = this.getPassword().getText();
        m.reset(s);
        if (m.find()) {
            props.setProperty("i2cp.password", s);
        }
        s = this.getI2cpHost().getText();
        m.reset(s);
        if (m.find()) {
            props.setProperty("i2cp.tcp.host", s);
        }
        s = this.getI2cpPort().getText();
        m.reset(s);
        if (m.find()) {
            props.setProperty("i2cp.tcp.port", s);
        }
        if (this.getI2cpSSL().isSelected()) {
            props.setProperty("i2cp.SSL", "true");
        } else {
            props.setProperty("i2cp.SSL", "false");
        }
        return props;
    }

    private void loadProperties(Properties props) {
        String s = props.getProperty("inbound.quantity");
        if (s != null) {
            this.getInboundQuantity().setValue(s);
        }
        if ((s = props.getProperty("outbound.quantity")) != null) {
            this.getOutboundQuantity().setValue(s);
        }
        if ((s = props.getProperty("inbound.length")) != null) {
            this.getInboundLength().setValue(s);
        }
        if ((s = props.getProperty("outbound.length")) != null) {
            this.getOutboundLength().setValue(s);
        }
        if ((s = props.getProperty("inbound.lengthVariance")) != null) {
            this.getInboundVariance().setValue(s);
        }
        if ((s = props.getProperty("outbound.lengthVariance")) != null) {
            this.getOutboundVariance().setValue(s);
        }
        if ((s = props.getProperty("inbound.backupQuantity")) != null) {
            this.getInboundBackup().setValue(s);
        }
        if ((s = props.getProperty("outbound.backupQuantity")) != null) {
            this.getOutboundBackupQuantity().setValue(s);
        }
        if ((s = props.getProperty("inbound.nickname")) != null) {
            this.getInboundNickname().setText(s);
        }
        if ((s = props.getProperty("outbound.nickname")) != null) {
            this.getOutboundNickname().setText(s);
        }
        if ((s = props.getProperty("inbound.allowZeroHop")) != null) {
            this.getInboundAllowZeroHop().setSelected(Boolean.valueOf(s));
        }
        if ((s = props.getProperty("outbound.allowZeroHop")) != null) {
            this.getOutboundAllowZeroHop().setSelected(Boolean.valueOf(s));
        }
        if ((s = props.getProperty("inbound.IPRestriction")) != null) {
            this.getInboundIPRestriction().setValue(s);
        }
        if ((s = props.getProperty("outbound.IPRestriction")) != null) {
            this.getOutboundIPRestriction().setValue(s);
        }
        if ((s = props.getProperty("i2cp.dontPublishLeaseSet")) != null) {
            this.getI2cpDontPublishLeaseSet().setSelected(Boolean.valueOf(s));
        }
        if ((s = props.getProperty("i2cp.username")) != null) {
            this.getI2cpUsername().setText(s);
        }
        if ((s = props.getProperty("i2cp.password")) != null) {
            this.getPassword().setText(s);
        }
        if ((s = props.getProperty("i2cp.tcp.host")) != null) {
            this.getI2cpHost().setText(s);
        }
        if ((s = props.getProperty("i2cp.tcp.port")) != null) {
            this.getI2cpPort().setText(s);
        }
        if ((s = props.getProperty("i2cp.SSL")) != null) {
            this.getI2cpSSL().setSelected(Boolean.valueOf(s));
        }
    }

    private void go() {
        if (this.UseI2PBox.isSelected()) {
            this.UseI2P = true;
            this.goI2P();
        } else {
            this.UseI2P = false;
            if (!this.useproxy.isSelected()) {
                this.UseProxy = false;
                this.goSimple();
            } else {
                String addr = this.textField.getText();
                if (!addr.matches("\\S+")) {
                    JOptionPane.showMessageDialog(this, "Improper proxy address.");
                } else {
                    String portstr = this.textField_1.getText();
                    if (!portstr.matches("\\d+")) {
                        JOptionPane.showMessageDialog(this, "Proxy port must be a number.");
                    } else {
                        try {
                            this.ProxyPort = Integer.valueOf(portstr);
                            this.ProxyAddr = addr;
                            this.UseProxy = true;
                            this.goSimple();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(this, "The proxy port seems to be invalid.");
                        }
                    }
                }
            }
        }
    }

    public void goI2P() {
        this.SaveConfig();
        this.saveI2PConfig();
        if (!this.SimpleStarted) {
            if (this.I2PServer == null) {
                try {
                    this.I2PServer = new OFSI2PServerSocket(String.valueOf(this.BaseDir) + File.separator + "i2pkey.dat", this.getProperties());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "I2P Error.  Make sure it's running.  Check your i2p options.");
                }
                try {
                    this.I2PConnector = (OFSI2PConnector)this.I2PServer.getOFSConnector();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.GUI.InitPeer(this.I2PServer, this.I2PConnector, false);
                if (this.I2PServer != null) {
                    this.GUI.setLocation(this.I2PServer.getMyLocation());
                }
                this.I2PStarted = true;
            } else {
                JOptionPane.showMessageDialog(this, "You will have to restart for your changes to take effect.");
            }
        } else {
            JOptionPane.showMessageDialog(this, "You will have to restart for your changes to take effect.");
        }
        this.setVisible(false);
    }

    public void goSimple() {
        this.SaveConfig();
        this.saveI2PConfig();
        if (!this.I2PStarted) {
            try {
                this.PeerPort = Integer.valueOf(this.peerPort.getText());
                if (this.SimpleServer == null) {
                    this.SimpleServer = new SimpleServerSocket(new ServerSocket(this.PeerPort));
                    this.SimpleConnector = new SimpleConnector(this.UseProxy, this.ProxyAddr, this.ProxyPort);
                    this.GUI.InitPeer(this.SimpleServer, this.SimpleConnector, true);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "The peer port seems to be invalid.");
                return;
            }
            this.SimpleConnector.setProxyAddr(this.ProxyAddr);
            this.SimpleConnector.setProxyPort(this.ProxyPort);
            this.SimpleConnector.setUseProxy(this.UseProxy);
            if (this.SimpleStarted) {
                JOptionPane.showMessageDialog(this, "If you have changed your peer port you will need to restart.");
            }
            this.SimpleStarted = true;
        } else {
            JOptionPane.showMessageDialog(this, "You will have to restart for your changes to take effect.");
        }
        this.setVisible(false);
    }

    public boolean isUseProxy() {
        return this.UseProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.UseProxy = useProxy;
    }

    public String getProxyAddr() {
        return this.ProxyAddr;
    }

    public void setProxyAddr(String proxyAddr) {
        this.ProxyAddr = proxyAddr;
    }

    public int getProxyPort() {
        return this.ProxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.ProxyPort = proxyPort;
    }

    public int getPeerPort() {
        return this.PeerPort;
    }

    public JCheckBox getUseI2PBox() {
        return this.UseI2PBox;
    }

    public JSpinner getInboundQuantity() {
        return this.inboundQuantity;
    }

    public JSpinner getOutboundQuantity() {
        return this.outboundQuantity;
    }

    public JSpinner getInboundLength() {
        return this.inboundLength;
    }

    public JSpinner getOutboundLength() {
        return this.outboundLength;
    }

    public JSpinner getInboundVariance() {
        return this.inboundVariance;
    }

    public JSpinner getOutboundVariance() {
        return this.outboundVariance;
    }

    public JSpinner getInboundBackup() {
        return this.inboundBackup;
    }

    public JSpinner getOutboundBackupQuantity() {
        return this.outboundBackupQuantity;
    }

    public JTextField getInboundNickname() {
        return this.inboundNickname;
    }

    public JTextField getOutboundNickname() {
        return this.outboundNickname;
    }

    public JCheckBox getInboundAllowZeroHop() {
        return this.inboundAllowZeroHop;
    }

    public JCheckBox getOutboundAllowZeroHop() {
        return this.outboundAllowZeroHop;
    }

    public JSpinner getInboundIPRestriction() {
        return this.inboundIPRestriction;
    }

    public JSpinner getOutboundIPRestriction() {
        return this.outboundIPRestriction;
    }

    public JCheckBox getI2cpDontPublishLeaseSet() {
        return this.i2cpDontPublishLeaseSet;
    }

    public JTextField getI2cpUsername() {
        return this.i2cpUsername;
    }

    public JTextField getI2cpHost() {
        return this.i2cpHost;
    }

    public JTextField getI2cpPort() {
        return this.i2cpPort;
    }

    public JCheckBox getI2cpSSL() {
        return this.i2cpSSL;
    }

    public JTextField getPassword() {
        return this.Password;
    }
}

