/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.LocalFileReference;

public class FileTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private HashSet<LocalFileReference> Files;
    private String[] columns = new String[]{"Reference", "Date", "Local Copy"};

    public FileTableModel() {
        this.Files = new HashSet();
    }

    public void addAllFiles(List<LocalFileReference> l) {
        this.Files.addAll(l);
        this.fireTableDataChanged();
    }

    public void addNewFile(LocalFileReference l) {
        this.Files.add(l);
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        if (col == 1) {
            return Date.class;
        }
        if (col == 2) {
            return String.class;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.Files.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        LocalFileReference r = null;
        Iterator<LocalFileReference> i = this.Files.iterator();
        int cnt = 0;
        while (i.hasNext() && cnt <= row) {
            r = i.next();
            ++cnt;
        }
        if (r != null) {
            if (col == 0) {
                return r.getFileReference().getUnsignedDigest().toString().substring(0, 10);
            }
            if (col == 1) {
                return r.getLocalDate();
            }
            if (col == 2) {
                return r.getFileReference().getFile();
            }
        }
        return r;
    }
}

