/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.filehander.FileHandler;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.simpleui.NewExpandedPostDialog;
import org.ourfilesystem.simpleui.SimpleGUI;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.HumReadFileSize;

public class ExpandedPostDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField Subject;
    private JTextField FileReference;
    private JTextPane Comment;
    private JTextPane Strings;
    private JTextPane Numbers;
    private JTextPane References;
    private PostDecoded Post;
    private SimpleGUI GUI;
    private JTextField DateField;
    private JTextField FileSize;
    private JTextField FromPeer;

    public void setPost(PostDecoded p, String nickname) {
        this.Post = p;
        if (this.Post != null) {
            this.FromPeer.setText(nickname);
            this.DateField.setText(this.Post.getPost().getLocalDate().toString());
            Long v = this.Post.getNumberValues().get(FileHandler.FILESIZE);
            if (v != null) {
                this.FileSize.setText(HumReadFileSize.fileSize(v));
            } else {
                this.FileSize.setText("");
            }
            Set<String> subject = this.Post.getStringKeySet("SUBJECT");
            if (subject != null && subject.size() > 0) {
                this.Subject.setText(subject.iterator().next());
            } else {
                this.Subject.setText("");
            }
            Set<String> filename = this.Post.getStringKeySet(FileHandler.FILENAME);
            if (filename != null && filename.size() > 0) {
                this.FileReference.setText(filename.iterator().next());
            } else {
                this.FileReference.setText("");
            }
            boolean comshown = false;
            Set<String> comlist = this.Post.getStringKeySet(NewExpandedPostDialog.COMMENT);
            if (comlist != null && comlist.size() > 0) {
                this.Comment.setText(comlist.iterator().next());
                comshown = true;
            }
            if (!comshown) {
                this.Comment.setText(this.Post.getComment());
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Set<String>> e : this.Post.getStringValues().entrySet()) {
                if (e.getKey().equals("SUBJECT") || e.getKey().equals(FileHandler.FILENAME) || e.getKey().equals(NewExpandedPostDialog.COMMENT)) continue;
                sb.append(e.getKey());
                sb.append("  ::  ");
                sb.append(e.getValue());
                sb.append("\n");
            }
            this.Strings.setText(sb.toString());
            sb = new StringBuilder();
            for (Map.Entry<String, Long> e : this.Post.getNumberValues().entrySet()) {
                if (e.getKey().equals(FileHandler.LARGEFILEKEY) || e.getKey().equals(FileHandler.FILESIZE)) continue;
                sb.append(e.getKey());
                sb.append("  ::  ");
                sb.append(e.getValue());
                sb.append("\n");
            }
            this.Numbers.setText(sb.toString());
            sb = new StringBuilder();
            for (Map.Entry<String, Set<Object>> e : this.Post.getOtherReferences().entrySet()) {
                sb.append(e.getKey());
                sb.append("  ::  ");
                for (BBytes bBytes : e.getValue()) {
                    sb.append(bBytes.toString().substring(0, 10));
                    sb.append(" ");
                }
                sb.append("\n");
            }
            this.References.setText(sb.toString());
        }
    }

    public ExpandedPostDialog(SimpleGUI gui) {
        this.GUI = gui;
        this.setTitle("Post");
        this.setBounds(100, 100, 516, 585);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][grow][grow][grow][grow]"));
        JLabel lblFrom = new JLabel("From");
        this.contentPanel.add((Component)lblFrom, "cell 0 0,alignx trailing");
        this.FromPeer = new JTextField();
        this.FromPeer.setEditable(false);
        this.contentPanel.add((Component)this.FromPeer, "cell 1 0,growx");
        this.FromPeer.setColumns(10);
        JLabel lblDate = new JLabel("Date");
        this.contentPanel.add((Component)lblDate, "cell 0 1,alignx trailing");
        this.DateField = new JTextField();
        this.contentPanel.add((Component)this.DateField, "cell 1 1,growx");
        this.DateField.setEditable(false);
        this.DateField.setColumns(10);
        JLabel lblSubject = new JLabel("Subject");
        this.contentPanel.add((Component)lblSubject, "cell 0 2,alignx trailing");
        this.Subject = new JTextField();
        this.contentPanel.add((Component)this.Subject, "cell 1 2,growx");
        this.Subject.setEditable(false);
        this.Subject.setColumns(10);
        JLabel lblFile = new JLabel("File");
        this.contentPanel.add((Component)lblFile, "cell 0 3,alignx trailing");
        this.FileReference = new JTextField();
        this.contentPanel.add((Component)this.FileReference, "flowx,cell 1 3,growx");
        this.FileReference.setColumns(10);
        this.FileReference.setEditable(false);
        JLabel lblComment = new JLabel("Comment");
        this.contentPanel.add((Component)lblComment, "cell 0 4");
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "cell 1 4,grow");
        this.Comment = new JTextPane();
        this.Comment.setEditable(false);
        scrollPane.setMinimumSize(new Dimension(0, 200));
        scrollPane.setViewportView(this.Comment);
        JLabel lblStrings = new JLabel("Strings");
        this.contentPanel.add((Component)lblStrings, "cell 0 5");
        scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "cell 1 5,grow");
        this.Strings = new JTextPane();
        this.Strings.setEditable(false);
        scrollPane.setViewportView(this.Strings);
        JLabel lblNumbers = new JLabel("Numbers");
        this.contentPanel.add((Component)lblNumbers, "cell 0 6");
        scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "cell 1 6,grow");
        this.Numbers = new JTextPane();
        this.Numbers.setEditable(false);
        scrollPane.setViewportView(this.Numbers);
        this.FileSize = new JTextField();
        this.contentPanel.add((Component)this.FileSize, "cell 1 3");
        this.FileSize.setColumns(10);
        this.FileSize.setEditable(false);
        JButton btnDownload = new JButton("Download");
        this.contentPanel.add((Component)btnDownload, "cell 1 3");
        btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                ExpandedPostDialog.this.GUI.requestDownload(ExpandedPostDialog.this.Post);
            }
        });
        JLabel lblReferences = new JLabel("References");
        this.contentPanel.add((Component)lblReferences, "cell 0 7");
        scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "cell 1 7,grow");
        this.References = new JTextPane();
        this.References.setEditable(false);
        scrollPane.setViewportView(this.References);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Dismiss");
        cancelButton.setActionCommand("Dismiss");
        buttonPane.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExpandedPostDialog.this.setVisible(false);
            }
        });
    }

    public JTextField getSubject() {
        return this.Subject;
    }

    public JTextField getFileReference() {
        return this.FileReference;
    }

    public JTextPane getComment() {
        return this.Comment;
    }

    public JTextPane getStrings() {
        return this.Strings;
    }

    public JTextPane getNumbers() {
        return this.Numbers;
    }

    public JTextPane getReferences() {
        return this.References;
    }

    public JTextField getDateField() {
        return this.DateField;
    }

    public JTextField getFileSize() {
        return this.FileSize;
    }

    public JTextField getFromPeer() {
        return this.FromPeer;
    }
}

