/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.postcodec;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class Codec {
    private static long MagicCookie = 121010995337104865L;

    public static PostDecoded decode(LocalPost post) {
        try {
            File mf = (File)post.getPost().getMessage();
            if (mf != null) {
                FileInputStream fis = new FileInputStream(mf);
                long cookie = FileUtils.readLong(fis);
                if (cookie == MagicCookie) {
                    PostDecoded p = new PostDecoded();
                    int numstrvals = FileUtils.readInt(fis);
                    int c = 0;
                    while (c < numstrvals) {
                        String k = FileUtils.readString(fis);
                        int ksn = FileUtils.readInt(fis);
                        int ki = 0;
                        while (ki < ksn) {
                            String v = FileUtils.readString(fis);
                            p.pushStringValue(k, v);
                            ++ki;
                        }
                        ++c;
                    }
                    int numlongvals = FileUtils.readInt(fis);
                    int c2 = 0;
                    while (c2 < numlongvals) {
                        String k = FileUtils.readString(fis);
                        long v = FileUtils.readLong(fis);
                        p.getNumberValues().put(k, v);
                        ++c2;
                    }
                    int numrefvals = FileUtils.readInt(fis);
                    int c3 = 0;
                    while (c3 < numrefvals) {
                        String k = FileUtils.readString(fis);
                        int n = FileUtils.readInt(fis);
                        int rc = 0;
                        while (rc < n) {
                            BBytes bv = new BBytes(FileUtils.readBytes(fis));
                            p.pushReferenceValue(k, bv);
                            ++rc;
                        }
                        ++c3;
                    }
                    p.setComment(FileUtils.readString(fis));
                    p.setPost(post);
                    return p;
                }
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void ecnode(PostDecoded p) throws IOException {
        File pf = (File)p.getPost().getPost().getMessage();
        FileOutputStream fos = new FileOutputStream(pf);
        FileUtils.writeLong(MagicCookie, fos);
        FileUtils.writeInt(p.getStringValues().size(), fos);
        for (Map.Entry<String, Set<String>> e : p.getStringValues().entrySet()) {
            FileUtils.writeString(e.getKey(), fos);
            Set<String> ss = e.getValue();
            FileUtils.writeInt(ss.size(), fos);
            Iterator<String> i2 = ss.iterator();
            while (i2.hasNext()) {
                FileUtils.writeString(i2.next(), fos);
            }
        }
        FileUtils.writeInt(p.getNumberValues().size(), fos);
        for (Map.Entry<String, Long> e : p.getNumberValues().entrySet()) {
            FileUtils.writeString(e.getKey(), fos);
            FileUtils.writeLong(e.getValue(), fos);
        }
        FileUtils.writeInt(p.getOtherReferences().size(), fos);
        for (Map.Entry<String, Set<Object>> e : p.getOtherReferences().entrySet()) {
            FileUtils.writeString(e.getKey(), fos);
            Set<Object> rs = e.getValue();
            FileUtils.writeInt(rs.size(), fos);
            for (BBytes bBytes : rs) {
                FileUtils.writeBytes(fos, bBytes.getBytes());
            }
        }
        FileUtils.writeString(p.getComment(), fos);
        fos.close();
    }
}

