/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.filehander;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.filehander.FileSplitter;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class PendingMultiDownload {
    public static int CURRENT_FORMAT_VERSION = 1;
    public static int PENDING_PRIMARY_DOWNLOAD = 0;
    public static int PENDING_PEICES = 1;
    public static int COMPLETE = 2;
    private int Mode = 0;
    private File SaveAs;
    private BBytes PrimaryPeice;
    private HashMap<BBytes, Boolean> PeicesReceived = new HashMap();
    private long FinalSize;
    private long DownloadedSize;
    private boolean PrimaryRequested;
    private HashMap<BBytes, Boolean> PeicesRequested = new HashMap();
    private boolean Paused;
    private int Priority;

    public File getSaveAs() {
        return this.SaveAs;
    }

    public synchronized void Init(File sa, BBytes primary, int priority, boolean paused) throws IOException {
        this.Priority = priority;
        this.Paused = paused;
        this.SaveAs = sa;
        this.PrimaryPeice = primary;
        if (!this.SaveAs.exists()) {
            this.SaveAs.createNewFile();
        }
    }

    public synchronized void ResetRequests() {
        this.PrimaryRequested = false;
        for (BBytes k : this.PeicesRequested.keySet()) {
            if (!this.PeicesReceived.get(k).booleanValue()) {
                this.PeicesRequested.put(k, false);
                continue;
            }
            this.PeicesRequested.put(k, true);
        }
    }

    public synchronized BBytes nextPeiceToDownload() {
        if (this.Mode == COMPLETE) {
            return null;
        }
        if (this.Mode == PENDING_PRIMARY_DOWNLOAD) {
            if (!this.PrimaryRequested) {
                this.PrimaryRequested = true;
                return this.PrimaryPeice;
            }
            return null;
        }
        for (Map.Entry<BBytes, Boolean> e : this.PeicesReceived.entrySet()) {
            if (e.getValue().booleanValue() || this.PeicesRequested.get(e.getKey()).booleanValue()) continue;
            this.PeicesRequested.put(e.getKey(), true);
            return e.getKey();
        }
        return null;
    }

    public synchronized void clearPending(BBytes dig) {
        Boolean val = this.PeicesRequested.get(dig);
        if (val != null && val.booleanValue()) {
            this.PeicesRequested.put(dig, false);
        }
    }

    public boolean isComplete() {
        return this.Mode == COMPLETE;
    }

    private synchronized boolean processPrimaryFile(File f) throws IOException {
        boolean used = false;
        FileInputStream fis = new FileInputStream(f);
        int v = fis.read();
        if (v == CURRENT_FORMAT_VERSION) {
            this.FinalSize = FileUtils.readLong(fis);
            int peices = FileUtils.readInt(fis);
            int cnt = 0;
            while (cnt < peices) {
                byte[] b = FileUtils.readBytes(fis);
                BBytes bb = new BBytes(b);
                this.PeicesReceived.put(bb, false);
                this.PeicesRequested.put(bb, false);
                this.Mode = PENDING_PEICES;
                used = true;
                ++cnt;
            }
        }
        fis.close();
        return used;
    }

    public synchronized int getNumberRequested() {
        int r = 0;
        for (BBytes k : this.PeicesRequested.keySet()) {
            if (!this.PeicesRequested.get(k).booleanValue() || this.PeicesReceived.get(k).booleanValue()) continue;
            ++r;
        }
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean ProcessPiece(LocalFileReference ref) {
        boolean used = false;
        if (this.Mode == PENDING_PRIMARY_DOWNLOAD) {
            if (!this.PrimaryPeice.equals(ref.getFileReference().getUnsignedDigest())) return false;
            try {
                if (!this.processPrimaryFile(ref.getFileReference().getFile())) return used;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return used;
        }
        if (this.Mode != PENDING_PEICES) return used;
        Boolean checkit = this.PeicesReceived.get(ref.getFileReference().getUnsignedDigest());
        if (checkit == null) return used;
        if (checkit != false) return used;
        try {
            FileSplitter.insert(this.SaveAs, ref.getFileReference().getFile());
            this.DownloadedSize += ref.getFileReference().getFile().length() - 16L;
            this.PeicesReceived.put((BBytes)ref.getFileReference().getUnsignedDigest(), true);
            used = true;
            if (this.PeicesReceived.containsValue(false)) return used;
            this.Mode = COMPLETE;
            return used;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return used;
    }

    public long getCompleteSize() {
        return this.FinalSize;
    }

    public long getDownloadedSize() {
        return this.DownloadedSize;
    }

    public boolean isPaused() {
        return this.Paused;
    }

    public void setPaused(boolean paused) {
        this.Paused = paused;
    }

    public synchronized boolean isInProgress() {
        for (Map.Entry<BBytes, Boolean> e : this.PeicesRequested.entrySet()) {
            if (!e.getValue().booleanValue() || this.PeicesReceived.get(e.getKey()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public int getPriority() {
        return this.Priority;
    }

    public void setPriority(int priority) {
        this.Priority = priority;
    }
}

