/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.filehander;

import com.db4o.Db4oEmbedded;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.EmbeddedConfiguration;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.filehander.FileHandlerInterface;
import org.ourfilesystem.filehander.FileReturnInterface;
import org.ourfilesystem.filehander.FileSplitter;
import org.ourfilesystem.filehander.PendingMultiDownload;
import org.ourfilesystem.filehander.PendingSingleDownload;
import org.ourfilesystem.postcodec.Codec;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class FileHandler
implements FileHandlerInterface,
EventInterface {
    private static long SPLITSIZE = 0x200000L;
    public static String LARGEFILEKEY = "<<!~>Large_$Split$_File<~!>>";
    public static String FILENAME = "FILENAME";
    public static String FILESIZE = "FILESIZE";
    private ObjectContainer DB;
    private FileReturnInterface FR;
    private CoreUserInterface Core;
    private int MaxDown = 20;
    private File TempDir;
    private int CurrentPending = 0;

    public FileHandler(String file, String tmpdir, CoreUserInterface core, FileReturnInterface fi) {
        this.FR = fi;
        this.Core = core;
        EmbeddedConfiguration db4oconfig = Db4oEmbedded.newConfiguration();
        db4oconfig.common().activationDepth(4);
        db4oconfig.common().updateDepth(4);
        this.DB = Db4oEmbedded.openFile((EmbeddedConfiguration)db4oconfig, (String)file);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                FileHandler.this.DB.close();
            }
        });
        this.TempDir = new File(tmpdir);
        if (this.TempDir.exists()) {
            if (!this.TempDir.isDirectory()) {
                throw new RuntimeException(String.valueOf(tmpdir) + " exists, but is not a directory.  Please rename the file.");
            }
        } else {
            this.TempDir.mkdirs();
        }
        this.ResetAll();
    }

    private void ResetAll() {
        Query q = this.DB.query();
        q.constrain(PendingMultiDownload.class);
        ObjectSet os = q.execute();
        for (PendingMultiDownload p : os) {
            p.ResetRequests();
            this.DB.store((Object)p);
            this.DB.commit();
        }
        q = this.DB.query();
        q.constrain(PendingSingleDownload.class);
        ObjectSet os2 = q.execute();
        for (PendingSingleDownload pd : os2) {
            pd.ResetRequests();
            this.DB.store((Object)pd);
            this.DB.commit();
        }
        this.updateAllStatus();
    }

    public synchronized void Process() {
        boolean hasprocessed = true;
        while (this.CurrentPending < this.MaxDown && hasprocessed) {
            hasprocessed = false;
            HashMap<Integer, LinkedList<PendingMultiDownload>> multimap = new HashMap<Integer, LinkedList<PendingMultiDownload>>();
            HashMap<Integer, LinkedList<PendingSingleDownload>> singmap = new HashMap<Integer, LinkedList<PendingSingleDownload>>();
            Query q = this.DB.query();
            q.constrain(PendingMultiDownload.class);
            ObjectSet os = q.execute();
            for (PendingMultiDownload p : os) {
                if (p.isPaused()) continue;
                LinkedList<PendingMultiDownload> l = (LinkedList<PendingMultiDownload>)multimap.get(p.getPriority());
                if (l == null) {
                    l = new LinkedList<PendingMultiDownload>();
                    multimap.put(p.getPriority(), l);
                }
                l.add(p);
            }
            q = this.DB.query();
            q.constrain(PendingSingleDownload.class);
            ObjectSet os2 = q.execute();
            for (PendingSingleDownload pd : os2) {
                if (pd.isPaused()) continue;
                LinkedList<PendingSingleDownload> l = (LinkedList<PendingSingleDownload>)singmap.get(pd.getPriority());
                if (l == null) {
                    l = new LinkedList<PendingSingleDownload>();
                    singmap.put(pd.getPriority(), l);
                }
                l.add(pd);
            }
            HashSet prioritylist = new HashSet();
            prioritylist.addAll(singmap.keySet());
            prioritylist.addAll(multimap.keySet());
            if (prioritylist.size() <= 0) continue;
            Object[] priorities = prioritylist.toArray();
            Arrays.sort(priorities);
            int p = priorities.length - 1;
            while (p >= 0 && this.CurrentPending < this.MaxDown) {
                List l2;
                List l = (List)singmap.get(priorities[p]);
                if (l != null) {
                    Iterator is = l.iterator();
                    while (is.hasNext() && this.CurrentPending < this.MaxDown) {
                        BBytes b;
                        PendingSingleDownload ps = (PendingSingleDownload)is.next();
                        if (ps.isPaused() || (b = ps.getRequest()) == null) continue;
                        this.Core.downloadFile(b);
                        this.DB.store((Object)ps);
                        this.DB.commit();
                        ++this.CurrentPending;
                        hasprocessed = true;
                    }
                }
                if ((l2 = (List)multimap.get(priorities[p])) != null) {
                    Iterator im = l2.iterator();
                    while (im.hasNext() && this.CurrentPending < this.MaxDown) {
                        BBytes b;
                        PendingMultiDownload pm = (PendingMultiDownload)im.next();
                        if (pm.isPaused() || (b = pm.nextPeiceToDownload()) == null) continue;
                        this.Core.downloadFile(b);
                        this.DB.store((Object)pm);
                        this.DB.commit();
                        ++this.CurrentPending;
                        hasprocessed = true;
                    }
                }
                --p;
            }
        }
    }

    @Override
    public void setFileReturnInterface(FileReturnInterface ri) {
        this.FR = ri;
    }

    @Override
    public void setCoreUserInterface(CoreUserInterface ui) {
        this.Core = ui;
    }

    @Override
    public void setMaxPendingPeicesDown(int number) {
        this.MaxDown = number;
    }

    @Override
    public int getMaxPendingPeicesDown() {
        return this.MaxDown;
    }

    private PendingMultiDownload getMultiDownload(final File saveas) {
        ObjectSet o = this.DB.query((Predicate)new Predicate<PendingMultiDownload>(){

            public boolean match(PendingMultiDownload a) {
                return a.getSaveAs().equals(saveas);
            }
        });
        Iterator i = o.iterator();
        if (i.hasNext()) {
            PendingMultiDownload pmd = (PendingMultiDownload)i.next();
            return pmd;
        }
        return null;
    }

    private PendingSingleDownload getSingleDownload(final File saveas) {
        ObjectSet o = this.DB.query((Predicate)new Predicate<PendingSingleDownload>(){

            public boolean match(PendingSingleDownload a) {
                return a.getSaveAs().equals(saveas);
            }
        });
        Iterator i = o.iterator();
        if (i.hasNext()) {
            PendingSingleDownload pmd = (PendingSingleDownload)i.next();
            return pmd;
        }
        return null;
    }

    @Override
    public synchronized void removeFile(File saveas) {
        PendingSingleDownload sd;
        PendingMultiDownload md = this.getMultiDownload(saveas);
        if (md != null) {
            this.DB.delete((Object)md);
        }
        if ((sd = this.getSingleDownload(saveas)) != null) {
            this.DB.delete((Object)sd);
        }
    }

    @Override
    public synchronized void pauseFile(File saveas) {
        PendingSingleDownload sd;
        PendingMultiDownload md = this.getMultiDownload(saveas);
        if (md != null) {
            md.setPaused(true);
            this.DB.store((Object)md);
            this.DB.commit();
            this.FR.downloadStatusUpdate(saveas, md.getCompleteSize(), md.getDownloadedSize(), md.getNumberRequested(), md.isPaused(), md.isInProgress(), md.getPriority());
        }
        if ((sd = this.getSingleDownload(saveas)) != null) {
            sd.setPaused(true);
            this.DB.store((Object)sd);
            this.DB.commit();
            this.FR.downloadStatusUpdate(saveas, sd.getTotalSize(), sd.getAmountComplete(), md.getNumberRequested(), sd.isPaused(), sd.isInProgress(), sd.getPriority());
        }
    }

    @Override
    public synchronized void resumeFile(File saveas) {
        PendingSingleDownload sd;
        PendingMultiDownload md = this.getMultiDownload(saveas);
        if (md != null) {
            md.setPaused(false);
            this.DB.store((Object)md);
            this.DB.commit();
            this.FR.downloadStatusUpdate(saveas, md.getCompleteSize(), md.getDownloadedSize(), md.getNumberRequested(), md.isPaused(), md.isInProgress(), md.getPriority());
        }
        if ((sd = this.getSingleDownload(saveas)) != null) {
            sd.setPaused(false);
            this.DB.store((Object)sd);
            this.DB.commit();
            this.FR.downloadStatusUpdate(saveas, sd.getTotalSize(), sd.getAmountComplete(), md.getNumberRequested(), sd.isPaused(), sd.isInProgress(), sd.getPriority());
        }
        this.Process();
        this.updateAllStatus();
    }

    @Override
    public synchronized void setPriority(File saveas, int priority) {
        PendingSingleDownload sd;
        PendingMultiDownload md = this.getMultiDownload(saveas);
        if (md != null) {
            md.setPriority(priority);
            this.DB.store((Object)md);
            this.DB.commit();
            this.FR.downloadStatusUpdate(saveas, md.getCompleteSize(), md.getDownloadedSize(), md.getNumberRequested(), md.isPaused(), md.isInProgress(), md.getPriority());
        }
        if ((sd = this.getSingleDownload(saveas)) != null) {
            sd.setPriority(priority);
            this.DB.store((Object)sd);
            this.DB.commit();
            this.FR.downloadStatusUpdate(saveas, sd.getTotalSize(), sd.getAmountComplete(), md.getNumberRequested(), sd.isPaused(), sd.isInProgress(), sd.getPriority());
        }
    }

    public int getCurrentPending() {
        return this.CurrentPending;
    }

    private void insertLargeFile(File file, PostDecoded dec) {
        try {
            List<File> sl = FileSplitter.split(file, this.TempDir, SPLITSIZE);
            LinkedList<LocalFileReference> refs = new LinkedList<LocalFileReference>();
            for (File f : sl) {
                LocalFileReference ref = this.Core.addLocalFile(f, null);
                refs.add(ref);
            }
            File primary = File.createTempFile("primary", ".dat", this.TempDir);
            FileOutputStream fos = new FileOutputStream(primary);
            fos.write(PendingMultiDownload.CURRENT_FORMAT_VERSION);
            FileUtils.writeLong(file.length(), fos);
            FileUtils.writeInt(refs.size(), fos);
            for (LocalFileReference lf : refs) {
                FileUtils.writeBytes(fos, ((BBytes)lf.getFileReference().getUnsignedDigest()).getBytes());
            }
            fos.close();
            Set<String> ks = dec.getStringKeySet(FILENAME);
            if (ks != null) {
                ks.clear();
            }
            dec.pushStringValue(FILENAME, file.getName());
            dec.getNumberValues().put(FILESIZE, file.length());
            dec.getNumberValues().put(LARGEFILEKEY, Long.valueOf(refs.size()));
            dec.getPost().getPost().setMessage(File.createTempFile("message", ".dat", this.TempDir));
            Codec.ecnode(dec);
            this.Core.addLocalFile(primary, dec.getPost().getPost().getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void insertSmallFile(File file, PostDecoded dec) {
        try {
            Set<String> sks;
            File mf = File.createTempFile("message", ".dat", this.TempDir);
            Set<String> ks = dec.getStringKeySet(FILENAME);
            if (ks != null) {
                ks.clear();
            }
            if ((sks = dec.getStringKeySet(FILENAME)) != null) {
                sks.clear();
            }
            dec.pushStringValue(FILENAME, file.getName());
            dec.getNumberValues().put(FILESIZE, file.length());
            dec.getPost().getPost().setMessage(mf);
            Codec.ecnode(dec);
            File tmpfile = File.createTempFile("reffile", ".dat", this.TempDir);
            FileUtils.copyFile(file, tmpfile, false);
            this.Core.addLocalFile(tmpfile, dec.getPost().getPost().getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void insertFile(File file, PostDecoded dec) {
        this.removeFile(file);
        if (file.length() > SPLITSIZE) {
            this.insertLargeFile(file, dec);
        } else {
            this.insertSmallFile(file, dec);
        }
    }

    @Override
    public synchronized void requestFile(File saveas, PostDecoded dec, boolean paused, int priority) {
        Long parts = dec.getNumberValues().get(LARGEFILEKEY);
        BBytes bb = (BBytes)dec.getPost().getPost().getFileReferenceDigest();
        if (bb != null) {
            this.removeFile(saveas);
            if (parts != null) {
                PendingMultiDownload pd = new PendingMultiDownload();
                try {
                    pd.Init(saveas, bb, priority, paused);
                    this.DB.store((Object)pd);
                    this.DB.commit();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                PendingSingleDownload pd = new PendingSingleDownload();
                pd.Init(saveas, bb, priority, paused);
                this.DB.store((Object)pd);
                this.DB.commit();
            }
            this.Process();
        }
        this.updateAllStatus();
    }

    @Override
    public synchronized void updateAllStatus() {
        Query q = this.DB.query();
        q.constrain(PendingMultiDownload.class);
        ObjectSet r = q.execute();
        for (PendingMultiDownload p : r) {
            this.FR.downloadStatusUpdate(p.getSaveAs(), p.getCompleteSize(), p.getDownloadedSize(), p.getNumberRequested(), p.isPaused(), p.isInProgress(), p.getPriority());
        }
        Query q2 = this.DB.query();
        q2.constrain(PendingSingleDownload.class);
        ObjectSet r2 = q2.execute();
        for (PendingSingleDownload p : r2) {
            this.FR.downloadStatusUpdate(p.getSaveAs(), p.getTotalSize(), p.getAmountComplete(), p.getNumberRequested(), p.isPaused(), p.isInProgress(), p.getPriority());
        }
    }

    @Override
    public void newPostReceived(LocalPost postlist) {
    }

    @Override
    public void newPeerReceived(Peer peerlist) {
    }

    @Override
    public synchronized void newFileDownloaded(LocalFileReference filelist) {
        if (filelist != null && filelist.getFileReference() != null && filelist.getFileReference().getFile() != null && filelist.getFileReference().getFile().exists()) {
            Query q = this.DB.query();
            q.constrain(PendingMultiDownload.class);
            ObjectSet os = q.execute();
            for (PendingMultiDownload p : os) {
                if (!p.ProcessPiece(filelist)) continue;
                --this.CurrentPending;
                this.FR.downloadStatusUpdate(p.getSaveAs(), p.getCompleteSize(), p.getDownloadedSize(), p.getNumberRequested(), p.isPaused(), p.isInProgress(), p.getPriority());
                this.DB.store((Object)p);
                this.DB.commit();
            }
            q = this.DB.query();
            q.constrain(PendingSingleDownload.class);
            ObjectSet os2 = q.execute();
            for (PendingSingleDownload pd : os2) {
                if (!pd.ProcessPiece(filelist)) continue;
                --this.CurrentPending;
                this.FR.downloadStatusUpdate(pd.getSaveAs(), pd.getTotalSize(), pd.getAmountComplete(), pd.getNumberRequested(), pd.isPaused(), pd.isInProgress(), pd.getPriority());
                this.DB.store((Object)pd);
                this.DB.commit();
            }
            this.Process();
        }
    }

    @Override
    public synchronized void downloadFailed(Object dig) {
        Query q = this.DB.query();
        q.constrain(PendingMultiDownload.class);
        ObjectSet os = q.execute();
        for (PendingMultiDownload p : os) {
            p.clearPending((BBytes)dig);
            this.DB.store((Object)p);
            this.DB.commit();
        }
        q = this.DB.query();
        q.constrain(PendingSingleDownload.class);
        ObjectSet os2 = q.execute();
        for (PendingSingleDownload pd : os2) {
            if (!pd.getDigest().equals(dig)) continue;
            pd.ResetRequests();
            this.DB.store((Object)pd);
            this.DB.commit();
        }
        this.updateAllStatus();
    }

    @Override
    public void connectionFailure(Peer p) {
    }

    @Override
    public void connectionEvent(ConnectionUpdateInterface con) {
    }
}

