/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseComInterface;
import org.ourfilesystem.db.DataBaseTools;
import org.ourfilesystem.db.FileReference;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.db.StorageInterface;
import org.ourfilesystem.db.TimeInterface;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.security.KeySet;

public class DataBaseComImpl
implements DataBaseComInterface {
    private CryptoDataBaseInterface Security;
    private LinkedList<EventInterface> Event = new LinkedList();
    private StorageInterface Store;
    private TimeInterface Time;
    private CoreUserInterface Core;

    public DataBaseComImpl(CoreUserInterface core) {
        this.Core = core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventInterface(EventInterface evt) {
        LinkedList<EventInterface> linkedList = this.Event;
        synchronized (linkedList) {
            this.Event.add(evt);
        }
    }

    @Override
    public Peer getPeer(Object digest) {
        return this.Store.getPeer(digest);
    }

    @Override
    public boolean processPeerPosts(List<Post> posts) {
        boolean ok = false;
        for (Post p : posts) {
            Peer peer;
            if (p.getSignedDigest() == null || p.getSignedDigest().getDigest() == null || (peer = this.Store.getPeer(p.getSignedDigest().getPeerIdentifier())) == null || peer.getPeerKeysAndIdentity() == null || peer.getPeerKeysAndIdentity().getPublicSigningKey() == null || !this.Security.verifyPost(p, peer.getPeerKeysAndIdentity().getPublicSigningKey())) continue;
            LocalPost lp = new LocalPost();
            lp.setPost(p);
            lp.setLocalDate(this.Time.getTime());
            this.Store.savePost(lp);
            Iterator ie = this.getEventInterfaces().iterator();
            while (ie.hasNext()) {
                ((EventInterface)ie.next()).newPostReceived(lp);
            }
            ok = true;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<EventInterface> getEventInterfaces() {
        LinkedList<EventInterface> te = new LinkedList<EventInterface>();
        LinkedList<EventInterface> linkedList = this.Event;
        synchronized (linkedList) {
            te.addAll(this.Event);
        }
        return te;
    }

    @Override
    public Object processPeerFile(File frs) {
        Object checkdig = this.Security.digestFile(frs);
        FileReference fr = new FileReference();
        fr.setUnsignedDigest(checkdig);
        fr.setFile(frs);
        LocalFileReference lf = new LocalFileReference();
        lf.setFileReference(fr);
        lf.setLocalDate(this.Time.getTime());
        this.Store.saveFile(lf);
        this.Core.addLocalPost(null, checkdig);
        Iterator i = this.getEventInterfaces().iterator();
        while (i.hasNext()) {
            ((EventInterface)i.next()).newFileDownloaded(lf);
        }
        return checkdig;
    }

    @Override
    public void processPeers(List<Peer> peers) {
        Iterator<Peer> i = peers.iterator();
        while (i.hasNext()) {
            boolean doupdate = true;
            Peer p = i.next();
            if (!this.Security.verifyLocation(p, p.getPeerKeysAndIdentity().getPublicSigningKey())) {
                doupdate = false;
            }
            Peer myp = this.getMyPeer();
            Peer chk = this.Store.getPeer(p.getPeerKeysAndIdentity().getSignature().getDigest());
            if (chk != null) {
                if (chk.getUpdateCount() == p.getUpdateCount()) {
                    chk.getLocation().equals(p.getLocation());
                }
                if (chk.getUpdateCount() > p.getUpdateCount()) {
                    doupdate = false;
                } else if (myp.equals(p)) {
                    if (!myp.getPeerKeysAndIdentity().getSignature().getDigest().equals(myp.getPeerKeysAndIdentity().getSignature().getPeerIdentifier())) {
                        doupdate = false;
                    }
                } else {
                    p.setPeerKeysAndIdentity(chk.getPeerKeysAndIdentity());
                }
            }
            if (!doupdate || !DataBaseTools.verifyPeerSignature(p, this.Store, this.Security)) continue;
            if (myp.equals(p)) {
                this.Store.saveMyPeerData(p);
            }
            this.Store.savePeer(p);
            Iterator ie = this.getEventInterfaces().iterator();
            while (ie.hasNext()) {
                ((EventInterface)ie.next()).newPeerReceived(p);
            }
        }
    }

    @Override
    public List<Post> requestPosts(Object peerid, long startnumber, long endnumber) {
        LinkedList<Post> pl = new LinkedList<Post>();
        Peer peer = this.Store.getPeer(peerid);
        if (peer != null) {
            List<LocalPost> lpl = this.Store.getPeerPosts(peer, startnumber, endnumber);
            for (LocalPost lp : lpl) {
                pl.add(lp.getPost());
            }
        }
        return pl;
    }

    @Override
    public File requestsFiles(Object digest) {
        File f;
        LocalFileReference fr = this.Store.getFileReference(digest);
        if (fr != null && fr.getFileReference() != null && (f = fr.getFileReference().getFile()).exists()) {
            return f;
        }
        return null;
    }

    @Override
    public List<Peer> requestPeers() {
        List<Peer> rl = this.Store.getPeerList();
        rl.add(this.getMyPeer());
        return rl;
    }

    @Override
    public Peer getMyPeer() {
        return this.Store.getMyPeerData();
    }

    @Override
    public KeySet getMyKeySet() {
        return this.Store.getMyKeySet();
    }

    public void setSecurity(CryptoDataBaseInterface security) {
        this.Security = security;
    }

    public void setStore(StorageInterface store) {
        this.Store = store;
    }

    public void setTime(TimeInterface time) {
        this.Time = time;
    }

    @Override
    public boolean isBadPeer(Object dig) {
        return this.Store.isBadPeer(dig);
    }
}

