/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.core;

import java.io.File;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ourfilesystem.com.ComConnectionInterface;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseComInterface;
import org.ourfilesystem.db.DataBaseTools;
import org.ourfilesystem.db.FileReference;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.db.PostHoles;
import org.ourfilesystem.db.StorageInterface;
import org.ourfilesystem.db.TimeInterface;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.PublicKeySetSigned;

public class Core
implements CoreUserInterface,
CoreComInterface {
    private StorageInterface UserDataBase;
    private DataBaseComInterface ComDataBase;
    private ComConnectionInterface ComConnector;
    private CryptoDataBaseInterface Security;
    private TimeInterface Time;
    private LinkedList<EventInterface> Events;
    private int MaxPostQuery = 100;
    private int MaxDownloadAttempts = 100;
    private double BusyMultiplier = 1.0;
    private SecureRandom Random;
    private HashMap<Object, ComPeerInterface> OpenConnections = new HashMap();
    private HashMap<Object, Long> ConnectionFailures = new HashMap();
    private HashMap<Object, Integer> DownloadAttempts;
    private HashMap<Object, Integer> GetPostAttempts;

    public Core() {
        this.Random = new SecureRandom();
        this.DownloadAttempts = new HashMap();
        this.GetPostAttempts = new HashMap();
        this.Events = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventInterface(EventInterface ei) {
        LinkedList<EventInterface> linkedList = this.Events;
        synchronized (linkedList) {
            this.Events.add(ei);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<EventInterface> getEventInterfaces() {
        LinkedList<EventInterface> te = new LinkedList<EventInterface>();
        LinkedList<EventInterface> linkedList = this.Events;
        synchronized (linkedList) {
            te.addAll(this.Events);
        }
        return te;
    }

    public StorageInterface getUserDataBase() {
        return this.UserDataBase;
    }

    public void setUserDataBase(StorageInterface userDataBase) {
        this.UserDataBase = userDataBase;
    }

    public DataBaseComInterface getComDataBase() {
        return this.ComDataBase;
    }

    public void setComDataBase(DataBaseComInterface comDataBase) {
        this.ComDataBase = comDataBase;
    }

    public ComConnectionInterface getComConnector() {
        return this.ComConnector;
    }

    public void setComConnector(ComConnectionInterface comConnector) {
        this.ComConnector = comConnector;
    }

    private void newConnectionEvent(ConnectionUpdateInterface p) {
        for (EventInterface e : this.getEventInterfaces()) {
            p.addEventInterface(e);
            e.connectionEvent(p);
        }
    }

    private void connectionFailureEvent(Peer p) {
        Iterator i = this.getEventInterfaces().iterator();
        while (i.hasNext()) {
            ((EventInterface)i.next()).connectionFailure(p);
        }
    }

    private void newPeerReceivedEvent(Peer p) {
        Iterator i = this.getEventInterfaces().iterator();
        while (i.hasNext()) {
            ((EventInterface)i.next()).newPeerReceived(p);
        }
    }

    private void newFileDownloadedEvent(LocalFileReference lf) {
        Iterator i = this.getEventInterfaces().iterator();
        while (i.hasNext()) {
            ((EventInterface)i.next()).newFileDownloaded(lf);
        }
    }

    private void newPostReceivedEvent(LocalPost lp) {
        Iterator i = this.getEventInterfaces().iterator();
        while (i.hasNext()) {
            ((EventInterface)i.next()).newPostReceived(lp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ComPeerInterface getConnection(Object pid) {
        Peer p = this.getComDataBase().getPeer(pid);
        if (p != null && !p.equals(this.getComDataBase().getMyPeer())) {
            ComPeerInterface c = null;
            HashMap<Object, ComPeerInterface> hashMap = this.OpenConnections;
            synchronized (hashMap) {
                c = this.OpenConnections.get(pid);
            }
            if (c != null) {
                return c;
            }
            c = this.getComConnector().getComPeerInterface(p);
            if (c != null) {
                this.newConnectionEvent((ConnectionUpdateInterface)((Object)c));
                hashMap = this.OpenConnections;
                synchronized (hashMap) {
                    this.OpenConnections.put(pid, c);
                }
                return c;
            }
            this.connectionFailureEvent(p);
        }
        return null;
    }

    private ComPeerInterface getRandomPeerConnection(Set<Object> peers) {
        if (peers.size() > 0) {
            Object[] pa = peers.toArray();
            return this.getConnection(pa[this.Random.nextInt(pa.length)]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComPeerInterface getPeerConnection(Object pid) {
        ComPeerInterface c = null;
        HashMap<Object, Object> hashMap = this.OpenConnections;
        synchronized (hashMap) {
            c = this.OpenConnections.get(pid);
        }
        if (c != null && c.isOk()) {
            hashMap = this.ConnectionFailures;
            synchronized (hashMap) {
                this.ConnectionFailures.remove(pid);
            }
            return c;
        }
        return this.getConnection(pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComPeerInterface getAPeerConnection(Set<Object> peers) {
        HashSet<Object> notconnected = new HashSet<Object>();
        Iterator<Object> i = peers.iterator();
        ComPeerInterface leastbusy = null;
        while (i.hasNext()) {
            Object pid = i.next();
            ComPeerInterface ci = null;
            HashMap<Object, Object> hashMap = this.OpenConnections;
            synchronized (hashMap) {
                ci = this.OpenConnections.get(pid);
            }
            if (ci != null) {
                if (ci.isOk()) {
                    hashMap = this.ConnectionFailures;
                    synchronized (hashMap) {
                        this.ConnectionFailures.remove(pid);
                    }
                    if (leastbusy == null) {
                        leastbusy = ci;
                        continue;
                    }
                    if (leastbusy.getPendingRequests() <= ci.getPendingRequests()) continue;
                    leastbusy = ci;
                    continue;
                }
                notconnected.add(pid);
                continue;
            }
            notconnected.add(pid);
        }
        if (leastbusy != null && leastbusy.getPendingRequests() == 0) {
            return leastbusy;
        }
        Object leastfailed = null;
        long leastfails = 0L;
        for (Object pid : notconnected) {
            Long numfails = 0L;
            HashMap<Object, Long> hashMap = this.ConnectionFailures;
            synchronized (hashMap) {
                numfails = this.ConnectionFailures.get(pid);
            }
            if (numfails == null) continue;
            if (leastfailed == null) {
                leastfailed = pid;
                leastfails = numfails;
                continue;
            }
            if (numfails >= leastfails) continue;
            leastfailed = pid;
            leastfails = numfails;
        }
        if (leastfailed == null) {
            ComPeerInterface r = this.getRandomPeerConnection(notconnected);
            if (r == null) {
                r = leastbusy;
            }
            return r;
        }
        if (leastbusy == null) {
            return this.getConnection(leastfailed);
        }
        double numfails = leastfails;
        double numbusy = (double)leastbusy.getPendingRequests() * this.getBusyMultiplier();
        double d = numfails + numbusy;
        double probofusingbusy = 0.5;
        if (d > 0.0) {
            probofusingbusy = numfails / d;
        }
        if ((double)this.Random.nextFloat() < probofusingbusy) {
            return leastbusy;
        }
        return this.getConnection(leastfailed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<Peer> getConnections() {
        HashSet<Peer> r = new HashSet<Peer>();
        HashMap<Object, ComPeerInterface> hashMap = this.OpenConnections;
        synchronized (hashMap) {
            for (Map.Entry<Object, ComPeerInterface> e : this.OpenConnections.entrySet()) {
                Peer p = this.UserDataBase.getPeer(e.getKey());
                if (p == null) continue;
                r.add(p);
            }
        }
        return r;
    }

    @Override
    public void generateNewKeys() {
        KeySet ks = this.Security.generateNewKeys();
        this.getUserDataBase().saveMyKeySet(ks);
        Peer np = this.getUserDataBase().getMyPeerData();
        if (np == null) {
            np = new Peer();
        }
        PublicKeySetSigned ps = new PublicKeySetSigned();
        ps.setPublicEncryptionKey(ks.getPublicKeySet().getPublicEncryptionKey());
        ps.setPublicSigningKey(ks.getPublicKeySet().getPublicSigningKey());
        np.setPeerKeysAndIdentity(ps);
        this.Security.selfSignMyPeerId(np, ks.getPrivateSigningKey());
        this.Security.signLocation(np, ks.getPrivateSigningKey());
        this.getUserDataBase().saveMyPeerData(np);
    }

    @Override
    public void setMyLocation(Object location) {
        Peer p = this.getUserDataBase().getMyPeerData();
        if (p == null) {
            p = new Peer();
        }
        p.setUpdateCount(p.getUpdateCount() + 1L);
        p.setLocation(location);
        KeySet ks = this.getUserDataBase().getMyKeySet();
        if (ks != null) {
            this.Security.signLocation(p, ks.getPrivateSigningKey());
        }
        this.getUserDataBase().saveMyPeerData(p);
        this.newPeerReceivedEvent(p);
    }

    @Override
    public void setMyNickname(String nickname) {
        Peer p = this.getUserDataBase().getMyPeerData();
        if (p == null) {
            p = new Peer();
        }
        p.setUpdateCount(p.getUpdateCount() + 1L);
        p.setNickname(nickname);
        KeySet ks = this.getUserDataBase().getMyKeySet();
        if (ks != null) {
            this.Security.signLocation(p, ks.getPrivateSigningKey());
        }
        this.getUserDataBase().saveMyPeerData(p);
        this.newPeerReceivedEvent(p);
    }

    @Override
    public void setMyIntroduction(String intro) {
        Peer p = this.getUserDataBase().getMyPeerData();
        if (p == null) {
            p = new Peer();
        }
        p.setUpdateCount(p.getUpdateCount() + 1L);
        p.setIntroduction(intro);
        KeySet ks = this.getUserDataBase().getMyKeySet();
        this.Security.signLocation(p, ks.getPrivateSigningKey());
        this.getUserDataBase().saveMyPeerData(p);
        this.newPeerReceivedEvent(p);
    }

    @Override
    public Peer signPeer(Peer peerdata) {
        if (peerdata.getPeerKeysAndIdentity() != null && peerdata.getPeerKeysAndIdentity().getSignature() != null) {
            this.getUserDataBase().removeBadPeer(peerdata.getPeerKeysAndIdentity().getSignature().getDigest());
        }
        KeySet ks = this.getUserDataBase().getMyKeySet();
        Peer myp = this.getUserDataBase().getMyPeerData();
        Object peerid = null;
        if (myp.getPeerKeysAndIdentity().getSignature() != null) {
            peerid = myp.getPeerKeysAndIdentity().getSignature().getDigest();
        }
        if (this.Security.verifyLocation(peerdata, peerdata.getPeerKeysAndIdentity().getPublicSigningKey())) {
            peerdata = this.Security.signPeer(peerdata, peerid, ks.getPrivateSigningKey());
            this.getUserDataBase().savePeer(peerdata);
            this.newPeerReceivedEvent(peerdata);
        }
        return peerdata;
    }

    @Override
    public LocalFileReference addLocalFile(File f, Object message) {
        Object dig = this.Security.digestFile(f);
        FileReference fr = new FileReference();
        fr.setFile(f);
        fr.setUnsignedDigest(dig);
        LocalFileReference lfr = new LocalFileReference();
        lfr.setFileReference(fr);
        lfr.setLocalDate(this.Time.getTime());
        this.getUserDataBase().saveFile(lfr);
        this.addLocalPost(message, dig);
        this.newFileDownloadedEvent(lfr);
        return lfr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalPost addLocalPost(Object message, Object fileref) {
        Serializable id;
        StorageInterface store;
        Post p = new Post();
        LocalFileReference lf = this.getUserDataBase().getFileReference(fileref);
        if (lf != null && lf.getFileReference() != null && lf.getFileReference().getFile().exists()) {
            p.setPosterHasFile(true);
        }
        p.setMessage(message);
        p.setFileReferenceDigest(fileref);
        LocalPost lp = new LocalPost();
        lp.setPost(p);
        lp.setLocalDate(this.Time.getTime());
        StorageInterface storageInterface = store = this.getUserDataBase();
        synchronized (storageInterface) {
            id = store.getLastPostNumber(this.getMyPeerData());
            if (id == null) {
                id = 0L;
            }
            id = id + 1L;
            p.setPostNumber((long)id);
            Peer myp = store.getMyPeerData();
            p = this.Security.signPost(p, myp.getPeerKeysAndIdentity().getSignature().getDigest(), store.getMyKeySet().getPrivateSigningKey());
            store.savePost(lp);
        }
        this.newPostReceivedEvent(lp);
        LinkedList<ComPeerInterface> slist = new LinkedList<ComPeerInterface>();
        id = this.OpenConnections;
        synchronized (id) {
            slist.addAll(this.OpenConnections.values());
        }
        for (ComPeerInterface com : slist) {
            com.sendPost(p);
        }
        return lp;
    }

    @Override
    public void downloadFile(Object digest) {
        LocalFileReference lf = this.getUserDataBase().getFileReference(digest);
        if (lf == null || lf.getFileReference() == null || lf.getFileReference().getFile() == null || !lf.getFileReference().getFile().exists()) {
            int page = 0;
            HashSet<Object> peers = new HashSet<Object>();
            List<LocalPost> p = this.getUserDataBase().getFilePosts(digest, page, this.getMaxPostQuery());
            System.out.println("Number of peers that have post: " + p.size());
            while (p.size() > 0) {
                for (LocalPost lp : p) {
                    if (!lp.getPost().isPosterHasFile()) continue;
                    peers.add(lp.getPost().getSignedDigest().getPeerIdentifier());
                }
                p = this.getUserDataBase().getFilePosts(digest, ++page, this.getMaxPostQuery());
            }
            ComPeerInterface com = this.getAPeerConnection(peers);
            if (com != null) {
                com.requestsFile(digest);
            }
        } else {
            this.newFileDownloadedEvent(lf);
        }
    }

    @Override
    public void updatePeers() {
        List<Peer> pl = this.getUserDataBase().getPeerList();
        for (Peer p : pl) {
            ComPeerInterface com = this.getPeerConnection(p.getPeerKeysAndIdentity().getSignature().getDigest());
            if (com == null) continue;
            com.requestPeers();
        }
    }

    @Override
    public void updatePosts() {
        Object myid = this.getUserDataBase().getMyPeerData().getPeerKeysAndIdentity().getSignature().getDigest();
        List<Peer> pl = this.getUserDataBase().getPeerList();
        for (Peer p : pl) {
            List<PostHoles> holes;
            ComPeerInterface com;
            if (p.getPeerKeysAndIdentity().getSignature().getDigest().equals(myid)) continue;
            Long lastnum = this.getUserDataBase().getLastPostNumber(p);
            if (lastnum == null) {
                lastnum = 0L;
            }
            if ((com = this.getPeerConnection(p.getPeerKeysAndIdentity().getSignature().getDigest())) != null) {
                com.requtestPosts(p.getPeerKeysAndIdentity().getSignature().getDigest(), lastnum + 1L, Long.MAX_VALUE);
            }
            if ((holes = this.getUserDataBase().getPostHoles(p)) == null) continue;
            for (PostHoles ph : holes) {
                com.requtestPosts(p.getPeerKeysAndIdentity().getSignature().getDigest(), ph.getFirstNumber(), ph.getLastNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newConnection(ComPeerInterface com) {
        HashMap<Object, ComPeerInterface> hashMap = this.OpenConnections;
        synchronized (hashMap) {
            this.newConnectionEvent((ConnectionUpdateInterface)((Object)com));
            this.OpenConnections.put(com.getPeer().getPeerKeysAndIdentity().getSignature().getDigest(), com);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPostsFailed(Object conpeer, Object peerid, long fromnumber, long tonumber) {
        boolean tryagain = false;
        HashMap<Object, Integer> hashMap = this.GetPostAttempts;
        synchronized (hashMap) {
            Integer attempts = this.GetPostAttempts.get(peerid);
            if (attempts == null) {
                attempts = 0;
            }
            if ((attempts = Integer.valueOf(attempts + 1)) > this.getMaxDownloadAttempts()) {
                tryagain = false;
                this.GetPostAttempts.remove(peerid);
            } else {
                tryagain = true;
                this.GetPostAttempts.put(peerid, attempts);
            }
        }
        if (tryagain) {
            HashSet<Object> peerids = new HashSet<Object>();
            List<Peer> pl = this.getUserDataBase().getPeerList();
            Iterator<Peer> i = pl.iterator();
            while (i.hasNext()) {
                peerids.add(i.next().getPeerKeysAndIdentity().getSignature().getDigest());
            }
            ComPeerInterface com = this.getAPeerConnection(peerids);
            if (com != null) {
                com.requtestPosts(peerid, fromnumber, tonumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFileFailed(Object conpeer, Object filedig) {
        boolean tryagain = false;
        HashMap<Object, Integer> hashMap = this.DownloadAttempts;
        synchronized (hashMap) {
            Integer attempts = this.DownloadAttempts.get(filedig);
            if (attempts == null) {
                attempts = 0;
            }
            if ((attempts = Integer.valueOf(attempts + 1)) > this.getMaxDownloadAttempts()) {
                tryagain = false;
                this.DownloadAttempts.remove(filedig);
            } else {
                tryagain = true;
                this.DownloadAttempts.put(filedig, attempts);
            }
        }
        if (tryagain) {
            this.downloadFile(filedig);
        } else {
            Iterator i = this.getEventInterfaces().iterator();
            while (i.hasNext()) {
                ((EventInterface)i.next()).downloadFailed(filedig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPostSucceed(Object conpeer, Object peerid) {
        HashMap<Object, Integer> hashMap = this.GetPostAttempts;
        synchronized (hashMap) {
            this.GetPostAttempts.remove(peerid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFileSucceed(Object conpeer, Object filedig) {
        HashMap<Object, Integer> hashMap = this.DownloadAttempts;
        synchronized (hashMap) {
            this.DownloadAttempts.remove(filedig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(Object conpeer, boolean error) {
        HashMap<Object, Object> hashMap = this.OpenConnections;
        synchronized (hashMap) {
            this.OpenConnections.remove(conpeer);
        }
        hashMap = this.ConnectionFailures;
        synchronized (hashMap) {
            Long failures = this.ConnectionFailures.get(conpeer);
            if (failures == null) {
                failures = 0L;
            }
            failures = failures + 1L;
            this.ConnectionFailures.put(conpeer, failures);
            Peer p = this.UserDataBase.getPeer(conpeer);
            this.connectionFailureEvent(p);
        }
    }

    public int getMaxPostQuery() {
        return this.MaxPostQuery;
    }

    public void setMaxPostQuery(int maxPostQuery) {
        this.MaxPostQuery = maxPostQuery;
    }

    public double getBusyMultiplier() {
        return this.BusyMultiplier;
    }

    public void setBusyMultiplier(double busyMultiplier) {
        this.BusyMultiplier = busyMultiplier;
    }

    public int getMaxDownloadAttempts() {
        return this.MaxDownloadAttempts;
    }

    public void setMaxDownloadAttempts(int maxDownloadAttempts) {
        this.MaxDownloadAttempts = maxDownloadAttempts;
    }

    public CryptoDataBaseInterface getSecurity() {
        return this.Security;
    }

    public void setSecurity(CryptoDataBaseInterface security) {
        this.Security = security;
    }

    public TimeInterface getTime() {
        return this.Time;
    }

    public void setTime(TimeInterface time) {
        this.Time = time;
    }

    @Override
    public Peer getMyPeerData() {
        return this.UserDataBase.getMyPeerData();
    }

    @Override
    public List<Peer> getPeerList() {
        return this.UserDataBase.getPeerList();
    }

    @Override
    public List<LocalPost> getPeerPostsByPage(Peer p, int page, int pagesize) {
        return this.UserDataBase.getPeerPosts(p, page, pagesize);
    }

    @Override
    public List<LocalPost> getPeerPostsByNumber(Peer p, long start, long end) {
        return this.UserDataBase.getPeerPosts(p, start, end);
    }

    @Override
    public List<LocalPost> getFilePosts(Object dig, int page, int pagesize) {
        return this.UserDataBase.getFilePosts(dig, page, pagesize);
    }

    @Override
    public List<LocalPost> getPosts(Date fromdate) {
        return this.UserDataBase.getPosts(fromdate);
    }

    @Override
    public LocalFileReference getFileReference(Object dig) {
        return this.UserDataBase.getFileReference(dig);
    }

    @Override
    public List<LocalFileReference> getFileReferences(int page, int pagesize) {
        return this.UserDataBase.getFileReferences(page, pagesize);
    }

    @Override
    public List<LocalFileReference> getFileReferences(Date fromdate) {
        return this.UserDataBase.getFileReferences(fromdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void CloseConnections() {
        ComConnectionInterface c = this.getComConnector();
        if (c != null) {
            c.Close();
        }
        LinkedList<ComPeerInterface> tl = new LinkedList<ComPeerInterface>();
        HashMap<Object, ComPeerInterface> hashMap = this.OpenConnections;
        synchronized (hashMap) {
            tl.addAll(this.OpenConnections.values());
        }
        for (ComPeerInterface e : tl) {
            try {
                e.Close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBadPeer(Peer p) {
        this.getUserDataBase().saveBadPeer(p);
        this.getUserDataBase().removePeer(p);
        ComPeerInterface com = null;
        HashMap<Object, ComPeerInterface> hashMap = this.OpenConnections;
        synchronized (hashMap) {
            com = this.OpenConnections.get(p.getPeerKeysAndIdentity().getSignature().getDigest());
        }
        if (com != null) {
            com.Close();
            this.connectionFailureEvent(p);
        }
        Peer me = this.getMyPeerData();
        List<Peer> lst = this.getUserDataBase().getPeerList();
        for (Peer tp : lst) {
            if (DataBaseTools.verifyPeerSignature(tp, this.getUserDataBase(), this.getSecurity())) continue;
            if (tp.equals(me)) {
                KeySet ks = this.UserDataBase.getMyKeySet();
                this.Security.selfSignMyPeerId(me, ks.getPrivateSigningKey());
                this.getUserDataBase().saveMyPeerData(me);
                continue;
            }
            this.getUserDataBase().removePeer(tp);
            HashMap<Object, ComPeerInterface> hashMap2 = this.OpenConnections;
            synchronized (hashMap2) {
                com = this.OpenConnections.get(tp.getPeerKeysAndIdentity().getSignature().getDigest());
            }
            if (com == null) continue;
            com.Close();
            this.connectionFailureEvent(tp);
        }
    }
}

