/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.com;

import java.io.File;
import org.ourfilesystem.com.ComConnectionInterface;
import org.ourfilesystem.com.ComPeerImpl;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSServerSocket;
import org.ourfilesystem.com.OFSSocket;
import org.ourfilesystem.com.SignatureRequestInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.db.DataBaseComInterface;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.security.CryptoComInterface;

public class ComConnectionImpl
implements ComConnectionInterface,
Runnable {
    private boolean Closed;
    private CoreComInterface Core;
    private DataBaseComInterface DB;
    private CryptoComInterface Crypt;
    private SignatureRequestInterface SignatureRequest;
    private boolean Run;
    private File TempDir;
    private OFSServerSocket Server;
    private OFSConnector Connector;

    public ComConnectionImpl(CoreComInterface core, DataBaseComInterface db, CryptoComInterface crypt, SignatureRequestInterface req, String tmpdir, OFSServerSocket ss, OFSConnector con) {
        this.Server = ss;
        this.Connector = con;
        this.SignatureRequest = req;
        this.Core = core;
        this.DB = db;
        this.Crypt = crypt;
        this.Run = true;
        this.TempDir = new File(tmpdir);
        this.TempDir.mkdirs();
        this.Closed = false;
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void Close() {
        if (!this.Closed) {
            this.Closed = true;
            try {
                if (this.Server != null) {
                    this.Server.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public ComPeerInterface getComPeerInterface(Peer peer) {
        if (!this.Closed) {
            ComPeerImpl c = new ComPeerImpl(this.Core, this.DB, this.Crypt, this.SignatureRequest, peer, this.TempDir, this.Connector);
            return c;
        }
        return null;
    }

    @Override
    public void run() {
        try {
            while (this.Run) {
                OFSSocket s = this.Server.accept();
                new ComPeerImpl(this.Core, this.DB, this.Crypt, this.SignatureRequest, null, this.TempDir, s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

