/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.DataHelper;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientSessionKeyManager
extends SessionKeyManager {
    private final Log _log;
    private final Map<PublicKey, OutboundSession> _outboundSessions;
    private final Map<SessionTag, TagSet> _inboundTagSets;
    protected final I2PAppContext _context;
    private volatile boolean _alive;
    private final AtomicInteger _rcvTagSetID = new AtomicInteger();
    private final AtomicInteger _sentTagSetID = new AtomicInteger();
    public static final long SESSION_TAG_DURATION_MS = 600000L;
    public static final long SESSION_LIFETIME_MAX_MS = 900000L;
    public static final int MAX_INBOUND_SESSION_TAGS = 500000;

    public TransientSessionKeyManager(I2PAppContext context) {
        super(context);
        this._log = context.logManager().getLog(TransientSessionKeyManager.class);
        this._context = context;
        this._outboundSessions = new HashMap<PublicKey, OutboundSession>(64);
        this._inboundTagSets = new HashMap<SessionTag, TagSet>(1024);
        context.statManager().createRateStat("crypto.sessionTagsExpired", "How many tags/sessions are expired?", "Encryption", new long[]{600000L, 3600000L, 10800000L});
        context.statManager().createRateStat("crypto.sessionTagsRemaining", "How many tags/sessions are remaining after a cleanup?", "Encryption", new long[]{600000L, 3600000L, 10800000L});
        this._alive = true;
        SimpleScheduler.getInstance().addEvent(new CleanupEvent(), 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this._alive = false;
        Map<SimpleDataStructure, Object> map = this._inboundTagSets;
        synchronized (map) {
            this._inboundTagSets.clear();
        }
        map = this._outboundSessions;
        synchronized (map) {
            this._outboundSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<TagSet> getInboundTagSets() {
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            return new HashSet<TagSet>(this._inboundTagSets.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<OutboundSession> getOutboundSessions() {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            return new HashSet<OutboundSession>(this._outboundSessions.values());
        }
    }

    @Override
    public SessionKey getCurrentKey(PublicKey target) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return null;
        }
        long now = this._context.clock().now();
        if (sess.getLastUsedDate() < now - 900000L) {
            if (this._log.shouldLog(20)) {
                this._log.info("Expiring old session key established on " + new Date(sess.getEstablishedDate()) + " but not used for " + (now - sess.getLastUsedDate()) + "ms with target " + TransientSessionKeyManager.toString(target));
            }
            return null;
        }
        return sess.getCurrentKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionKey getCurrentOrNewKey(PublicKey target) {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            OutboundSession sess = this._outboundSessions.get(target);
            if (sess != null) {
                long now = this._context.clock().now();
                if (sess.getLastUsedDate() < now - 900000L) {
                    sess = null;
                }
            }
            if (sess == null) {
                SessionKey key = this._context.keyGenerator().generateSessionKey();
                sess = this.createAndReturnSession(target, key);
                return key;
            }
            return sess.getCurrentKey();
        }
    }

    @Override
    public void createSession(PublicKey target, SessionKey key) {
        this.createAndReturnSession(target, key);
    }

    private OutboundSession createAndReturnSession(PublicKey target, SessionKey key) {
        if (this._log.shouldLog(20)) {
            this._log.info("New OB session, sesskey: " + key + " target: " + TransientSessionKeyManager.toString(target));
        }
        OutboundSession sess = new OutboundSession(this._context, this._log, target);
        sess.setCurrentKey(key);
        this.addSession(sess);
        return sess;
    }

    @Override
    public SessionTag consumeNextAvailableTag(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No session for " + TransientSessionKeyManager.toString(target));
            }
            return null;
        }
        if (sess.getCurrentKey().equals(key)) {
            SessionTag nxt = sess.consumeNext();
            return nxt;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Key does not match existing key, no tag");
        }
        return null;
    }

    @Override
    public int getAvailableTags(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0;
        }
        if (sess.getCurrentKey().equals(key)) {
            return sess.availableTags();
        }
        return 0;
    }

    @Override
    public long getAvailableTimeLeft(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0L;
        }
        if (sess.getCurrentKey().equals(key)) {
            long end = sess.getLastExpirationDate();
            if (end <= 0L) {
                return 0L;
            }
            return end - this._context.clock().now();
        }
        return 0L;
    }

    @Override
    public TagSetHandle tagsDelivered(PublicKey target, SessionKey key, Set<SessionTag> sessionTags) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No session for delivered TagSet to target: " + TransientSessionKeyManager.toString(target));
            }
            sess = this.createAndReturnSession(target, key);
        } else {
            sess.setCurrentKey(key);
        }
        TagSet set = new TagSet(sessionTags, key, this._context.clock().now(), this._sentTagSetID.incrementAndGet());
        sess.addTags(set);
        if (this._log.shouldLog(10)) {
            this._log.debug("Tags delivered: " + set + " target: " + TransientSessionKeyManager.toString(target));
        }
        return set;
    }

    @Override
    public void failTags(PublicKey target) {
        this.removeSession(target);
    }

    @Override
    public void failTags(PublicKey target, SessionKey key, TagSetHandle ts) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No session for failed TagSet: " + ts);
            }
            return;
        }
        if (!key.equals(sess.getCurrentKey())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Wrong session key (wanted " + sess.getCurrentKey() + ") for failed TagSet: " + ts);
            }
            return;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("TagSet failed: " + ts);
        }
        sess.failTags((TagSet)ts);
    }

    @Override
    public void tagsAcked(PublicKey target, SessionKey key, TagSetHandle ts) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No session for acked TagSet: " + ts);
            }
            return;
        }
        if (!key.equals(sess.getCurrentKey())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Wrong session key (wanted " + sess.getCurrentKey() + ") for acked TagSet: " + ts);
            }
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("TagSet acked: " + ts);
        }
        sess.ackTags((TagSet)ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags) {
        int overage = 0;
        TagSet tagSet = new TagSet(sessionTags, key, this._context.clock().now(), this._rcvTagSetID.incrementAndGet());
        if (this._log.shouldLog(20)) {
            this._log.info("Received " + tagSet);
        }
        TagSet old = null;
        SessionTag dupTag = null;
        for (SessionTag tag : sessionTags) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Receiving tag " + tag + " in tagSet: " + tagSet);
            }
            Map<SessionTag, TagSet> map = this._inboundTagSets;
            synchronized (map) {
                old = this._inboundTagSets.put(tag, tagSet);
                overage = this._inboundTagSets.size() - 500000;
                if (old != null) {
                    if (!old.getAssociatedKey().equals(tagSet.getAssociatedKey())) {
                        this._inboundTagSets.remove(tag);
                        dupTag = tag;
                        break;
                    }
                    old = null;
                }
            }
        }
        if (old != null) {
            Map<SessionTag, TagSet> map = this._inboundTagSets;
            synchronized (map) {
                for (SessionTag tag : old.getTags()) {
                    this._inboundTagSets.remove(tag);
                }
                for (SessionTag tag : sessionTags) {
                    this._inboundTagSets.remove(tag);
                }
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Multiple tags matching!  tagSet: " + tagSet + " and old tagSet: " + old + " tag: " + dupTag + "/" + dupTag);
                this._log.warn("Earlier tag set creation: " + old + ": key=" + old.getAssociatedKey());
                this._log.warn("Current tag set creation: " + tagSet + ": key=" + tagSet.getAssociatedKey());
            }
        }
        if (overage > 0) {
            this.clearExcess(overage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExcess(int overage) {
        long now = this._context.clock().now();
        int old = 0;
        int large = 0;
        int absurd = 0;
        int recent = 0;
        int tags = 0;
        int toRemove = overage * 2;
        this._log.log(50, "TOO MANY SESSION TAGS! Starting cleanup, overage = " + overage);
        ArrayList<TagSet> removed = new ArrayList<TagSet>(toRemove);
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            for (TagSet set : this._inboundTagSets.values()) {
                int size = set.getTags().size();
                if (size > 1000) {
                    ++absurd;
                }
                if (size > 100) {
                    ++large;
                }
                if (now - set.getDate() > 900000L) {
                    ++old;
                } else if (now - set.getDate() < 60000L) {
                    ++recent;
                }
                if (removed.size() >= toRemove && now - set.getDate() <= 900000L) continue;
                removed.add(set);
            }
            for (int i = 0; i < removed.size(); ++i) {
                TagSet cur = (TagSet)removed.get(i);
                for (SessionTag tag : cur.getTags()) {
                    this._inboundTagSets.remove(tag);
                    ++tags;
                }
            }
        }
        if (this._log.shouldLog(50)) {
            this._log.log(50, "TOO MANY SESSION TAGS!  removing " + removed + " tag sets arbitrarily, with " + tags + " tags," + "where there are " + old + " long lasting sessions, " + recent + " ones created in the last minute, and " + large + " sessions with more than 100 tags (and " + absurd + " with more than 1000!), leaving a total of " + this._inboundTagSets.size() + " tags behind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionKey consumeTag(SessionTag tag) {
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            TagSet tagSet = this._inboundTagSets.remove(tag);
            if (tagSet == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Cannot consume IB " + tag + " as it is not known");
                }
                return null;
            }
            tagSet.consume(tag);
            SessionKey key = tagSet.getAssociatedKey();
            if (this._log.shouldLog(10)) {
                this._log.debug("IB Tag consumed: " + tag + " from: " + tagSet);
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutboundSession getSession(PublicKey target) {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            return this._outboundSessions.get(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(OutboundSession sess) {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            this._outboundSessions.put(sess.getTarget(), sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(PublicKey target) {
        if (target == null) {
            return;
        }
        OutboundSession session = null;
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            session = this._outboundSessions.remove(target);
        }
        if (session != null && this._log.shouldLog(30)) {
            this._log.warn("Removing session tags with " + session.availableTags() + " available for " + (session.getLastExpirationDate() - this._context.clock().now()) + "ms more", new Exception("Removed by"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int aggressiveExpire() {
        Iterator<Object> iter;
        int removed = 0;
        int remaining = 0;
        long now = this._context.clock().now();
        StringBuilder buf = null;
        if (this._log.shouldLog(10)) {
            buf = new StringBuilder(128);
            buf.append("Expiring inbound: ");
        }
        Map<SimpleDataStructure, Object> map = this._inboundTagSets;
        synchronized (map) {
            iter = this._inboundTagSets.keySet().iterator();
            while (iter.hasNext()) {
                SessionTag tag = iter.next();
                TagSet ts = this._inboundTagSets.get(tag);
                long age = now - ts.getDate();
                if (age <= 900000L) continue;
                iter.remove();
                ++removed;
                if (buf == null) continue;
                buf.append(tag).append(" @ age ").append(DataHelper.formatDuration(age));
            }
            remaining = this._inboundTagSets.size();
        }
        this._context.statManager().addRateData("crypto.sessionTagsRemaining", remaining, 0L);
        if (buf != null && removed > 0) {
            this._log.debug(buf.toString());
        }
        map = this._outboundSessions;
        synchronized (map) {
            iter = this._outboundSessions.values().iterator();
            while (iter.hasNext()) {
                OutboundSession sess = (OutboundSession)iter.next();
                removed += sess.expireTags();
                if (sess.getLastUsedDate() >= now - 450000L || sess.availableTags() > 0) continue;
                iter.remove();
                ++removed;
            }
        }
        return removed;
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        int size;
        TreeSet<TagSet> sets;
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h2>Inbound sessions</h2><table>");
        Set<TagSet> inbound = this.getInboundTagSets();
        HashMap inboundSets = new HashMap(inbound.size());
        for (TagSet ts : inbound) {
            if (!inboundSets.containsKey(ts.getAssociatedKey())) {
                inboundSets.put(ts.getAssociatedKey(), new HashSet());
            }
            Set sets2 = (Set)inboundSets.get(ts.getAssociatedKey());
            sets2.add(ts);
        }
        int total = 0;
        long now = this._context.clock().now();
        for (Map.Entry e : inboundSets.entrySet()) {
            SessionKey skey = (SessionKey)e.getKey();
            sets = new TreeSet<TagSet>(new TagSetComparator());
            sets.addAll((Collection)e.getValue());
            buf.append("<tr><td><b>Session key</b>: ").append(skey.toBase64()).append("</td><td><b># Sets:</b> ").append(sets.size()).append("</td></tr><tr><td colspan=\"2\"><ul>");
            for (TagSet ts : sets) {
                size = ts.getTags().size();
                total += size;
                buf.append("<li><b>ID: ").append(ts.getID()).append(" Received:</b> ").append(DataHelper.formatDuration2(now - ts.getDate())).append(" ago with ");
                buf.append(size).append(" tags remaining</li>");
            }
            buf.append("</ul></td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        buf.append("<tr><th colspan=\"2\">Total tags: ").append(total).append(" (");
        buf.append(DataHelper.formatSize2(32 * total)).append("B)</th></tr>\n</table><h2><b>Outbound sessions</b></h2><table>");
        total = 0;
        Set<OutboundSession> outbound = this.getOutboundSessions();
        for (OutboundSession sess : outbound) {
            sets = new TreeSet<TagSet>(new TagSetComparator());
            sets.addAll(sess.getTagSets());
            buf.append("<tr><td><b>Target public key:</b> ").append(TransientSessionKeyManager.toString(sess.getTarget())).append("<br><b>Established:</b> ").append(DataHelper.formatDuration2(now - sess.getEstablishedDate())).append(" ago<br><b>Ack Received?</b> ").append(sess.getAckReceived()).append("<br><b>Last Used:</b> ").append(DataHelper.formatDuration2(now - sess.getLastUsedDate())).append(" ago<br><b>Session key:</b> ").append(sess.getCurrentKey().toBase64()).append("</td><td><b># Sets:</b> ").append(sess.getTagSets().size()).append("</td></tr><tr><td colspan=\"2\"><ul>");
            for (TagSet ts : sets) {
                size = ts.getTags().size();
                total += size;
                buf.append("<li><b>ID: ").append(ts.getID()).append(" Sent:</b> ").append(DataHelper.formatDuration2(now - ts.getDate())).append(" ago with ");
                buf.append(size).append(" tags remaining; acked? ").append(ts.getAcked()).append("</li>");
            }
            buf.append("</ul></td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        buf.append("<tr><th colspan=\"2\">Total tags: ").append(total).append(" (");
        buf.append(DataHelper.formatSize2(32 * total)).append("B)</th></tr>\n</table>");
        out.write(buf.toString());
    }

    private static String toString(PublicKey target) {
        if (target == null) {
            return "null";
        }
        return target.toBase64().substring(0, 20) + "...";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagSet
    implements TagSetHandle {
        private final Set<SessionTag> _sessionTags;
        private final SessionKey _key;
        private final long _date;
        private final int _id;
        private boolean _acked;

        public TagSet(Set<SessionTag> tags, SessionKey key, long date, int id) {
            if (key == null) {
                throw new IllegalArgumentException("Missing key");
            }
            if (tags == null) {
                throw new IllegalArgumentException("Missing tags");
            }
            this._sessionTags = tags;
            this._key = key;
            this._date = date;
            this._id = id;
        }

        public long getDate() {
            return this._date;
        }

        public Set<SessionTag> getTags() {
            return this._sessionTags;
        }

        public SessionKey getAssociatedKey() {
            return this._key;
        }

        public void consume(SessionTag tag) {
            this._sessionTags.remove(tag);
        }

        public SessionTag consumeNext() {
            SessionTag first;
            try {
                first = this._sessionTags.iterator().next();
            }
            catch (NoSuchElementException nsee) {
                return null;
            }
            this._sessionTags.remove(first);
            return first;
        }

        public void setAcked() {
            this._acked = true;
        }

        public boolean getAcked() {
            return this._acked;
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("TagSet #").append(this._id).append(" created: ").append(new Date(this._date));
            buf.append(" Session key: ").append(this._key);
            buf.append(" Size: ").append(this._sessionTags.size());
            buf.append(" Acked? ").append(this._acked);
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutboundSession {
        private final I2PAppContext _context;
        private final Log _log;
        private final PublicKey _target;
        private SessionKey _currentKey;
        private final long _established;
        private long _lastUsed;
        private final List<TagSet> _unackedTagSets;
        private final List<TagSet> _tagSets;
        private volatile boolean _acked;
        private int _consecutiveFailures;
        private static final int MAX_FAILS = 2;

        public OutboundSession(I2PAppContext ctx, Log log, PublicKey target) {
            this(ctx, log, target, null, ctx.clock().now(), ctx.clock().now(), new ArrayList<TagSet>());
        }

        OutboundSession(I2PAppContext ctx, Log log, PublicKey target, SessionKey curKey, long established, long lastUsed, List<TagSet> tagSets) {
            this._context = ctx;
            this._log = log;
            this._target = target;
            this._currentKey = curKey;
            this._established = established;
            this._lastUsed = lastUsed;
            this._unackedTagSets = tagSets;
            this._tagSets = new ArrayList<TagSet>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<TagSet> getTagSets() {
            ArrayList<TagSet> rv;
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                rv = new ArrayList<TagSet>(this._unackedTagSets);
                rv.addAll(this._tagSets);
            }
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ackTags(TagSet set) {
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                if (this._unackedTagSets.remove(set)) {
                    this._tagSets.add(set);
                } else if (this._log.shouldLog(30)) {
                    if (!this._tagSets.contains(set)) {
                        this._log.warn("Ack of unknown tagset: " + set);
                    } else if (set.getAcked()) {
                        this._log.warn("Dup ack of tagset: " + set);
                    }
                }
                this._acked = true;
                this._consecutiveFailures = 0;
            }
            set.setAcked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void failTags(TagSet set) {
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                this._unackedTagSets.remove(set);
                if (this._tagSets.remove(set) && ++this._consecutiveFailures >= 2) {
                    this._acked = false;
                    int acked = 0;
                    int unacked = 0;
                    Iterator<TagSet> iter = this._tagSets.iterator();
                    while (iter.hasNext()) {
                        TagSet ts = iter.next();
                        if (!ts.getAcked()) {
                            iter.remove();
                            this._unackedTagSets.add(ts);
                            ++unacked;
                            continue;
                        }
                        ++acked;
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this._consecutiveFailures + " consecutive failed tagset deliveries to " + this._currentKey + ": reverting to full ElG and un-acking " + unacked + " unacked tag sets, with " + acked + " remaining acked tag sets");
                    }
                }
            }
        }

        public PublicKey getTarget() {
            return this._target;
        }

        public SessionKey getCurrentKey() {
            return this._currentKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCurrentKey(SessionKey key) {
            this._lastUsed = this._context.clock().now();
            if (this._currentKey != null && !this._currentKey.equals(key)) {
                List<TagSet> list = this._tagSets;
                synchronized (list) {
                    if (this._log.shouldLog(30)) {
                        int dropped = 0;
                        for (TagSet set : this._tagSets) {
                            dropped += set.getTags().size();
                        }
                        this._log.warn("Rekeyed from " + this._currentKey + " to " + key + ": dropping " + dropped + " session tags", new Exception());
                    }
                    this._acked = false;
                    this._tagSets.clear();
                }
            }
            this._currentKey = key;
        }

        public long getEstablishedDate() {
            return this._established;
        }

        public long getLastUsedDate() {
            return this._lastUsed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int expireTags() {
            long now = this._context.clock().now();
            int removed = 0;
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                TagSet set;
                Iterator<TagSet> iter = this._tagSets.iterator();
                while (iter.hasNext()) {
                    set = iter.next();
                    if (set.getDate() + 600000L > now) continue;
                    iter.remove();
                    ++removed;
                }
                if ((now & 0xFL) == 0L) {
                    iter = this._unackedTagSets.iterator();
                    while (iter.hasNext()) {
                        set = iter.next();
                        if (set.getDate() + 600000L > now) continue;
                        iter.remove();
                        ++removed;
                    }
                }
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionTag consumeNext() {
            long now;
            this._lastUsed = now = this._context.clock().now();
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                while (!this._tagSets.isEmpty()) {
                    TagSet set = this._tagSets.get(0);
                    if (set.getDate() + 600000L > now) {
                        SessionTag tag = set.consumeNext();
                        if (tag != null) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("OB Tag consumed: " + tag + " from: " + set);
                            }
                            return tag;
                        }
                        if (this._log.shouldLog(20)) {
                            this._log.info("Removing empty " + set);
                        }
                    } else if (this._log.shouldLog(20)) {
                        this._log.info("Expired " + set);
                    }
                    this._tagSets.remove(0);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int availableTags() {
            int tags = 0;
            long now = this._context.clock().now();
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                for (int i = 0; i < this._tagSets.size(); ++i) {
                    TagSet set = this._tagSets.get(i);
                    if (set.getDate() + 600000L <= now) continue;
                    int sz = set.getTags().size();
                    if (!set.getAcked()) {
                        sz = (sz + 2) / 3;
                    }
                    tags += sz;
                }
            }
            return tags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastExpirationDate() {
            long last = 0L;
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                for (TagSet set : this._tagSets) {
                    if (set.getDate() <= last || set.getTags().isEmpty()) continue;
                    last = set.getDate();
                }
            }
            if (last > 0L) {
                return last + 600000L;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTags(TagSet set) {
            this._lastUsed = this._context.clock().now();
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                if (this._acked) {
                    this._tagSets.add(set);
                } else {
                    this._unackedTagSets.add(set);
                }
            }
        }

        public boolean getAckReceived() {
            return this._acked;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagSetComparator
    implements Comparator<TagSet> {
        private TagSetComparator() {
        }

        @Override
        public int compare(TagSet l, TagSet r) {
            return (int)(l.getDate() - r.getDate());
        }
    }

    private class CleanupEvent
    implements SimpleTimer.TimedEvent {
        private CleanupEvent() {
        }

        public void timeReached() {
            if (!TransientSessionKeyManager.this._alive) {
                return;
            }
            long beforeExpire = TransientSessionKeyManager.this._context.clock().now();
            int expired = TransientSessionKeyManager.this.aggressiveExpire();
            long expireTime = TransientSessionKeyManager.this._context.clock().now() - beforeExpire;
            TransientSessionKeyManager.this._context.statManager().addRateData("crypto.sessionTagsExpired", expired, expireTime);
            SimpleScheduler.getInstance().addEvent(this, 60000L);
        }
    }
}

